Attribute VB_Name = "modPrintSpool"
' --------------------------------------------------------------------------------
' This sample shows you how use EnumJobs Windows API function to
' monitor print jobs in the any printer spool.
'
' The sample's interface emulates Windows printer spool monitor application
'
' Created with VB6 but can be adopted to VB5 in no time.
' --------------------------------------------------------------------------------
' Author     : Serge Baranovsky
' Email      : sergeb@vbcity.com
' Web        : http://www.vbcity.com/
' Date       : 01-07-2000
' --------------------------------------------------------------------------------
Option Explicit

Declare Function OpenPrinter Lib "winspool.drv" Alias "OpenPrinterA" _
    (ByVal pPrinterName As String, phPrinter As Long, pDefault As Any) As Long

Declare Function ClosePrinter Lib "winspool.drv" (ByVal hPrinter As Long) As Long

Declare Function EnumJobs Lib "winspool.drv" Alias "EnumJobsA" _
    (ByVal hPrinter As Long, ByVal FirstJob As Long, ByVal NoJobs As Long, _
    ByVal Level As Long, pJob As Any, ByVal cdBuf As Long, _
    pcbNeeded As Long, pcReturned As Long) As Long

Type SYSTEMTIME
  wYear         As Integer
  wMonth        As Integer
  wDayOfWeek    As Integer
  wDay          As Integer
  wHour         As Integer
  wMinute       As Integer
  wSecond       As Integer
  wMilliseconds As Integer
End Type

Type JOB_INFO_1
  JobId        As Long
  pPrinterName As Long
  pMachineName As Long
  pUserName    As Long
  pDocument    As Long
  pDatatype    As Long
  pStatus      As Long
  Status       As Long
  Priority     As Long
  Position     As Long
  TotalPages   As Long
  PagesPrinted As Long
  Submitted    As SYSTEMTIME
End Type

Public Const JOB_STATUS_PAUSED = &H1
Public Const JOB_STATUS_ERROR = &H2
Public Const JOB_STATUS_DELETING = &H4
Public Const JOB_STATUS_SPOOLING = &H8
Public Const JOB_STATUS_PRINTING = &H10
Public Const JOB_STATUS_OFFLINE = &H20
Public Const JOB_STATUS_PAPEROUT = &H40
Public Const JOB_STATUS_PRINTED = &H80
Public Const JOB_STATUS_DELETED = &H100
Public Const JOB_STATUS_BLOCKED_DEVQ = &H200
Public Const JOB_STATUS_USER_INTERVENTION = &H400     ' Windows 95 Only

Public Const NO_PRIORITY = 0
Public Const MAX_PRIORITY = 99
Public Const MIN_PRIORITY = 1
Public Const DEF_PRIORITY = 1

Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" _
    (Destination As Any, _
    Source As Any, _
    ByVal Length As Long)

Declare Function lstrcpy Lib "kernel32" Alias "lstrcpyA" _
    (lpString1 As Any, _
    lpString2 As Any) As Long

Public Function IsPrinterQueueEmpty(strPrinter As String) As Boolean
  IsPrinterQueueEmpty = GetPrinterJobsCount(strPrinter) = 0
End Function

Public Function GetPrinterJobsCount(strPrinter As String) As Long
  Dim hPrinter As Long
  Dim lngJobsFirstJob As Long, lngJobsEnumJob As Long, lngJobsLevel As Long
  Dim lngJobsNeeded As Long, lngJobsReturned As Long
  Dim udtJobInfo1() As JOB_INFO_1
  Dim lngJobsCount As Long
  Dim lngResult As Long
  
  lngResult = OpenPrinter(strPrinter, hPrinter, ByVal vbNullString)

  lngJobsFirstJob = 0 ' zero-based position within the print queue of the first print job to enumerate
  
  lngJobsEnumJob = 99 ' total number of print jobs to enumerate
  
  lngJobsLevel = 1    ' Specifies whether the function should use JOB_INFO_1
                      ' or JOB_INFO_2 structures to store data for the enumerated jobs

  lngResult = EnumJobs(hPrinter, lngJobsFirstJob, lngJobsEnumJob, _
                       lngJobsLevel, ByVal vbNullString, 0, _
                       lngJobsNeeded, lngJobsReturned)

  ' Check out the number of jobs hypothetically will be returned
  If lngJobsNeeded > 0 Then

    ReDim byteJobsBuffer(lngJobsNeeded - 1)
    ReDim udtJobInfo1(lngJobsNeeded - 1)

    lngResult = EnumJobs(hPrinter, lngJobsFirstJob, lngJobsEnumJob, _
                         lngJobsLevel, byteJobsBuffer(0), lngJobsNeeded, _
                         lngJobsNeeded, lngJobsReturned)

    ' Check out the number of jobs returned
    If lngJobsReturned > 0 Then
      lngJobsCount = lngJobsReturned
    Else
      ' number of jobs returned = 0 (no jobs)
      lngJobsCount = 0
    End If
  Else
    ' number of jobs = 0 (no jobs)
    lngJobsCount = 0
  End If
  lngResult = ClosePrinter(hPrinter)

  GetPrinterJobsCount = lngJobsCount
End Function
