Attribute VB_Name = "mReScale"
Option Explicit
Private nRescale As Integer

Public Sub scaleForm(pForm As Form, Optional nWidth As Long = 800, Optional nHeight As Long = 600)
Dim lnHeight As Long, lnWidth As Long, dFactorX As Double, dFactorY As Double
Dim pControl As Control, dFontFactor As Double

  If nRescale = 0 Then
    nRescale = Val(GetSetting("VSL", "Config", "AjustarResolucion", "3"))
    If nRescale < 2 Then Exit Sub
  End If

  lnHeight = Screen.Height / Screen.TwipsPerPixelY
  lnWidth = Screen.Width / Screen.TwipsPerPixelX
  dFactorX = CDbl(lnWidth) / nWidth
  dFactorY = CDbl(lnHeight) / nHeight

  If nRescale = 3 Then
    If dFactorX >= 1 Then Exit Sub
    If Screen.Width >= pForm.Width And Screen.Height >= pForm.Height Then
      Exit Sub
    End If
  End If

  If dFactorY < 1 Then
    dFontFactor = 1 '0.9
  Else
    dFontFactor = 1
  End If

  pForm.Width = pForm.Width * dFactorX
  pForm.Height = pForm.Height * dFactorY
  
  For Each pControl In pForm.Controls
  
    On Error Resume Next
    pControl.top = pControl.top * dFactorY
    If Err.Number Then Err.Clear
    On Error Resume Next
    pControl.left = pControl.left * dFactorX
    If Err.Number Then Err.Clear
    
    On Error Resume Next
    pControl.Height = pControl.Height * dFactorY
    If Err.Number Then Err.Clear
    
    On Error Resume Next
    pControl.Width = pControl.Width * dFactorX
    If Err.Number Then Err.Clear

    On Error Resume Next
    If dFactorY < 1 Then
      If pControl.Font.Name = "MS Sans Serif" Then
        On Error Resume Next
        pControl.Font.Name = "Arial" ' Para que acepte escalado "fino"
        If Err.Number Then Err.Clear
      End If
    End If

    On Error Resume Next
    pControl.Font.Size = pControl.Font.Size * dFactorY * dFontFactor
    If Err.Number Then Err.Clear

    If TypeName(pControl) = "Line" Then
      pControl.X1 = pControl.X1 * dFactorX
      pControl.X2 = pControl.X2 * dFactorX
      pControl.Y1 = pControl.Y1 * dFactorY
      pControl.Y2 = pControl.Y2 * dFactorY
      pControl.BorderWidth = pControl.BorderWidth * dFactorY
      If pControl.BorderWidth = 0 Then pControl.BorderWidth = 1
    End If

    If TypeName(pControl) = "MSFlexGrid" Then
    Dim l As Long
      pControl.RowHeightMin = pControl.RowHeightMin * dFactorX
      For l = 0 To pControl.Cols
        pControl.ColWidth(l) = pControl.ColWidth(l) * dFactorX
      Next
    End If
    
    If TypeName(pControl) = "ucFramedLabel" Then
      pControl.OffsetX = pControl.OffsetX * dFactorX
      pControl.OffsetY = pControl.OffsetY * dFactorY
    End If
  Next
  
End Sub
