Attribute VB_Name = "mLex"
Option Explicit

Public Enum SYM_TYPE
    SYMTYPE_ERR = 0
    SYMTYPE_QLIT = 1
    SYMTYPE_VARID = 2
    SYMTYPE_NUMERO = 3
    SYMTYPE_ASSIGN = 4
    SYMTYPE_LPARENS = 5
    SYMTYPE_RPARENS = 6
    SYMTYPE_OPR = 7
    SYMTYPE_SEP = 8
    SYMTYPE_NULL = 127
End Enum

' Modifica sArg (lo deja al inicio del proximo simbolo),
' coloca la siguiente unidad lxica en sDest
' Devuelve el tipo de simbolo encontrado
Public Function Lex(sArg As String, sDest As String) As SYM_TYPE
Dim pPos As Integer, iPos As Integer, sTemp As String
Dim ch As String

    sArg = Trim(sArg)   ' Elimina los espacios
    iPos = 1
    Do While Mid(sArg, iPos, 1) = " " Or Mid(sArg, iPos, 1) = Chr(9)
        iPos = iPos + 1
    Loop
        
    sArg = Right(sArg, Len(sArg) - (iPos - 1))
    ch = Left(sArg, 1)

    If ch = "'" Then ch = ""    ' Skip comentarios

    If ch = "" Then
        sDest = ""
        Lex = SYMTYPE_NULL
        Exit Function
    End If

    If ch = "(" Or ch = "[" Then
        Lex = SYMTYPE_LPARENS
        sDest = ch
        sArg = Right(sArg, Len(sArg) - 1)
        Exit Function
    End If

    If ch = ")" Or ch = "]" Then
        Lex = SYMTYPE_RPARENS
        sDest = ch
        sArg = Right(sArg, Len(sArg) - 1)
        Exit Function
    End If

    If InStr(1, "+-^*/><%*", ch) <> 0 Then
        Lex = SYMTYPE_OPR
        sDest = Left(sArg, 1)
        sArg = Right(sArg, Len(sArg) - 1)
        Exit Function
    End If

    If InStr(1, ",;:.", ch) <> 0 Then
        Lex = SYMTYPE_SEP
        sDest = Left(sArg, 1)
        sArg = Right(sArg, Len(sArg) - 1)
        Exit Function
    End If
    
    If ch = Chr(34) Then ' QuotedLiteral
        pPos = InStr(2, sArg, Chr(34))
        If pPos = 0 Then
            Lex = SYMTYPE_ERR
            Exit Function
        End If
        sTemp = Mid(sArg, 2, pPos - 2)
        sArg = Right(sArg, Len(sArg) - pPos)
        
        sDest = sTemp
        Lex = SYMTYPE_QLIT
        Exit Function
    End If

    If ch = "=" Then
        sTemp = "="
        sArg = Right(sArg, Len(sArg) - iPos)
        sDest = sTemp
        Lex = SYMTYPE_ASSIGN
        Exit Function
    End If

    sTemp = sArg
    If Left(sTemp, 1) = "_" Or (Left(UCase(sTemp), 1) >= "A" And Left(UCase(sTemp), 1) <= "Z") Then
        sTemp = strtok(sTemp, Chr(34) & " ,.-+/*\&()[]{}'=<>;:")
        sDest = Trim(sTemp)
        iPos = Len(sDest)
        sArg = Right(sArg, Len(sArg) - iPos)
        Lex = SYMTYPE_VARID
        Exit Function
    End If

    If ch >= "0" And ch <= "9" Then
        iPos = 1
        Do While (Mid(sArg, iPos, 1) >= "0" And Mid(sArg, iPos, 1) <= "9") Or Mid(sArg, iPos, 1) = "."
            iPos = iPos + 1
        Loop
        sDest = Left(sArg, iPos - 1)
        sArg = Right(sArg, Len(sArg) - iPos + 1)
        Lex = SYMTYPE_NUMERO
        Exit Function
    End If

    sDest = ""
    Lex = SYMTYPE_ERR

End Function

