Attribute VB_Name = "mGlobalLock"
Option Explicit

'---------------------------------------------------------------------------------------
' Module    : mGlobalLock
' DateTime  : 12/03/03 18:20
' Author    : Leonardo Azpurua
' Purpose   : Establece una seal global de bloqueo, implementada como la existencia
'             del archivo "sem.sys" en el directorio de trabajo de la aplicacin.
'             Para controlar la duracin de cada intento, se debe especificar la dura-
'             cin en segundos en la clave
'               HKCU\Software\VB And VBA Program Settings\VSL\Config\LockTimeOut
'             Si no est especificada, se asumen 15 segundos.
'             Para determinar el origen del bloqueo, sem.sys contiene el ID del usuario
'             activo (requiere la definicin de UsuarioActivo) y la hora en que inici
'             Mientras hay un bloqueo activo, se interceptan las llamadas a
'             "mAdvertencia" y "ReportarError" (cuando no es fatal).
'---------------------------------------------------------------------------------------

Private TIME_OUT As Integer
Private isMyLock As Boolean

Private qLocks As Integer
Private MensajesError() As String
Private qMensajesError As Integer
Private TiposDoc() As String
Private NumerosDoc() As Long
Private qDocs As Integer

Private Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)

'---------------------------------------------------------------------------------------
' Sub SubmitDoc
' Fecha/Hora: 12/04/03 15:30
' Funcin   : Coloca un documento en la "cola de impresin". Permite que los documentos
'             generados durante una transaccin sean acumulados en un bfer, y luego
'             emitidos al cerrar
'---------------------------------------------------------------------------------------
'
Public Sub SubmitDoc(pDoc As Object)
  If Not isMyLock Then
    Dim AutoPrint As Boolean
    AutoPrint = CBool(GetSetting(AppName, "General\Autoprint", TypeName(pDoc), "0"))
    pDoc.ViewPrint AutoPrint
  Else
    qDocs = qDocs + 1
    ReDim Preserve TiposDoc(qDocs)
    ReDim Preserve NumerosDoc(qDocs)
    TiposDoc(qDocs) = pDoc.TipoEntidad
    NumerosDoc(qDocs) = pDoc.Numero
  End If
End Sub

'---------------------------------------------------------------------------------------
' Function SetGlobalLock
' Fecha/Hora: 12/03/03 18:03
' Funcin   : Implementa el mecanismo de bloqueo descrito en el encabezado
'---------------------------------------------------------------------------------------
'
Public Function SetGlobalLock(Optional sOperacion As String = "") As Boolean
Dim dueTime As Single, sFileName As String, sSemData As String
Dim fHandle As Integer, r As Integer

  If isMyLock Then
    SetGlobalLock = True
    qLocks = qLocks + 1
    Exit Function
  End If

  qLocks = 1
  isMyLock = True
  qMensajesError = 0
  qDocs = 0
  ReDim TiposDoc(0)
  ReDim NumerosDoc(0)
  ReDim MensajesError(0)
  SetGlobalLock = True
End Function

'---------------------------------------------------------------------------------------
' Sub FreeGlobalLock
' Fecha/Hora: 12/03/03 18:16
' Funcin   : Libera el semforo. Si esta instancia tiene ms de un bloqueo, decrementa
'             el conteo y lo conserva.
'---------------------------------------------------------------------------------------
'
Public Sub FreeGlobalLock()
Dim sFileName As String
Dim pInstancer As clsInstanciadorEntidad, pDoc As Object, i As Integer

  If Not isMyLock Then Exit Sub
  qLocks = qLocks - 1
  If qLocks > 0 Then Exit Sub
  isMyLock = False
  DumpErrors

  Set pInstancer = New clsInstanciadorEntidad
  For i = 1 To qDocs
    Set pDoc = pInstancer.EntidadDOCUMENTO(TiposDoc(i), NumerosDoc(i))
    If Not pDoc Is Nothing Then
      Dim AutoPrint As Boolean
      AutoPrint = CBool(GetSetting(AppName, "General\Autoprint", TypeName(pDoc), "0"))
      pDoc.ViewPrint AutoPrint
    End If
    Set pDoc = Nothing
  Next
  Set pInstancer = Nothing
  qDocs = 0
  ReDim TiposDoc(0)
  ReDim NumerosDoc(0)
End Sub

'---------------------------------------------------------------------------------------
' Sub DumpErrors
' Fecha/Hora: 12/03/03 18:18
' Funcin   : Vuelca las advertencias y errores registrados durante el bloqueo
'---------------------------------------------------------------------------------------
'
Private Sub DumpErrors()
Dim i As Integer, sText As String

  If qMensajesError Then
    sText = "Se produjeron los siguientes errores durante la operacion" & vbCrLf
    For i = 1 To qMensajesError
      sText = sText & Trim(i) & ": " & MensajesError(i) & vbCrLf
    Next
    mAdvertencia sText
  End If
  qMensajesError = 0
  ReDim MensajesError(qMensajesError)

End Sub

'---------------------------------------------------------------------------------------
' Sub mAdvertencia
' Fecha/Hora: 12/03/03 18:18
' Funcin   : Intercpeta las llamadas a mAdvertencia desde la App.
'             Si no se est en un Lock, las transfiere al componente original, de lo
'             contrario, las coloca en una cola.
'---------------------------------------------------------------------------------------
'
Public Sub mAdvertencia(s As String)
  If Not isMyLock Then
    vslib.mAdvertencia s
  Else
    qMensajesError = qMensajesError + 1
    ReDim Preserve MensajesError(qMensajesError)
    MensajesError(qMensajesError) = s
  End If
End Sub

'---------------------------------------------------------------------------------------
' Sub ReportarError
' Fecha/Hora: 12/03/03 18:19
' Funcin   : Intercpeta las llamadas a ReportarError desde la App.
'             Si no se est en un Lock, las transfiere al componente original, de lo
'             contrario, las coloca en una cola.
'             Si es un error fatal, lo reporta de inmediato
'---------------------------------------------------------------------------------------
'
Public Sub ReportarError(isFatal As Boolean, nNumError As Long, stDescripcion As String, stLocus As String)
Dim stMensaje As String

  If isFatal Or Not isMyLock Then
    vslib.ReportarError isFatal, nNumError, stDescripcion, stLocus
    Exit Sub
  End If

  stMensaje = "ERROR INTERNO (" & nNumError & "):" & Chr(13)
  stMensaje = stMensaje & "    Descripcion: " & stDescripcion & Chr(13)
  stMensaje = stMensaje & "    Ubicacion: " & stLocus
  mAdvertencia stMensaje
End Sub

'---------------------------------------------------------------------------------------
' Sub ReleaseGlobalLock
' Fecha/Hora: 12/03/03 19:08
' Funcin   : Nombre alternativo para FreeGlobalLock (remedio para el despiste)
'---------------------------------------------------------------------------------------
'
Public Sub ReleaseGlobalLock()
  FreeGlobalLock
End Sub
