Attribute VB_Name = "mGlassifyForm"
Option Explicit

Private Declare Function CreateRectRgn Lib "gdi32" (ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function CombineRgn Lib "gdi32" (ByVal hDestRgn As Long, ByVal hSrcRgn1 As Long, ByVal hSrcRgn2 As Long, ByVal nCombineMode As Long) As Long
Private Declare Function SetWindowRgn Lib "user32" (ByVal hwnd As Long, ByVal hRgn As Long, ByVal bRedraw As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long

Public Sub GlassifyForm(frmDest As Form)
Const RGN_DIFF = 4
Const RGN_OR = 2
Dim outRGN As Long
Dim inRGN As Long
Dim mWidth As Single
Dim mHeight As Single
Dim mBorderWidth As Single
Dim mTitleHeight As Single
Dim mControlLeft As Single
Dim mControlTop As Single
Dim mControlRight As Single
Dim mControlBottom As Single
Dim mControlRgn As Long
Dim mRgn As Long
Dim mControl As Control

  With frmDest
    If .WindowState = vbMinimized Then Exit Sub
    mWidth = .ScaleX(.Width, vbTwips, vbPixels)
    mHeight = .ScaleY(.Height, vbTwips, vbPixels)
    outRGN = CreateRectRgn(0, 0, mWidth, mHeight)
    mBorderWidth = (mWidth - .ScaleX(.ScaleWidth, vbTwips, vbPixels)) / 2
    mTitleHeight = mHeight - mBorderWidth - .ScaleY(.ScaleHeight, vbTwips, vbPixels)
    inRGN = CreateRectRgn( _
                      mBorderWidth, _
                      mTitleHeight, _
                      mWidth - mBorderWidth, _
                      mHeight - mBorderWidth)
    mRgn = CreateRectRgn(0, 0, 0, 0)
    CombineRgn mRgn, outRGN, inRGN, RGN_DIFF
    For Each mControl In .Controls
        If Not TypeOf mControl Is Timer Then
            mControlLeft = .ScaleX(mControl.Left, .ScaleMode, vbPixels) + mBorderWidth
            mControlTop = .ScaleX(mControl.Top, .ScaleMode, vbPixels) + mTitleHeight
            mControlRight = .ScaleX(mControl.Width, .ScaleMode, vbPixels) + mControlLeft
            mControlBottom = .ScaleX(mControl.Height, .ScaleMode, vbPixels) + mControlTop
            mControlRgn = CreateRectRgn(mControlLeft, mControlTop, mControlRight, mControlBottom)
            CombineRgn mRgn, mRgn, mControlRgn, RGN_OR
            DeleteObject mControlRgn
        End If
    Next mControl
    SetWindowRgn .hwnd, mRgn, True
    DeleteObject mRgn
  End With

End Sub



