Attribute VB_Name = "lmdbHandle"
' Variables y Funciones dependientes de la base de Datos

Option Explicit

Public dbHandle As ADODB.Connection '  clsConnWrapper
Public Notificador As New CNotificadorTransaccion

Public nTransactions As Integer ' Para detectar y prevenir transacciones anidadas

Public Enum lmdbProvider
    DBPROVIDER_UNDEF = 0
    DBPROVIDER_JET = 1
    DBPROVIDER_SQL = 2
    DBPROVIDER_MYSQL = 3
End Enum

Public Const LOCK_TIMEOUT = 30

Private dbhandleProvider As lmdbProvider

'Public Function SetUpDatabase()
'  Select Case DBProviderID
'    Case DBPROVIDER_UNDEF
'
'    Case DBPROVIDER_JET
'
'    Case DBPROVIDER_SQL
'
'    Case DBPROVIDER_MYSQL
'      dbHandle.Execute "SET CHARACTER SET utf8"
'  End Select
'End Function

Private Function UseTransactions() As Boolean
Static isInit As Boolean
Static doTransacciones As Boolean

  If Not isInit Then
    isInit = True
    doTransacciones = CBool(GetSetting("VSL", "Config", "Transacciones", "-1"))
  End If

  UseTransactions = doTransacciones
End Function

Public Function ErrorMessages() As String
  Dim s As String, ae As ADODB.Error
  For Each ae In dbHandle.Errors
    If s <> "" Then s = s & vbCrLf
    s = s & ae.Description
  Next
  ErrorMessages = s
End Function

Public Function DBProviderCode(Optional pConnection As Connection = Nothing) As String
Dim dbp As lmdbProvider, s As String
  dbp = DBProviderID(pConnection)
  Select Case dbp
    Case DBPROVIDER_UNDEF
      s = "INDEFINIDO"
    Case DBPROVIDER_JET
      s = "Microsoft Jet (Access)"
    Case DBPROVIDER_SQL
      s = "Microsoft SQL Server"
    Case DBPROVIDER_MYSQL
      s = "mySQL"
  End Select
  DBProviderCode = s
End Function

Public Function DBProviderID(Optional pConnection As Connection = Nothing) As lmdbProvider
Dim istr As String

    If pConnection Is Nothing Then Set pConnection = dbHandle

    On Error GoTo ErrHandler

    istr = UCase(left(pConnection.Properties("Provider Name").value, 5))
    Select Case istr
    Case "MSJET"    ' MSJETOLEDBxx.DLL"
        dbhandleProvider = DBPROVIDER_JET
    Case "SQLOL"    ' SQLOLEDB.DLL
        dbhandleProvider = DBPROVIDER_SQL
    Case "MSDAS"
        dbhandleProvider = DBPROVIDER_MYSQL
    Case Else
        dbhandleProvider = DBPROVIDER_UNDEF
    End Select
    
ResumePoint:
    DBProviderID = dbhandleProvider
    Exit Function

ErrHandler:     ' Supongo que slo cae aqu si "ProviderName" no es una propiedad valida
    ReportException "Propiedad 'Provider Name' invlida para origen de datos"
    dbhandleProvider = DBPROVIDER_UNDEF
    Resume ResumePoint

End Function

Public Function fldType(istrFldName As String, istrTableName As String) As String
Dim rs As ADODB.Recordset, sRetVal As String

    On Error GoTo ErrHandler
    Select Case DBProviderID
      Case DBPROVIDER_UNDEF
        sRetVal = "UNDEF"
      Case DBPROVIDER_JET, DBPROVIDER_SQL
        Set rs = dbHandle.Execute("SELECT * FROM INFORMATION_SCHEMA.Columns WHERE TABLE_NAME = " & StringDB(istrTableName) & " AND COLUMN_NAME = " & StringDB(istrFldName))
        If rs.EOF Then
            sRetVal = "<INVALIDO>"
        Else
            sRetVal = rs.Fields("DATA_TYPE")
        End If
        rs.Close
      Case DBPROVIDER_MYSQL
        Set rs = dbHandle.Execute("SHOW COLUMNS FROM " & istrTableName & " LIKE '" & istrFldName & "'")
        If rs.EOF Then
            sRetVal = "<INVALIDO>"
        Else
            sRetVal = rs.Fields("Type")
        End If
        rs.Close
    End Select

ResumePoint:
    Set rs = Nothing
    fldType = sRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmdbHandle::fldType"
    sRetVal = "<INVALIDO>"
    Resume ResumePoint

End Function

Public Function isField(istrCandidato As String, istrTableName As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean

  On Error GoTo ErrHandler
  Select Case DBProviderID
    Case DBPROVIDER_UNDEF
      bRetVal = False
    Case DBPROVIDER_JET, DBPROVIDER_SQL
      Set rs = dbHandle.Execute("SELECT COLUMN_NAME From INFORMATION_SCHEMA.Columns WHERE TABLE_NAME = " & StringDB(istrTableName) & " AND COLUMN_NAME = " & StringDB(istrCandidato))
      If rs.EOF Then
        bRetVal = False
      Else
        bRetVal = True
      End If
      rs.Close
    Case DBPROVIDER_MYSQL
      Set rs = dbHandle.Execute("SHOW COLUMNS FROM " & istrTableName & " LIKE '" & istrCandidato & "'")
      If rs.EOF Then
        bRetVal = False
      Else
        bRetVal = True
      End If
      rs.Close
  End Select

ResumePoint:
  Set rs = Nothing
  isField = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "lmdbHandle::isField"
  bRetVal = False
  Resume ResumePoint
End Function

Public Function TipoCampoVB(i As Integer) As String

    TipoCampoVB = "UNSUPPORTED: TipoCampoVB"

End Function

Public Function VarDB(v As Variant) As String
Dim s As String

  Select Case VarType(v)
  Case vbDate
    s = FechaDB(CDate(v))
  Case vbString
    s = StringDB(CStr(v))
  Case vbBoolean
    s = BooleanDB(CBool(v))
  Case vbInteger, _
     vbLong, _
     vbSingle, _
     vbDouble, _
     vbCurrency, _
     vbDecimal, _
     vbByte
        s = Trim(Str(v))
  Case Else
    s = StringDB(GetStringFromVariant(v))
    If s = "" Then s = "NULL"
  End Select
  VarDB = s
End Function

Public Function FechaDB(Fecha As Date) As String
Dim sRet As String
    
  Select Case DBProviderID
  Case DBPROVIDER_JET
    sRet = "#" & Format(Fecha, "yyyy-mm-dd") & "#"
  Case DBPROVIDER_SQL
    sRet = "{d '" & Format(Fecha, "yyyy-mm-dd") & "'}"
  Case DBPROVIDER_MYSQL
    sRet = "'" & Format(Fecha, "yyyy-mm-dd") & "'"
  Case Else
    sRet = "( DATE '" & Format(Fecha, "yyyy-mm-dd") & "')"
  End Select
  FechaDB = sRet
  
End Function

Public Function TimeDB(iTime As Date) As String
Dim sRet As String
  Select Case DBProviderID
  Case DBPROVIDER_JET
    sRet = "#" & Format(iTime, "hh:mm") & "#"
  Case DBPROVIDER_SQL
    sRet = "'" & Format(iTime, "hh:mm") & "'"
  Case DBPROVIDER_MYSQL
    sRet = "'" & Format(iTime, "hh:mm") & "'"
  Case Else
    sRet = "(TIME '" & Format(iTime, "hh:mm") & "')"
  End Select
  
  TimeDB = sRet
End Function

Public Function TimeDateDB(Fecha As Date) As String
Dim sRet As String

  Select Case DBProviderID
  Case DBPROVIDER_JET
    sRet = "#" & Format(Fecha, "yyyy-mm-dd hh:mm") & "#"
  Case DBPROVIDER_SQL
    sRet = "{ts '" & Format(Fecha, "yyyy-mm-dd hh:mm:ss") & "'}"
  Case DBPROVIDER_MYSQL
    sRet = "'" & Format(Fecha, "yyyy-mm-dd hh:mm") & "'"
  Case Else
    sRet = "(DATE '" & Format(Fecha, "yyyy-mm-dd hh:mm") & "')"
  End Select
  
  TimeDateDB = sRet
  
End Function

Public Function BooleanDB(bArg As Boolean) As String
  BooleanDB = IIf(bArg, "1", "0")
End Function

Public Function StringDB(starg As String) As String
Dim cDelimiter As String, i As Long, l As Integer
Dim sRetVal As String

  sRetVal = starg
  Select Case DBProviderID
    Case DBPROVIDER_UNDEF
      sRetVal = "'" & Replace(sRetVal, "'", "\'") & "'"
    Case DBPROVIDER_JET, DBPROVIDER_SQL
      sRetVal = "'" & Replace(sRetVal, "'", "''") & "'"
    Case DBPROVIDER_MYSQL
      sRetVal = "'" & Replace(sRetVal, "'", "\'") & "'"
  End Select
  StringDB = sRetVal
  
End Function

Public Function NumeroDB(ByVal dblArg As Double) As String
  NumeroDB = Trim(Str(dblArg))
End Function

Public Function StartTransaction() As Boolean
  If Not UseTransactions Then
    StartTransaction = True
    Exit Function
  End If
  
  If nTransactions = 0 Then
    dbHandle.BeginTrans
  End If
  
  nTransactions = nTransactions + 1
  Notificador.NotificarCambioTransaccion nTransactions, "Start"
  StartTransaction = True
End Function

Public Function CommitTransaction() As Boolean
  If Not UseTransactions Then
    CommitTransaction = True
    Exit Function
  End If
  
  If nTransactions = 0 Then
    VSLIB.LogException "Mismatch en CommitTransaction: " & Now
    CommitTransaction = False
    Exit Function
  End If
  
  nTransactions = nTransactions - 1
  If nTransactions = 0 Then
    dbHandle.CommitTrans
  End If
  Notificador.NotificarCambioTransaccion nTransactions, "Commit"
  CommitTransaction = True
End Function

Public Function AbortTransaction() As Boolean
  If Not UseTransactions Then
    AbortTransaction = True
    Exit Function
  End If
  
  If nTransactions = 0 Then
    VSLIB.LogException "Mismatch en AbortTransaction: " & Now
    AbortTransaction = False
    Exit Function
  End If
  
  nTransactions = nTransactions - 1
  If nTransactions = 0 Then
    dbHandle.RollbackTrans
  End If
  Notificador.NotificarCambioTransaccion nTransactions, "Abort"
  AbortTransaction = True
  
End Function

' ------------------------------------------------
' Funciones dependientes del proveedor
' ------------------------------------------------
Public Function NextRecord(istrTableName As String, istrCodeName As String, istrActualCode As String, Optional adoOptions As Long = -1) As Recordset
Dim rs As Recordset, sQuery As String

  Select Case DBProviderID
  Case DBPROVIDER_MYSQL
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " > " & StringDB(istrActualCode) & " ORDER BY " & istrCodeName & " LIMIT 1"
  Case Else
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " IN (Select MIN(" & istrCodeName & ") FROM " & istrTableName & " WHERE " & istrCodeName & " > " & StringDB(istrActualCode) & ")"
  End Select
  
  Set rs = dbHandle.Execute(sQuery, , adoOptions)
  Set NextRecord = rs
End Function

Public Function PrevRecord(istrTableName As String, istrCodeName As String, istrActualCode As String, Optional adoOptions As Long = -1) As Recordset
Dim rs As Recordset, sQuery As String

  Select Case DBProviderID
  Case DBPROVIDER_MYSQL
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " < " & StringDB(istrActualCode) & " ORDER BY " & istrCodeName & " DESC LIMIT 1"
  Case Else
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " IN (Select MAX(" & istrCodeName & ") FROM " & istrTableName & " WHERE " & istrCodeName & " < " & StringDB(istrActualCode) & ")"
  End Select

  Set rs = dbHandle.Execute(sQuery, , adoOptions)
  Set PrevRecord = rs
End Function

Public Function dbexprBinSelect(sColID As String, sColVal As String, sIfTrue As String, sIfFalse As String) As String
Dim sRetVal As String
  
  Select Case DBProviderID
  Case DBPROVIDER_UNDEF
    sRetVal = "UNDEF: dbexprBinSelect"
  Case DBPROVIDER_JET
    sRetVal = "Iif(" & sColID & " = " & sColVal & ", " & sIfTrue & ", " & sIfFalse & ")"
  Case DBPROVIDER_SQL
    sRetVal = "CASE " & sColID & " WHEN  " & sColVal & " THEN " & sIfTrue & " ELSE " & sIfFalse & " END"
  Case DBPROVIDER_MYSQL
    sRetVal = "IF(" & sColID & " = " & sColVal & ", " & sIfTrue & ", " & sIfFalse & ")"
  End Select

  dbexprBinSelect = sRetVal

End Function

Public Function CountDistinct(ByVal TableName As String, ByVal Condiciones As String, ParamArray Columnas()) As String
Dim n As Integer, buf As New CStringBuffer

  Select Case DBProviderID
  Case DBPROVIDER_UNDEF, DBPROVIDER_SQL, DBPROVIDER_MYSQL
    buf = "SELECT COUNT(DISTINCT "
    For n = 0 To UBound(Columnas)
      If n > 0 Then
        buf.Append " + "
      End If
      buf.Append CStr(Columnas(n))
    Next
    buf.Append ") AS Valores FROM "
    buf.Append TableName
    If Condiciones <> "" Then
      buf.Append " WHERE "
      buf.Append Condiciones
    End If
  Case DBPROVIDER_JET
    buf = "SELECT COUNT(*) AS Valores FROM (SELECT DISTINCT "
    For n = 0 To UBound(Columnas)
      If n > 0 Then
        buf.Append ", "
      End If
      buf.Append CStr(Columnas(n))
    Next
    buf.Append " FROM "
    buf.Append TableName
    If Condiciones <> "" Then
      buf.Append " WHERE "
      buf.Append Condiciones
    End If
    buf.Append ")"
  End Select
  CountDistinct = buf
End Function


Public Function DBProximoNumero(istrTableName As String, istrFieldName As String) As Long
Dim rs As Recordset, sQuery As String, lngRetVal As Long

  sQuery = "SELECT MAX(" & istrFieldName & ") as Ultimo FROM " & istrTableName & ";"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    lngRetVal = 1
  Else
    lngRetVal = GetNumeroFromVariant(rs.Fields("Ultimo")) + 1
  End If
  rs.Close
  Set rs = Nothing
  
  DBProximoNumero = lngRetVal

End Function

