Attribute VB_Name = "lmdbHandle"
' Variables y Funciones dependientes de la base de Datos
Option Explicit

Public dbHandle As Database

Public Function OpenDatabase(sPath As String) As Database
Dim lngVal As Long, sPwd As String

  With DBEngine
  lngVal = Val(GetSetting("VSL", "CONFIG\dbOptions", "FlushTransactionTimeOut", "5"))
  .SetOption dbFlushTransactionTimeout, lngVal

  lngVal = Val(GetSetting("VSL", "CONFIG\dbOptions", "LockDelay", "50"))
  .SetOption dbLockDelay, lngVal
  
  lngVal = Val(GetSetting("VSL", "CONFIG\dbOptions", "LockRetry", "200"))
  .SetOption dbLockRetry, lngVal
  
  lngVal = Val(GetSetting("VSL", "CONFIG\dbOptions", "PageTimeOut", "16"))
  .SetOption dbPageTimeout, lngVal
  
  .SetOption dbUserCommitSync, GetSetting("VSL", "CONFIG\dbOptions", "UserCommitSync", "yes")
  .SetOption dbImplicitCommitSync, GetSetting("VSL", "CONFIG\dbOptions", "ImplicitCommitSync", "no")
  End With
  sPwd = GetSetting("VSL", "CONFIG", "DBPassword", "")
  If sPwd <> "" Then
    sPwd = ";pwd=" & simpleEncrypt(sPwd)
  End If
  On Error Resume Next
  Set OpenDatabase = Workspaces(0).OpenDatabase(sPath, False, False, sPwd)
  If Err.Number Then
    ReportarError True, Err.Number, Err.Description, "lmdbHandle::OpenDatabase"
    Set OpenDatabase = Nothing
  End If
  
End Function

Public Function fldType(istrFldName As String, istrTableName As String) As DAO.DataTypeEnum
Dim pQDef As TableDef, fld As Field, RetVal As DataTypeEnum

    On Error GoTo ErrHandler
    Set pQDef = dbHandle.TableDefs(istrTableName)
    Set fld = pQDef.Fields(istrFldName)
    
    RetVal = fld.Type

ResumePoint:
    Set fld = Nothing
    Set pQDef = Nothing

    fldType = RetVal
    Exit Function

ErrHandler:

    RetVal = 0
    Resume ResumePoint

End Function

Public Function isField(istrCandidato As String, istrTableName As String) As Boolean
Dim pFld As Field, tDef As TableDef, bRetVal As Boolean

    Set tDef = dbHandle.TableDefs(istrTableName)
    On Error GoTo NoField
    bRetVal = True
    Set pFld = tDef.Fields(istrCandidato)

ResumePoint:
    Set pFld = Nothing
    Set tDef = Nothing
    isField = bRetVal
    Exit Function

NoField:
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function TipoCampoVB(i As Integer) As String

    Select Case i
    Case 1
        TipoCampoVB = "Boolean"
    Case 2
        TipoCampoVB = "Byte"
    Case 3
        TipoCampoVB = "Integer"
    Case 4
        TipoCampoVB = "Long"
    Case 5
        TipoCampoVB = "Currency"
    Case 6
        TipoCampoVB = "Single"
    Case 7
        TipoCampoVB = "Double"
    Case 8
        TipoCampoVB = "Date"
    Case 9
        TipoCampoVB = "Variant"
    Case 10
        TipoCampoVB = "String"
    Case 11
        TipoCampoVB = "Variant"
    Case 12
        TipoCampoVB = "String"
    Case 15
        TipoCampoVB = "Variant"
    Case 16
        TipoCampoVB = "Variant"
    Case 17
        TipoCampoVB = "Variant"
    Case 18
        TipoCampoVB = "Variant"
    Case 19
        TipoCampoVB = "Variant"
    Case 20
        TipoCampoVB = "Variant"
    Case 21
        TipoCampoVB = "Variant"
    Case 22
        TipoCampoVB = "Date"
    Case Else
        TipoCampoVB = "Invalid"
    End Select

End Function

Public Function VarDB(v As Variant) As String

    Select Case VarType(v)
    Case vbDate
        VarDB = FechaDB(CDate(v))
    Case vbString
        VarDB = StringDB(CStr(v))
    Case vbBoolean
        If v Then
            VarDB = "Yes"
        Else
            VarDB = "No"
        End If
    Case vbInteger, _
         vbLong, _
         vbSingle, _
         vbDouble, _
         vbCurrency, _
         vbDecimal, _
         vbByte
            VarDB = Trim(Str(v))
    Case Else
        VarDB = CStr(v)
    End Select

End Function

Public Function FechaDB(Fecha As Date) As String
    
    FechaDB = Format(Fecha, "\#yyyy-mm-dd\#")

End Function

Public Function TimeDateDB(Fecha As Date) As String
  TimeDateDB = Format(Fecha, "\#yyyy-mm-dd hh:mm\#")
End Function

Public Function TimeDB(Fecha As Date) As String
  TimeDB = Format(Fecha, "\#hh:mm\#")
End Function

Public Function StringDB(starg As String) As String
Dim cDelimiter As String, i As Integer, l As Integer
Dim sRetVal As String

    sRetVal = Replace(starg, "'", "''")
    cDelimiter = "'"
    StringDB = cDelimiter & sRetVal & cDelimiter
    
End Function

Public Function BooleanDB(bArg As Boolean) As String

    BooleanDB = IIf(bArg, "True", "False")

End Function


Public Function NumeroDB(ByVal dblArg As Double) As String

    NumeroDB = Trim(Str(dblArg))
    
End Function

Public Function StartTransaction() As Boolean
    
'    If Not SetGlobalLock("StartTransaction") Then
'      StartTransaction = False
'      Exit Function
'    End If
    On Error GoTo ErrHandler
    Workspaces(0).BeginTrans
    StartTransaction = True
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmdbHandle.StartTransaction"
    Err.Clear
    StartTransaction = False
End Function

Public Function CommitTransaction() As Boolean
    
'    FreeGlobalLock
    On Error GoTo ErrHandler
    Workspaces(0).CommitTrans dbForceOSFlush
    CommitTransaction = True
    Exit Function

ErrHandler:
'    ReportarError False, Err.Number, Err.Description, "lmdbHandle.CommitTransaction"
    Err.Clear
    CommitTransaction = False

End Function

Public Function AbortTransaction() As Boolean
    
'    FreeGlobalLock
    On Error GoTo ErrHandler
    Workspaces(0).Rollback
    AbortTransaction = True
    Exit Function

ErrHandler:
'    ReportarError False, Err.Number, Err.Description, "lmdbHandle.CommitTransaction"
    Err.Clear
    AbortTransaction = False

End Function

