Attribute VB_Name = "lmType2String"
Option Explicit

'vbVarType2String
'VarTypes
Public Function vbType2String(ByVal iTypeID As VBA.VbVarType) As String
Dim sRetVal As String

    Select Case iTypeID
    Case vbBoolean
        sRetVal = "Boolean"
    Case vbByte
        sRetVal = "Byte"
    Case vbCurrency
        sRetVal = "Currency"
    Case vbDate
        sRetVal = "Date"
    Case vbDouble
        sRetVal = "Double"
    Case vbInteger
        sRetVal = "Integer"
    Case vbLong
        sRetVal = "Long"
    Case vbObject
        sRetVal = "Object"
    Case vbSingle
        sRetVal = "Single"
    Case vbString
        sRetVal = "String"
    Case vbVariant
        sRetVal = "Variant"
    Case Else
        sRetVal = "Otros"
    End Select

    vbType2String = sRetVal

End Function

Public Function varPreffix(iTypeID As VBA.VbVarType) As String
Dim sRetVal As String

    Select Case iTypeID
    Case vbBoolean
        sRetVal = "b"
    Case vbByte
        sRetVal = "by"
    Case vbCurrency
        sRetVal = "vm"
    Case vbDate
        sRetVal = "dt"
    Case vbDouble
        sRetVal = "dbl"
    Case vbInteger
        sRetVal = "n"
    Case vbLong
        sRetVal = "l"
    Case vbObject
        sRetVal = "p"
    Case vbSingle
        sRetVal = "sng"
    Case vbString
        sRetVal = "str"
    Case vbVariant
        sRetVal = "var"
    Case Else
        sRetVal = "x"
    End Select

    varPreffix = sRetVal

End Function

Public Function stdVarName(istrVarName, ixTypeID As VBA.VbVarType) As String
Dim sRetVal As String

    sRetVal = varPreffix(ixTypeID) & istrVarName
    
    stdVarName = sRetVal

End Function

Public Function Convert2Type(ivarInVal As Variant, ivarType As VBA.VbVarType) As Variant
Dim varRetVal As Variant

    On Error GoTo ErrHandler

    Select Case ivarType
    Case vbBoolean
        varRetVal = CBool(ivarInVal)
    Case vbByte
        If VarType(ivarInVal) = vbString Then
            varRetVal = Val(ivarInVal)
        Else
            varRetVal = CByte(ivarInVal)
        End If
    Case vbCurrency
        If VarType(ivarInVal) = vbString Then
            varRetVal = Val(ivarInVal)
        Else
            varRetVal = CCur(ivarInVal)
        End If
    Case vbDate
        varRetVal = CDate(ivarInVal)
    Case vbDouble
        If VarType(ivarInVal) = vbString Then
            varRetVal = Val(ivarInVal)
        Else
            varRetVal = CDbl(ivarInVal)
        End If
    Case vbInteger
        If VarType(ivarInVal) = vbString Then
            varRetVal = Val(ivarInVal)
        Else
            varRetVal = CInt(ivarInVal)
        End If
    Case vbLong
        If VarType(ivarInVal) = vbString Then
            varRetVal = Val(ivarInVal)
        Else
            varRetVal = CLng(ivarInVal)
        End If
    Case vbObject
        Set varRetVal = ivarInVal
    Case vbSingle
        If VarType(ivarInVal) = vbString Then
            varRetVal = Val(ivarInVal)
        Else
            varRetVal = CSng(ivarInVal)
        End If
    Case vbString
        varRetVal = CStr(ivarInVal)
    Case Else
        varRetVal = ivarInVal
    End Select

ResumePoint:
    Convert2Type = varRetVal

    Exit Function

ErrHandler:

    Select Case ivarType
    Case vbBoolean
        varRetVal = False
    Case vbByte
        varRetVal = 0
    Case vbCurrency
        varRetVal = 0
    Case vbDate
        varRetVal = CDate(0)
    Case vbDouble
        varRetVal = 0
    Case vbInteger
        varRetVal = 0
    Case vbLong
        varRetVal = 0
    Case vbObject
        Set varRetVal = Nothing
    Case vbSingle
        varRetVal = 0
    Case vbString
        varRetVal = ""
    Case Else
        varRetVal = ivarInVal
    End Select

    Resume ResumePoint

End Function
