Attribute VB_Name = "lmTextMetrics"
Option Explicit

Public Function HScaleUnitToInches(ScaleMode As Integer) As Double
Dim RetVal As Double
    Select Case ScaleMode
    Case vbTwips: RetVal = 1# / 1440#
    Case vbPoints: RetVal = 1# / 1440#
    Case vbCharacters: RetVal = 120# / 1440#
    Case vbInches: RetVal = 1
    Case vbCentimeters: RetVal = 1# / 2.54
    Case vbMillimeters: RetVal = 1# / 25.4
    End Select
    HScaleUnitToInches = RetVal
End Function

Public Function VScaleUnitToInches(ScaleMode As Integer) As Double
Dim RetVal As Double
    Select Case ScaleMode
    Case vbTwips: RetVal = 1# / 1440#
    Case vbPoints: RetVal = 1# / 1440#
    Case vbCharacters: RetVal = 240# / 1440#
    Case vbInches: RetVal = 1
    Case vbCentimeters: RetVal = 1# / 2.54
    Case vbMillimeters: RetVal = 1# / 25.4
    End Select
    VScaleUnitToInches = RetVal
End Function

Public Function stScaleMode(ScaleMode As Integer) As String
Dim stRetVal As String
    Select Case ScaleMode
    Case vbTwips: stRetVal = "vbTwips"
    Case vbPoints: stRetVal = "vbPoints"
    Case vbCharacters: stRetVal = "vbCharacters"
    Case vbInches: stRetVal = "vbInches"
    Case vbCentimeters: stRetVal = "vbCentimeters"
    Case vbMillimeters: stRetVal = "vbMillimeters"
    End Select
    stScaleMode = stRetVal
End Function

Public Function RequiredWidth(LineWidth As Integer) As Double
Dim strTester As String, _
    nStringLength As Double, _
    nDeviceScale As Integer, _
    nDeviceFactor As Double, _
    dResult As Double

    strTester = String(LineWidth, "n")
    nStringLength = Printer.TextWidth(strTester)
    nDeviceScale = Printer.ScaleMode
    nDeviceFactor = HScaleUnitToInches(nDeviceScale)
    dResult = nStringLength * nDeviceFactor
    RequiredWidth = dResult
End Function

Public Function RightAlign(sText As String, nWidth As Long, printObj As Object) As String
Dim nSpaceW As Long, nStringLen As Long, sRetVal As String

    sRetVal = Trim(sText)
    nStringLen = printObj.TextWidth(sRetVal)
    
    Do While nStringLen > nWidth
        sRetVal = Right(sRetVal, Len(sRetVal) - 1)
        nStringLen = printObj.TextWidth(sRetVal)
    Loop

    nSpaceW = printObj.TextWidth(" ")
    
    RightAlign = String((nWidth - nStringLen) / nSpaceW, " ") & sRetVal

End Function

Public Function MidAlign(sText As String, nWidth As Long, printObj As Object) As String
Dim nSpaceW As Long, nStringLen As Long, sRetVal As String

    sRetVal = sText
    nStringLen = printObj.TextWidth(sRetVal)
    
    Do While nStringLen > nWidth
        sRetVal = Left(sRetVal, Len(sRetVal) - 1)
        nStringLen = printObj.TextWidth(sRetVal)
    Loop
    
    nSpaceW = printObj.TextWidth(" ")
    MidAlign = String((nWidth - nStringLen) / (nSpaceW * 2), " ") & sRetVal

End Function

Public Function LeftAlign(sText As String, nWidth As Long, printObj As Object) As String
Dim nSpaceW As Long, nStringLen As Long, sRetVal As String

    sRetVal = sText
    nStringLen = printObj.TextWidth(sRetVal)
    
    Do While nStringLen > nWidth
        sRetVal = Left(sRetVal, Len(sRetVal) - 1)
        nStringLen = printObj.TextWidth(sRetVal)
    Loop
    
    LeftAlign = sRetVal

End Function

Public Sub PrintXY(nX As Long, nY As Long, sText As String)

    Printer.CurrentX = nX
    Printer.CurrentY = nY
    Printer.Print sText

End Sub
