Attribute VB_Name = "lmTables"
' DDL: Funciones para el mantenimiento, reestructuracion, etc.
' de las Bases de Datos

Public Function ExisteTabla(DB As Database, ByVal TableName As String) As Boolean
Dim tblDef As TableDef
    
    On Error GoTo NoSuchTable
    Set tblDef = DB.TableDefs(TableName)
    Set tblDef = Nothing
    ExisteTabla = True
    Exit Function
NoSuchTable:
    ExisteTabla = False
    Err.Clear
End Function

Public Function CopyTable(DB As Database, ByVal TableName As String, ByVal SourceTable As String) As Boolean
Dim tdf As DAO.TableDef, tdm As DAO.TableDef, ndxs As DAO.Index, ndxf As DAO.Index
Dim fld As DAO.Field, ofld As DAO.Field

    If Not ExisteTabla(DB, SourceTable) Then
        CopyTable = False
        Exit Function
    End If

    If ExisteTabla(DB, TableName) Then DB.TableDefs.Delete TableName
    
    Set tdf = DB.CreateTableDef(TableName)
    Set tdm = DB.TableDefs(SourceTable)
    
    For Each fld In tdm.Fields  ' Copiar definicion de los campos
        Set ofld = tdf.CreateField(fld.Name, fld.Type, fld.Size)
        If ofld.Type = dbText Then ofld.AllowZeroLength = fld.AllowZeroLength
        ofld.Attributes = fld.Attributes
        ofld.Required = fld.Required
        tdf.Fields.Append ofld
    Next fld
    
    For Each ndxs In tdm.Indexes
        Set ndxf = tdf.CreateIndex(ndxs.Name)
        For Each fld In ndxs.Fields
            ndxf.Fields.Append ndxf.CreateField(fld.Name)
        Next
        ndxf.Clustered = ndxs.Clustered
        ndxf.IgnoreNulls = ndxs.IgnoreNulls
        ndxf.Primary = ndxs.Primary
        ndxf.Required = ndxs.Required
        ndxf.Unique = ndxs.Unique
        tdf.Indexes.Append ndxf
    Next
    
    DB.TableDefs.Append tdf
    CopyTable = True
End Function

Public Function DeleteTable(DB As Database, stTableName As String) As Boolean
    If Not ExisteTabla(DB, stTableName) Then
        Delete = False
        Exit Function
    End If
    DB.TableDefs.Delete stTableName
End Function
