Attribute VB_Name = "lmStringLib"
' StringLib: Modulo de funciones generales para el
' manejo de Strings

Public Function stGetStringFromVariant(arg As Variant) As String
' Los campos provenientes de las BD, pueden contener Null.
' Esta funcin detecta Null y lo convierte en "" (Empty)
' para evitar el error de RunTime que se produce al tratar
' de asignar Null a un string
Dim RetVal As String
    If VarType(arg) = vbNull Then
        RetVal = ""
    Else
        RetVal = arg
    End If
    stGetStringFromVariant = RetVal
End Function

Public Function sExtractRightCode(starg As String) As String
' Dado un string de la forma <s1>(<c2>), extrae el compo-
' nente <c2>, por ejmplo:
' si stArg = "Prima de laud, de tripa de gato (CPL001)"
' sExtractRightCode devolver "CPL001".
' En las operaciones de seleccin, se usa la descripcion,
' seguida del cdigo entre parntesis. Se tom en cuenta
' la posibilidad de tener parntesis anidados. Falla si se
' incluye un slo parntesis en {c2}
' Parsea desde la derecha, en consecuencia ignora los pa-
' rntesis en {c1}
Dim i As Integer, l As Integer
Dim sWork As String
    
    sWork = starg
    l = Len(sWork) - 1
    i = 1
    While (i <> 0 And l > 1)
        If Mid(sWork, l, 1) = "(" Then i = i - 1
        If Mid(sWork, l, 1) = ")" Then i = i + 1
        If (i > 0) Then l = l - 1
    Wend
    If (l <= 1) Then
        sExtractRightCode = ""
        Exit Function
    End If
    
    sWork = Mid(sWork, l + 1, Len(sWork) - l - 1)
    sExtractRightCode = sWork
End Function

Function stFullLength(ByVal starg As String, l As Long) As String
    If (Len(starg) > l) Then
        starg = Left(starg, l)
    Else
        starg = starg + String(l - Len(starg), " ")
    End If
    
    stFullLength = starg
End Function

Function stRightAlign(ByVal starg As String, ByVal l As Long) As String
    If (Len(starg) > l) Then
        starg = Right(starg, l)
    Else
        starg = String(l - Len(starg), " ") & starg
    End If
    stRightAlign = starg
End Function

Function stMidAlign(ByVal starg As String, ByVal l As Long) As String
Dim sRetVal As String, missing As Integer
    missing = l - Len(starg)
    If (missing <= 0) Then
        stMidAlign = stFullLength(starg, l)
        Exit Function
    End If
    missing = missing / 2
    sRetVal = String(missing, " ") & starg
    stMidAlign = sRetVal
End Function

Public Function GetCh(s As String, i As Integer) As String
    If (i > Len(s)) Then
        GetCh = ""
    Else
        GetCh = Mid(s, i, 1)
    End If
End Function

