Attribute VB_Name = "lmStr2Lines"
Option Explicit

Public Function Convert2Lines(sTexto As String, nMaxWidth As Integer) As Variant
Dim nextLine As String, sCopia As String, posSep As Long, cSep As String
Dim RetBuffer() As String, isBreak As Boolean
Dim n As Integer

    If nMaxWidth <= 0 Then
        Err.Raise 5
    End If
    ReDim RetBuffer(0)
    sCopia = sTexto: n = 0
    Do While sCopia <> ""
        nextLine = Left(sCopia, nMaxWidth)
        posSep = InStr(1, nextLine, Chr$(13))
        If posSep Then  ' Corte "natural" de lnea
            nextLine = Left(nextLine, posSep - 1)
            Do
                cSep = Mid(nextLine, posSep, 1)
                If cSep <= Chr$(32) Then
                    posSep = posSep + 1
                End If
            Loop While posSep <= Len(nextLine) And cSep <= Chr$(32)
            sCopia = Right(sCopia, Len(sCopia) - posSep)
        Else
            posSep = Len(nextLine)
            If posSep > 0 Then
                If posSep >= nMaxWidth Then
                    Do
                        cSep = Mid(nextLine, posSep, 1)
                        isBreak = InStr(1, ",.:;?! ", cSep)
                        If Not isBreak Then
                            posSep = posSep - 1
                        End If
                    Loop While Not isBreak And posSep > 0
                Else
                    isBreak = False
                End If

                If isBreak Then
                    Select Case cSep
                    Case " "
                        nextLine = Left(nextLine, posSep - 1)
                    Case ",", ".", ":", ";", "?", "!"
                        nextLine = Left(nextLine, posSep)
                    Case "", ""
                        nextLine = Left(nextLine, posSep - 1)
                        posSep = posSep - 1
                    End Select
                Else
                    posSep = Len(nextLine)
                End If
            End If
            sCopia = Right(sCopia, Len(sCopia) - posSep)
        End If

        n = n + 1
        ReDim Preserve RetBuffer(0 To n)
        RetBuffer(n) = Trim(nextLine)
    Loop
    
    Convert2Lines = RetBuffer

End Function
