Attribute VB_Name = "lmSelectFolder"
Option Explicit

Private Type BrowseInfo
    hWndOwner As Long
    pIDLRoot As Long
    pszDisplayName As Long
    lpszTitle As Long
    ulFlags As Long
    lpfnCallback As Long
    lParam As Long
    iImage As Long
End Type
Const BIF_RETURNONLYFSDIRS = 1
Const MAX_PATH = 260
Private Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal hMem As Long)
Private Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long
Private Declare Function SHBrowseForFolder Lib "shell32" (lpbi As BrowseInfo) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long


Public Function SelectFolder(istrTituloForma As String, hWnd As Long, Optional istrStar As String = "") As String
'KPD-Team 1998
'URL: http://www.allapi.net/
'KPDTeam@Allapi.net
Dim iNull As Integer, lpIDList As Long, lResult As Long
Dim sPath As String, udtBI As BrowseInfo

'    sPath = GetSetting("ClearLight", "General", "DataDir", "")
'    If (sPath <> "") Then
'        If Right(sPath, 1) = "\" Then sPath = Left(sPath, Len(sPath) - 1)
'        iNull = Len(sPath)
'        Do While (iNull > 1) And Mid(sPath, iNull, 1) <> "\"
'            iNull = iNull - 1
'        Loop
'        If (iNull) = 1 Then
'            sPath = ""
'        Else
'            sPath = Left(sPath, iNull)
'        End If
'    End If
    
    With udtBI
        'Set the owner window
        .hWndOwner = hWnd
        'lstrcat appends the two strings and returns the memory address
        .lpszTitle = lstrcat(istrTituloForma, "")
        'Return only if the user selected a directory
        .ulFlags = BIF_RETURNONLYFSDIRS
    End With

    'Show the 'Browse for folder' dialog
    lpIDList = SHBrowseForFolder(udtBI)
    If lpIDList Then
        sPath = String$(MAX_PATH, 0)
        'Get the path from the IDList
        SHGetPathFromIDList lpIDList, sPath
        'free the block of memory
        CoTaskMemFree lpIDList
        iNull = InStr(sPath, vbNullChar)
        If iNull Then
            sPath = Left$(sPath, iNull - 1)
        End If
    End If

    SelectFolder = sPath

End Function
