Attribute VB_Name = "lmPing"
Option Explicit

Private Const PING_TIMEOUT = 1000
Private Const MIN_SOCKETS_REQD = 1
Private Const WS_VERSION_REQD = &H101
Private Const MAX_WSADescription = 256
Private Const MAX_WSASYSStatus = 128
Private Const WS_VERSION_MAJOR = WS_VERSION_REQD \ &H100 And &HFF&
Private Const WS_VERSION_MINOR = WS_VERSION_REQD And &HFF&
Private Type HOSTENT
    hName As Long
    hAliases As Long
    hAddrType As Integer
    hLength As Integer
    hAddrList As Long
End Type
Private Type WSADATA
    wVersion As Integer
    wHighVersion As Integer
    szDescription(0 To MAX_WSADescription) As Byte
    szSystemStatus(0 To MAX_WSASYSStatus) As Byte
    wMaxSockets As Integer
    wMaxUDPDG As Integer
    dwVendorInfo As Long
End Type
Private Type ICMP_OPTIONS
    Ttl             As Byte
    Tos             As Byte
    Flags           As Byte
    OptionsSize     As Byte
    OptionsData     As Long
End Type
Private Type ICMP_ECHO_REPLY
    Address         As Long
    status          As Long
    RoundTripTime   As Long
    DataSize        As Integer
    Reserved        As Integer
    DataPointer     As Long
    Options         As ICMP_OPTIONS
    Data            As String * 250
End Type
Private Declare Function IcmpSendEcho _
    Lib "icmp.dll" ( _
    ByVal IcmpHandle As Long, _
    ByVal DestinationAddress As Long, _
    ByVal RequestData As String, _
    ByVal RequestSize As Integer, _
    ByVal RequestOptions As Long, _
    ReplyBuffer As ICMP_ECHO_REPLY, _
    ByVal ReplySize As Long, _
    ByVal TimeOut As Long) _
    As Long
Private Declare Function IcmpCreateFile _
    Lib "icmp.dll" () _
    As Long
Private Declare Function IcmpCloseHandle _
    Lib "icmp.dll" ( _
    ByVal IcmpHandle As Long) _
    As Long
Private Declare Function WSAStartup _
    Lib "WSOCK32.DLL" ( _
    ByVal wVersionRequired As Long, _
    lpWSADATA As WSADATA) _
    As Long
Private Declare Function WSACleanup _
    Lib "WSOCK32.DLL" () _
    As Long
Private Declare Function gethostbyname _
    Lib "WSOCK32.DLL" ( _
    ByVal HostName$) _
    As Long
Private Declare Sub RtlMoveMemory _
    Lib "KERNEL32" ( _
    hpvDest As Any, _
    ByVal hpvSource&, _
    ByVal cbCopy&)

Public Function Ping(ByVal strIP As String) As Boolean
    On Error GoTo Gestion_Error
    Dim lPort  As Long
    Dim uICMP  As ICMP_ECHO_REPLY
    Dim i      As Integer
    Ping = False
    If IniciarSocket Then
        lPort = IcmpCreateFile()
        If IcmpSendEcho(lPort, _
                        TraducirIP(strIP), _
                        strIP, _
                        Len(strIP), _
                        0, _
                        uICMP, _
                        Len(uICMP), _
                        PING_TIMEOUT) Then
            Ping = True
        End If
        Call IcmpCloseHandle(lPort)
        Call FinalizarSocket
    End If
    Exit Function
Gestion_Error:
    Ping = False
    Exit Function
End Function

Private Function IniciarSocket() As Boolean
    On Error GoTo Gestion_Error
    Dim uWSAD    As WSADATA
    Dim iRes     As Integer
    Dim szLoByte As String
    Dim szHiByte As String
    IniciarSocket = False
    iRes = WSAStartup(WS_VERSION_REQD, uWSAD)
    If iRes = 0 Then
        If Not ( _
           LoByte(uWSAD.wVersion) < WS_VERSION_MAJOR Or _
          (LoByte(uWSAD.wVersion) = WS_VERSION_MAJOR And _
           HiByte(uWSAD.wVersion) < WS_VERSION_MINOR)) Then
            If uWSAD.wMaxSockets >= MIN_SOCKETS_REQD Then
                IniciarSocket = True
            End If
        End If
    End If
    Exit Function
Gestion_Error:
    IniciarSocket = False
    Exit Function
End Function

Private Function TraducirIP(ByVal strIP As String) As Long
    On Error GoTo Gestion_Error
    Dim i           As Integer
    Dim strPartes() As String
    TraducirIP = 0
    strPartes = Split(Trim$(strIP), ".")
    If UBound(strPartes) = 3 Then
        TraducirIP = Val("&H" & _
                         Right("00" & Hex(strPartes(3)), 2) & _
                         Right("00" & Hex(strPartes(2)), 2) & _
                         Right("00" & Hex(strPartes(1)), 2) & _
                         Right("00" & Hex(strPartes(0)), 2))
    End If
    Exit Function
Gestion_Error:
    TraducirIP = 0
    Exit Function
End Function

Private Function FinalizarSocket() As Boolean
    On Error GoTo Gestion_Error
    Dim lRes As Long
    FinalizarSocket = False
    lRes = WSACleanup()
    If lRes = 0 Then
        FinalizarSocket = True
    End If
    Exit Function
Gestion_Error:
    FinalizarSocket = False
    Exit Function
End Function

Private Function LoByte(ByVal wParam As Integer)
    On Error Resume Next
    LoByte = wParam And &HFF&
End Function

Private Function HiByte(ByVal wParam As Integer)
    On Error Resume Next
    HiByte = wParam \ &H100 And &HFF&
End Function

Private Function GetIPList(ByVal strNombre As String, strIPList() As String) As Boolean
    On Error Resume Next
    Dim strHostName      As String * 256
    Dim lHostentAddr     As Long
    Dim uHost            As HOSTENT
    Dim lHostipAddr      As Long
    Dim bTempIpAddress() As Byte
    Dim i                As Integer
    Dim j                As Integer
    GetIPList = False
    Erase strIPList
    strHostName = Trim$(strNombre) & String(256, 0)
    If Trim$(strNombre) <> "" Then
        If IniciarSocket Then
            lHostentAddr = gethostbyname(strHostName)
            If lHostentAddr <> 0 Then
                RtlMoveMemory uHost, lHostentAddr, LenB(uHost)
                RtlMoveMemory lHostipAddr, uHost.hAddrList, 4
                Do
                    ReDim Preserve strIPList(j) As String
                    ReDim bTempIpAddress(1 To uHost.hLength)
                    RtlMoveMemory bTempIpAddress(1), lHostipAddr, uHost.hLength
                    For i = 1 To uHost.hLength
                        strIPList(j) = strIPList(j) & bTempIpAddress(i) & "."
                    Next
                    strIPList(j) = Mid$(strIPList(j), 1, Len(strIPList(j)) - 1)
                    GetIPList = True
                    uHost.hAddrList = uHost.hAddrList + LenB(uHost.hAddrList)
                    RtlMoveMemory lHostipAddr, uHost.hAddrList, 4
                    j = j + 1
                Loop While (lHostipAddr <> 0)
            End If
            Call FinalizarSocket
        End If
    End If
End Function

