Attribute VB_Name = "lmPaperSizes"
Option Explicit
'Constante            Valor  Descripcin
'-----------------------------------------------------------------
'vbPRPSLetter            1   Letter, 8 1/2 x 11 in
'vbPRPSLetterSmall       2   +A611Letter Small, 8 1/2 x 11 in
'vbPRPSTabloid           3   Tabloid, 11 x 17 in
'vbPRPSLedger            4   Ledger, 17 x 11 in
'vbPRPSLegal             5   Legal, 8 1/2 x 14 in
'vbPRPSStatement         6   Statement, 5 1/2 x 8 1/2 in
'vbPRPSExecutive         7   Executive, 7 1/2 x 10 1/2 in
'vbPRPSA3                8   A3, 297 x 420 mm
'vbPRPSA4                9   A4, 210 x 297 mm
'vbPRPSA4Small          10  A4 Small, 210 x 297 mm
'vbPRPSA5               11  A5, 148 x 210 mm
'vbPRPSB4               12  B4, 250 x 354 mm
'vbPRPSB5               13  B5, 182 x 257 mm
'vbPRPSFolio            14  Folio, 8 1/2 x 13 in
'vbPRPSQuarto           15  Quarto, 215 x 275 mm
'vbPRPS1&H14            16  10 x 14 in
'vbPRPS11x17            17  11 x 17 in
'vbPRPSNote             18  Note, 8 1/2 x 11 in
'vbPRPSEnv9             19  Envelope #9, 3 7/8 x 8 7/8 in
'vbPRPSEnv10            20  Envelope #10, 4 1/8 x 9 1/2 in
'vbPRPSEnv11            21  Envelope #11, 4 1/2 x 10 3/8 in
'vbPRPSEnv12            22  Envelope #12, 4 1/2 x 11 in
'vbPRPSEnv14            23  Envelope #14, 5 x 11 1/2 in
'vbPRPSCSheet           24  C size sheet
'vbPRPSDSheet           25  D size sheet
'vbPRPSESheet           26  E size sheet
'vbPRPSEnvDL            27  Envelope DL, 110 x 220 mm
'vbPRPSEnvC3            29  Envelope C3, 324 x 458 mm
'vbPRPSEnvC4            30  Envelope C4, 229 x 324 mm
'vbPRPSEnvC5            28  Envelope C5, 162 x 229 mm
'vbPRPSEnvC6            31  Envelope C6, 114 x 162 mm
'vbPRPSEnvC65           32  Envelope C65, 114 x 229 mm
'vbPRPSEnvB4            33  Envelope B4, 250 x 353 mm
'vbPRPSEnvB5            34  Envelope B5, 176 x 250 mm
'vbPRPSEnvB6            35  Envelope B6, 176 x 125 mm
'vbPRPSEnvItaly         36  Envelope, 110 x 230 mm
'vbPRPSEnvMonarch       37  Envelope Monarch, 3 7/8 x 7 1/2 in
'vbPRPSEnvPersonal      38  Envelope, 3 5/8 x 6 1/2 in
'vbPRPSFanfoldUS        39  U.S. Standard Fanfold, 14 7/8 x 11 in
'vbPRPSFanfoldStdGerman 40  German Standard Fanfold, 8 1/2 x 12 in
'vbPRPSFanfoldLglGerman 41  German Legal Fanfold, 8 1/2 x 13 in
'vbPRPSUser            256 User-defined

Const Min = 1
Const Max = 18
Const Widths = "216,216,279,432,216,140,190,297,210,210,148,250,182,216,215,254,279,216"
Const Heights = "279,279,432,280,356,216,254,420,297,297,210,354,257,330,275,356,431,279"

' Ancho del papel en pulgadas
Function PageWidth(PaperType As Integer) As Double
Dim RetVal As Double
    If (PaperType > Max Or PaperType < Min) Then
        PageWidth = 0
        Exit Function
    End If
    RetVal = Val(Mid(Widths, (PaperType - 1) * 4 + 1, 3))
    RetVal = RetVal / 25.4
    PageWidth = RetVal
End Function

Function PageHeight(PaperType As Integer) As Double
Dim RetVal As Double
    If (PaperType > Max Or PaperType < Min) Then
        PageHeight = 0
        Exit Function
    End If
    RetVal = Val(Mid(Heights, (PaperType - 1) * 4 + 1, 3))
    RetVal = RetVal / 25.4
    PageHeight = RetVal
End Function

