Attribute VB_Name = "lmNumLockControl"
Option Explicit

Private Declare Function GetKeyboardState Lib "user32" (pbKeyState As Byte) As Long
Private Declare Function SetKeyboardState Lib "user32" (lppbKeyState As Byte) As Long
Private Const VK_NUMLOCK = &H90

' additional constant declarations:
'      Private Const VK_SCROLL = &H91
'      Private Const VK_CAPITAL = &H14

Public Sub NumLockControl(State As Boolean) ' 1: on, 0: off
    Dim NumLockState As Boolean
    Dim ScrollLockState As Boolean
    Dim CapsLockState As Boolean
    Dim keys(0 To 255) As Byte
    
    GetKeyboardState keys(0)
    NumLockState = keys(VK_NUMLOCK)

    If NumLockState <> State Then
        keys(VK_NUMLOCK) = IIf(State, 1, 0)
        SetKeyboardState keys(0)
    End If
End Sub

Public Function NumLockStatus() As Boolean
    Dim NumLockState As Boolean
    Dim keys(0 To 255) As Byte

    GetKeyboardState keys(0)
    NumLockState = keys(VK_NUMLOCK)
    NumLockStatus = NumLockState
End Function

