Attribute VB_Name = "lmMisc"
' Rutinas de Utilidad General
' lmMisc.BAS

' Rutina para seleccionar todo el contenido de un control.
' Requiere que el control soporte las propiedades Text, SelStar ySelLength
Sub HighLight(c As Control)
    c.SelStart = 0
    c.SelLength = Len(c.Text)
End Sub

'Devuelve el contenido de la propiedad Text del Control <c>, convertida a mayusculas y "trimeada"
Sub TrimUCase(c As Control)
    c.Text = Trim(Format(c.Text, ">"))
End Sub

Public Function GetDateFromVariant(vArg As Variant) As Date
Dim dRetVal As Date

    If VarType(vArg) <> vbDate Then
        dRetVal = BuildFecha(1, 1, 1800)
    Else
        dRetVal = vArg
    End If

    GetDateFromVariant = dRetVal

End Function

Public Function GetNumeroFromVariant(vArg As Variant) As Double
Dim dblRetVal As Double
    
    On Error GoTo ErrHandler
    If VarType(vArg) = vbNull Then
        dblRetVal = 0
    Else
        dblRetVal = vArg
    End If

    GetNumeroFromVariant = dblRetVal
    Exit Function

ErrHandler:

    Err.Clear
    GetNumeroFromVariant = 0

End Function

Public Function GetBooleanFromVariant(vArg As Variant) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler

    If VarType(vArg) = vbNull Then
        bRetVal = False
    Else
        bRetVal = vArg
    End If
    
    GetBooleanFromVariant = bRetVal
    Exit Function

ErrHandler:
    
    Err.Clear
    GetBooleanFromVariant = False

End Function

Public Sub AddSym(Sym As String, dest As TextBox)
Dim i As Integer

    If Sym = "" Then Exit Sub

    If (InStr(1, dest.Text, Sym, vbTextCompare) <> 0) Then
        mAdvertencia "Entrada Duplicada"
        Exit Sub
    End If
    
    If dest.Text <> "" Then
        If Left(dest.Text, 1) <> "," Then
            dest.Text = dest.Text & ","
        End If
    End If
    
    dest.Text = dest.Text & Sym

End Sub

Public Function RedondearPrecio(ByVal Precio As Currency) As Currency
Dim Factor As Double

    Select Case Int(Precio)
    Case 0 To 20
        Factor = 0.5
    Case 21 To 100
        Factor = 1
    Case 101 To 1000
        Factor = 5
    Case 1001 To 10000
        Factor = 10
    Case 10000 To 50000
        Factor = 50
    Case Else
        Factor = 100
    End Select

    RedondearPrecio = Int(Precio / Factor + 0.9) * Factor

End Function

Public Function isNumeric(t As VbVarType) As Boolean

    If t = vbByte Or t = vbCurrency Or t = vbDecimal _
    Or t = vbDouble Or t = vbInteger Or t = vbLong Or t = vbSingle Then
        isNumeric = True
    Else
        isNumeric = False
    End If

End Function

