Attribute VB_Name = "lmLinePrinter"
Private PrinterHandle As Integer

Public Function isPrinter(sPrinterName As String) As Boolean
Dim i As Integer

    For i = 0 To Printers.Count - 1
    
        If (Printers(i).DeviceName = sPrinterName) Then
            isPrinter = True
            Exit Function
        End If
    
    Next
    
    isPrinter = False

End Function

Public Function SetPrinter(sPrinterName As String) As Boolean
Dim i As Integer

    For i = 0 To Printers.Count - 1
    
        If (Printers(i).DeviceName = sPrinterName) Then
            Set Printer = Printers(i)
            SetPrinter = True
            Exit Function
        End If
    
    Next
    
    SetPrinter = False

End Function

Function OpenLinePrinter() As Boolean
Dim stPrinterPort As String
Dim bRetVal As Boolean
    stPrinterPort = GetSetting("VSL", "CONFIG", "PrinterPort", "LPT1")
    If stPrinterPort = "NIL" Then
        PrinterHandle = -1
        OpenLinePrinter = True
        Exit Function
    End If
    
    PrinterHandle = FreeFile
    bRetVal = True
    On Error GoTo ErrHandler
    Open stPrinterPort For Output As #PrinterHandle
    OpenLinePrinter = bRetVal
    Exit Function
ErrHandler:
    mAdvertencia "ERROR" & Str(Err.Number) & " inicializando impresora."
    bRetVal = False
    On Error GoTo 0
    Resume Next
End Function

Function LPrint(starg As String) As Boolean
Dim bRetVal As Boolean, lWait As Long
Dim i As Integer
    
    If PrinterHandle < 0 Then
        LPrint = True
        Exit Function
    End If

    bRetVal = True
    On Error GoTo ErrHandler
    Print #PrinterHandle, starg
    
'    For i = 1 To Len(stArg)
'        Print #PrinterHandle, Mid(stArg, i, 1);
'        If (bRetVal = False) Then
'            Exit For
'        End If
'        For lWait = 1 To 500: DoEvents: Next
'    Next
'    Print #PrinterHandle, ""
    LPrint = bRetVal
    Exit Function
ErrHandler:
    mAdvertencia "ERROR" & Str(Err.Number) & " imprimiendo."
    bRetVal = False
    On Error GoTo 0
    Resume Next
End Function

Sub CloseLinePrinter()
Dim j As Long
    If PrinterHandle < 0 Then Exit Sub

    For j = 1 To 10000: DoEvents: Next
    On Error GoTo ErrHandler
    Close #PrinterHandle
    PrinterHandle = 0
    Exit Sub
ErrHandler:
    On Error GoTo 0
    Resume Next
End Sub

Sub AbortLinePrinter()

    CloseLinePrinter

End Sub
