Attribute VB_Name = "lmGridColor"
Option Explicit
Private cGrid As MSFlexGrid
Private isInit As Boolean
Private AlternateColor As Long, BackColor As Long
Private AlternateForeColor As Long, ForeColor As Long

Private Sub init()
  If Not isInit Then
    AlternateColor = Val(GetSetting("VSL", "Config", "GEDITFondoAlterno", "0"))
    AlternateForeColor = Val(GetSetting("VSL", "CONFIG", "GEDITTextoAlterno", "-2147483640"))
    BackColor = Val(GetSetting("VSL", "CONFIG", "GEDITFondoNormal", "-2147483643"))
    ForeColor = (GetSetting("VSL", "CONFIG", "GEDITTextoNormal", "-2147483640"))
  End If
  If AlternateColor <> 0 Then
    cGrid.GridLines = flexGridNone
    cGrid.GridLinesFixed = flexGridNone
  End If
End Sub

Private Sub SetBackColor(nRow As Long)
Dim nCol As Long
Dim orgRow As Long, orgCol As Long
Dim nColor As Long, nForeColor As Long

  If AlternateColor = 0 Then Exit Sub
  If ((nRow - cGrid.FixedCols) And 1) Then
    nColor = BackColor
    nForeColor = ForeColor
  Else
    nColor = AlternateColor
    nForeColor = AlternateForeColor
  End If
  orgRow = cGrid.Row: orgCol = cGrid.col
  cGrid.Row = nRow
  For nCol = cGrid.FixedCols To cGrid.Cols - 1
    cGrid.col = nCol
    cGrid.CellBackColor = nColor
    cGrid.CellForeColor = nForeColor
  Next
  cGrid.Row = orgRow: cGrid.col = orgCol

End Sub

Public Sub SetGridColors(pGrid As MSFlexGrid)
Dim i As Long
  Set cGrid = pGrid
  init
  For i = pGrid.FixedRows To pGrid.Rows - 1
    SetBackColor i
  Next
End Sub
