Attribute VB_Name = "lmFIEUsers"
Option Explicit

Public Sub OpenFIEUsuarios(Optional Codigo As String)
Dim InCodigo As String
Dim VarFIE As New LFIEUsers
    If Codigo = "" Then
        VarFIE.SetContexto 0
        VarFIE.Show 0
        While VarFIE.Visible: DoEvents: Wend
    Else
        VarFIE.Visible = False
        VarFIE.SetCodigo Codigo
        VarFIE.SetContexto 3
        While VarFIE.Visible: DoEvents: Wend
    End If
    Unload VarFIE
    Set VarFIE = Nothing
End Sub

Public Function FillFIEUsuarios(ByRef destino As LFIEUsers) As Boolean
   
    If Not lmUsuarios.LeerUsuario(destino.txCodigo.Text) Then
        FillFIEUsuarios = False
        Exit Function
    End If
    
    With destino
        .txCodigo.Text = cUsuario.Codigo
        .txNombre = cUsuario.Nombre
        .cbxPerfil.Text = cUsuario.Perfil
        .txNivel.Value = cUsuario.Nivel
    End With
    FillFIEUsuarios = True
End Function

Public Function FIEUsuariosAnterior(arg As LFIEUsers) As Boolean
Dim RetVal As Boolean

    AbrirUsuarios
    lmUsuarios.rsHandle.Seek "<", arg.txCodigo.Text
    If Not lmUsuarios.rsHandle.NoMatch Then
        arg.txCodigo.Text = stGetStringFromVariant(lmUsuarios.rsHandle.Fields("Codigo").Value)
        RetVal = FillFIEUsuarios(arg)
    Else
        RetVal = False
    End If
    FIEUsuariosAnterior = RetVal
    CerrarUsuarios
  
End Function

Public Function FIEUsuariosSiguiente(arg As LFIEUsers) As Boolean
Dim RetVal As Boolean
    
    AbrirUsuarios
    lmUsuarios.rsHandle.Seek ">", arg.txCodigo.Text
    If Not lmUsuarios.rsHandle.NoMatch Then
        arg.txCodigo.Text = stGetStringFromVariant(lmUsuarios.rsHandle.Fields("Codigo").Value)
        RetVal = FillFIEUsuarios(arg)
    Else
        RetVal = False
    End If
    CerrarUsuarios
    FIEUsuariosSiguiente = RetVal
End Function

Public Function CrearUsuario(Clave As String) As Boolean
Dim FCreacion As New LFIEUsers

    If Not Confirmar("Crear usuario " & Clave) Then
        CrearUsuario = False
        Exit Function
    End If
    
    OpenFIEUsuarios Clave
    CrearUsuario = ExisteUsuario(Clave)
End Function

Public Function ValidarUsuario(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String

    stTemp = Trim(Format(Codigo, ">"))
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo de usuario"
        bRetVal = False
    Else
        If Len(stTemp) > 8 Then
            mAdvertencia "La maxima longitud del cdigo son 8 caracteres"
            bRetVal = False
        Else
            If ExisteUsuario(stTemp) Then
                bRetVal = True
            Else
                bRetVal = CrearUsuario(stTemp)
            End If
        End If
    End If
    ValidarUsuario = bRetVal
End Function
