Attribute VB_Name = "lmDiskInfo"
Option Explicit

Private Declare Function GetVolumeInformation Lib "Kernel32" Alias "GetVolumeInformationA" (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, ByVal nVolumeNameSize As Long, lpVolumeSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long) As Long

Private Sub ExtractAll(strPathID As String, ostrVolName As String, olngSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ostrFileSystemNameBuffer As String)
'Credits to
'KPD-Team 1998 (All API Guide)
    
    ostrVolName = String$(255, Chr$(0))
    ostrFileSystemNameBuffer = String$(255, Chr$(0))
    
    GetVolumeInformation strPathID, ostrVolName, 255, olngSerialNumber, lpMaximumComponentLength, lpFileSystemFlags, ostrFileSystemNameBuffer, 255
    
    ostrVolName = Left$(ostrVolName, InStr(1, ostrVolName, Chr$(0)) - 1)
    ostrFileSystemNameBuffer = Left$(ostrFileSystemNameBuffer, InStr(1, ostrFileSystemNameBuffer, Chr$(0)) - 1)

End Sub

Public Function DiskSerial(istrPathID As String) As Long
Dim lRetVal As Long

    ExtractAll istrPathID, "", lRetVal, 0, 0, ""
    DiskSerial = lRetVal

End Function

Public Function DiskName(istrPathID As String) As String
Dim sRetVal As String

    ExtractAll istrPathID, sRetVal, 0, 0, 0, ""
    DiskName = sRetVal

End Function

Public Function DiskMaxComponentLength(istrPathID As String) As Long
Dim lRetVal As Long

    ExtractAll istrPathID, "", 0, lRetVal, 0, ""
    DiskMaxComponentLength = lRetVal

End Function

Public Function DiskFileSystemFlags(istrPathID As String) As Long
Dim lRetVal As Long

    ExtractAll istrPathID, "", 0, 0, lRetVal, ""
    DiskFileSystemFlags = lRetVal

End Function

Public Function DiskFileSystemID(istrPathID As String) As String
Dim sRetVal As String

    ExtractAll istrPathID, "", 0, 0, 0, sRetVal
    DiskFileSystemID = sRetVal

End Function
