Attribute VB_Name = "lmDAOFields"
Option Explicit

' Las funciones siguientes tienen que ver con el "acceso funcional a la base de datos"

Public Function fldType(istrFldName As String, istrTableName As String) As DAO.DataTypeEnum
Dim pQDef As QueryDef, fld As Field, retVal As DataTypeEnum

    On Error GoTo ErrHandler
    Set pQDef = dbHandle.TableDefs(istrTableName)
    Set fld = pQDef.Fields(istrFldName)
    
    retVal = fld.Type

ResumePoint:
    Set fld = Nothing
    Set pQDef = Nothing

    fldType = retVal
    Exit Function

ErrHandler:

    retVal = 0
    Resume ResumePoint

End Function

Public Function isField(istrCandidato As String, istrTableName As String) As Boolean
Dim pFld As Field, tDef As TableDef, bRetVal As Boolean

    Set tDef = dbHandle.TableDefs(istrTableName)
    On Error GoTo NoField
    bRetVal = True
    Set pFld = tDef.Fields(istrCandidato)

ResumePoint:
    Set pFld = Nothing
    Set tDef = Nothing
    isField = bRetVal
    Exit Function

NoField:
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function DAOType2VBType(i As DAO.DataTypeEnum) As VbVarType

    Select Case i
    Case dbBoolean
        DAOType2VBType = vbBoolean
    Case dbByte
        DAOType2VBType = vbByte
    Case dbInteger
        DAOType2VBType = vbInteger
    Case dbLong
        DAOType2VBType = vbLong
    Case dbCurrency
        DAOType2VBType = vbCurrency
    Case dbSingle
        DAOType2VBType = vbSingle
    Case dbDouble
        DAOType2VBType = vbDouble
    Case dbDate, dbTime
        DAOType2VBType = vbDate
    Case dbBinary
        DAOType2VBType = vbVariant
    Case dbText
        DAOType2VBType = vbString
    Case dbLongBinary
        DAOType2VBType = vbVariant
    Case dbMemo
        DAOType2VBType = vbString
    Case dbGUID
        DAOType2VBType = vbVariant
    Case dbBigInt
        DAOType2VBType = vbVariant
    Case dbVarBinary
        DAOType2VBType = vbVariant
    Case dbChar
        DAOType2VBType = vbString
    Case dbNumeric
        DAOType2VBType = vbDouble
    Case dbDecimal
        DAOType2VBType = vbDouble
    Case dbFloat
        DAOType2VBType = vbDouble
    Case Else
        DAOType2VBType = vbVariant
    End Select

End Function

Public Function FieldNullValue(istrFieldName As String, istrTableName As String) As Variant
Dim varRetVal As Variant, dbtFldType As DAO.DataTypeEnum

    dbtFldType = fldType(istrFieldName, istrTableName)

    Select Case dbtFldType
    Case dbBoolean
        varRetVal = False
    Case dbByte, _
        dbInteger, _
        dbLong, _
        dbCurrency, _
        dbSingle, _
        dbDouble, _
        dbNumeric, _
        dbDecimal, _
        dbFloat
            varRetVal = 0
    Case dbDate, dbTime
        varRetVal = CDate(0)
    Case dbText, dbChar
        varRetVal = ""
    Case Else
        varRetVal = 0
    End Select

    FieldNullValue = varRetVal

End Function

