VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form lfQuickView 
   Caption         =   "Documento: Vista Rpida"
   ClientHeight    =   7350
   ClientLeft      =   1260
   ClientTop       =   2535
   ClientWidth     =   11775
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   7350
   ScaleWidth      =   11775
   Visible         =   0   'False
   Begin VB.CommandButton cbGuardar 
      Caption         =   "Guardar como"
      Height          =   525
      Left            =   4950
      TabIndex        =   2
      Top             =   6780
      Width           =   1635
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Buscar Texto"
      Height          =   525
      Left            =   6660
      TabIndex        =   3
      Top             =   6780
      Width           =   1635
   End
   Begin VB.CommandButton cbPrinterFonts 
      Caption         =   "Fuente Impresora"
      Height          =   525
      Left            =   180
      TabIndex        =   1
      Top             =   6780
      Width           =   1635
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   120
      Top             =   6690
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin RichTextLib.RichTextBox Text1 
      Height          =   6555
      Left            =   180
      TabIndex        =   0
      Top             =   150
      Width           =   11535
      _ExtentX        =   20346
      _ExtentY        =   11562
      _Version        =   393217
      HideSelection   =   0   'False
      ScrollBars      =   3
      TextRTF         =   $"lfQuickViewSDI.frx":0000
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.CommandButton cbCerrar 
      Cancel          =   -1  'True
      Caption         =   "Cerrar"
      Height          =   525
      Left            =   10080
      TabIndex        =   5
      Top             =   6780
      Width           =   1635
   End
   Begin VB.CommandButton cbImprimir 
      Caption         =   "Imprimir"
      Height          =   525
      Left            =   8370
      TabIndex        =   4
      Top             =   6780
      Width           =   1635
   End
   Begin VB.Image imgFontShrink 
      Height          =   510
      Left            =   2400
      Picture         =   "lfQuickViewSDI.frx":0080
      Stretch         =   -1  'True
      ToolTipText     =   "Reducir Fuente de Pantalla"
      Top             =   6780
      Width           =   510
   End
   Begin VB.Image imgFontGrow 
      Height          =   510
      Left            =   1890
      Picture         =   "lfQuickViewSDI.frx":038A
      Stretch         =   -1  'True
      ToolTipText     =   "Ampliar Fuente de Pantalla"
      Top             =   6780
      Width           =   510
   End
End
Attribute VB_Name = "lfQuickView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumLinea As Integer, NumPagina As Integer
Private isDirty As Boolean
Public ReportWidth As Integer
Private LinesPerPage As Integer
Private sFontName As String, sFontSize As Integer
Private Printing As Boolean, FontOverriden As Boolean
Private NotifyClickTo As Object
Private nLeftMargin As Integer
Private nMaxFont As Double
Private nFontOffset As Integer
Private dfsFactor As Single

Public Event ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)

Public Property Let LeftMargin(nNewMargin As Integer)

    If nNewMargin < 0 Then
        Err.Raise vbObjectError + 5, "Argumento invlido", "lfQuickView::SetLeftMargin"
    Else
        nLeftMargin = nNewMargin
    End If

End Property

Public Property Get LeftMargin() As Integer

    LeftMargin = nLeftMargin

End Property

Public Sub SetNotify(pObject As Object)
    
    Set NotifyClickTo = pObject

End Sub

Private Sub cbCerrar_Click()
  If Printing Then
    If Not Confirmar("Detener la impresin en progreso") Then
      Exit Sub
    End If
    Printing = False
  End If
  Me.Hide
  Unload Me
End Sub

Private Sub cbImprimir_Click()
  PrintListBox
End Sub

Public Sub SetNumeroPagina(newPagina As Integer)
  NumPagina = newPagina
End Sub

Public Sub SetLinesPerPage(newLPP As Integer)
  LinesPerPage = newLPP
End Sub

Public Sub SetPrintFontSize(newFontSize As Integer)
  FontOverriden = True
  Printer.Font.Size = newFontSize
End Sub

Public Function SetReportWidth(ByVal nRepWidth As Integer) As Boolean
Dim PageWidth As Double, orgFontSize As Double

  ReportWidth = nRepWidth
  If FontOverriden Then Exit Function
  
  On Error GoTo SkipPConfig
  
  PageWidth = Printer.ScaleWidth * lmTextMetrics.HScaleUnitToInches(Printer.ScaleMode)
' Determinar la "Fuente" de la impresora.
  Printer.Font.Name = sFontName
  Printer.Font.Size = nMaxFont
  Printer.Font.Bold = False
  
  Do While (lmTextMetrics.RequiredWidth(nRepWidth + 6) > (PageWidth * 0.98)) And (Printer.Font.Size > 4)    ' La metrica de la impresora en VB 5 es bastante deficiente.
    orgFontSize = Printer.Font.Size
    Printer.Font.Size = Printer.Font.Size - 0.5
    If orgFontSize = Printer.Font.Size Then Exit Do
  Loop
  
  If nFontOffset <> 0 Then
  Printer.FontSize = Printer.Font.Size + nFontOffset
  End If
  
  If dfsFactor <> 1 Then
  Printer.Font.Size = Printer.Font.Size * dfsFactor
  End If
  
  If (Printer.Font.Size <= 4) Then
    mAdvertencia "ADVERTENCIA: El reporte podra no imprimirse completo con su actual configuracin de impresin"
    If Not Confirmar("Desea emitirlo, a pesar de ello") Then
      SetReportWidth = False
      Exit Function
    End If
  End If
  
  LinesPerPage = Printer.ScaleHeight / Printer.TextHeight("N") - 3
  SetReportWidth = True
  
  Exit Function

SkipPConfig:
    
  Err.Clear
  mAdvertencia "La impresora instalada no soporta alguna de las caractersticas" & vbCrLf & _
               "necesarias para la correcta presentacin de los reportes."
  If Not Confirmar("Desea emitirlo, a pesar de ello") Then
    SetReportWidth = False
    Exit Function
  End If
  LinesPerPage = 32767
  ReportWidth = True

End Function

Private Sub cbPrinterFonts_Click()
    
  Me.CommonDialog1.FontName = Printer.Font.Name
  Me.CommonDialog1.FontSize = Printer.Font.Size
  Me.CommonDialog1.FontBold = Printer.Font.Bold
  Me.CommonDialog1.FontItalic = Printer.Font.Italic

  Me.CommonDialog1.Flags = cdlCFFixedPitchOnly + cdlCFPrinterFonts
  Me.CommonDialog1.CancelError = True
  
  On Error GoTo ErrHandler
  Me.CommonDialog1.ShowFont
  Me.CommonDialog1.CancelError = False

  Printer.Font.Name = CommonDialog1.FontName
  Printer.Font.Size = CommonDialog1.FontSize
  Printer.Font.Bold = CommonDialog1.FontBold
  Printer.Font.Italic = CommonDialog1.FontItalic
  
  Text1.Font.Name = Printer.Font.Name
  FontOverriden = True
  Exit Sub

ErrHandler:
    
  If Err.Number <> 32755 Then
    On Error GoTo 0
    Resume
  End If
  
  Me.CommonDialog1.CancelError = False
  Err.Clear
  
End Sub

Private Sub Command1_Click()
Static sString As String
Dim lPos As Long, sPos As Long

  sPos = Text1.SelStart + Text1.SelLength + 1
  If sPos >= Len(Text1.Text) Then sPos = 0
  
  sString = InputBox("Introduzca el texto a localizar:", "Buscar", sString)
  If sString = "" Then Exit Sub
  If Text1.Find(sString, sPos, Len(Text1.Text), 0) < 0 Then
    MsgBox "No se localiz el texto deseado", vbExclamation, "ADVERTENCIA"
  End If
  
End Sub

Private Sub cbGuardar_Click()
Dim sFileName As String
Dim orgCancelError As Boolean

  With Me.CommonDialog1
  .DialogTitle = "Nombre del archivo"
  .DefaultExt = ".txt"
  .Flags = cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNNoChangeDir Or cdlOFNOverwritePrompt
  .InitDir = GetSetting("ClearLight", "General", "DataDir", "")
  .Filter = "Archivos de Texto|*.txt"
  orgCancelError = .CancelError
  .CancelError = True
  On Error GoTo ErrHandler
  .ShowSave
  sFileName = .FileName
  End With

  Me.Text1.SaveFile sFileName, rtfText
  Exit Sub

ErrHandler:
  Err.Clear
End Sub

Private Sub Form_Activate()
  If isDirty Then
    Text1.SelStart = 1
    isDirty = False
  End If
End Sub

Private Sub Form_Initialize()
  NumPagina = 1
  NumLinea = 1
  nLeftMargin = 0
  sFontName = "Courier New"
  sFontSize = 10
  nMaxFont = Val(GetSetting("VSL", "FVIEW", "MaxFontSize", "14"))
  dfsFactor = Val(GetSetting("VSL", "FVIEW", "FontFactor", "1"))
  nFontOffset = Val(GetSetting("VSL", "FVIEW", "FontOffset", "0"))
  SetReportWidth 120
  Printing = False
  FontOverriden = False
  Set NotifyClickTo = Nothing
End Sub

Private Sub AddItem(s As String)
  isDirty = True
  Text1.SelStart = Len(Text1.Text) + 1
  Text1.SelLength = 0
  Text1.SelText = Chr(13) & Chr(10) & s
End Sub

Public Sub PageBreak()
  NumLinea = 1
  AddItem String(ReportWidth + 2, "_")
  NumPagina = NumPagina + 1
End Sub

Public Sub Add(sTexto As String, Optional Align As AlignmentConstants)
Dim lTexto As String
    
  If NumLinea >= (LinesPerPage - 1) Then PageBreak
  Select Case Align
  Case vbLeftJustify
    lTexto = sTexto
  Case vbCenter
    If Len(sTexto) >= ReportWidth Then
      lTexto = Left(sTexto, ReportWidth)
    Else
      lTexto = Space((ReportWidth - Len(sTexto)) / 2) & sTexto
    End If
  Case vbRightJustify
    lTexto = Space(ReportWidth - Len(sTexto)) & sTexto
  End Select
  AddItem " " & lTexto
  
  If LinesPerPage <> 32767 Then
    NumLinea = NumLinea + 1
  End If
  
End Sub

Public Function Linea() As Integer
  Linea = NumLinea
End Function

Public Function Pagina() As Integer
  Pagina = NumPagina
End Function

Public Function LineasPagina() As Integer
  LineasPagina = LinesPerPage - 1
End Function

Public Sub PrintListBox()
Dim i As Long, l As Long, j As Long, n As Long
Dim stOut As String, yCoord As Long
    
  On Error GoTo EndPrint
  yCoord = 0: Printer.Print " "
  If Not FontOverriden Then SetReportWidth ReportWidth
  i = 1: l = Len(Text1.Text)
  Printing = True
  Do While i <= l And Printing
    n = InStr(i, Text1.Text, Chr(13) & Chr(10), vbTextCompare)
    If n = 0 Then n = l + 1
    stOut = Mid(Text1.Text, i, n - i)
    i = n + 2   ' Siguiente linea
    If UCase(Printer.DeviceName) = "VERIFONE" Then
      Printer.Print stFullLength(stOut, 40) & vbCr;
    Else
      If Left(stOut, 1) = "_" Then
        Printer.NewPage
        yCoord = 0
      Else
        stOut = String(nLeftMargin, " ") & stOut
        Printer.Print stOut
'        TextOutW Printer.hDC, (Printer.Height - Printer.ScaleHeight) / Printer.TwipsPerPixelX, yCoord / Printer.TwipsPerPixelY, stOut, Len(stOut)
        yCoord = yCoord + Printer.TextHeight("N")
      End If
    End If
  Loop
  If Printing Then
    Printer.EndDoc
    Printing = False
  Else
    Printer.KillDoc
  End If

  Exit Sub

EndPrint:

  ReportarError False, Err.Number, Err.Description, "lfQuickView::PrintText"
  Err.Clear
  Printing = False

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    If KeyAscii = 27 Then Me.Hide
End Sub

Private Sub Form_Load()

  Me.Top = 0
  Me.Left = 0
  Text1.Text = ""
  Text1.RightMargin = 48000
  If CBool(GetSetting("VSL", "FVIEW", "EditQView", "0")) Then
    Me.Text1.Locked = False
  Else
    Me.Text1.Locked = True
  End If

End Sub

Private Sub Form_Resize()
Dim nCoord As Long
    
  If Width < 10200 Then Width = 10200
  If Height < 3500 Then Height = 3500

  nCoord = Height - 1080
  imgFontGrow.Top = nCoord
  imgFontShrink.Top = nCoord
  cbPrinterFonts.Top = nCoord
  Command1.Top = nCoord
  cbGuardar.Top = nCoord
  cbImprimir.Top = nCoord
  cbCerrar.Top = nCoord
  cbGuardar.Left = Width - 7020
  Command1.Left = Width - 5310
  cbImprimir.Left = Width - 3600
  cbCerrar.Left = Width - 1890
  Text1.Height = Height - 1275
  Text1.Width = Width - 465
  If Text1.RightMargin < Text1.Width Then Text1.RightMargin = Text1.Width

End Sub

Private Sub imgFontGrow_Click()
Dim nactSize As Integer
    nactSize = Text1.Font.Size
    If nactSize >= 23 Then Exit Sub
    nactSize = nactSize + 1
    Text1.Font.Size = nactSize
    Text1.Refresh
End Sub

Private Sub imgFontGrow_DblClick()
    imgFontGrow_Click
End Sub

Private Sub imgFontShrink_Click()
Dim nactSize As Integer
    nactSize = Text1.Font.Size
    If nactSize <= 5 Then Exit Sub
    nactSize = nactSize - 1
    Text1.Font.Size = nactSize
    Text1.Refresh
End Sub

Private Sub imgFontShrink_DblClick()
    imgFontShrink_Click
End Sub

Private Sub Text1_DblClick()
Dim posStart As Long, posEnd As Long, ch As String
Dim wasProcessed As Boolean

  posStart = Text1.SelStart
  If posStart > 0 Then
  Do
    ch = Mid(Text1.Text, posStart, 1)
    If (ch < " ") Then Exit Do
    posStart = posStart - 1
  Loop While posStart > 0
  End If
  
  posEnd = Text1.SelStart
  If posEnd = 0 Then posEnd = 1
  If posEnd < Len(Text1) Then
    Do
      ch = Mid(Text1.Text, posEnd, 1)
      If (ch < " ") Then Exit Do
      posEnd = posEnd + 1
    Loop While posEnd < Len(Text1)
  End If
  
  
  If posEnd = posStart Then Exit Sub
  ch = Mid(Text1.Text, posStart + 1, posEnd - posStart - 1)
  
  ' Allow client to process Event
  wasProcessed = False
  RaiseEvent ReportClicked(wasProcessed, ch, Text1.SelStart - posStart)
  
'  DoEvents
  If Not wasProcessed Then
  ' ... o utilizar el mecanismo original de CallBack
    On Error Resume Next
    If Not NotifyClickTo Is Nothing Then
      NotifyClickTo.ReportClicked ch, Text1.SelStart - posStart
    End If
  End If

  Text1.SelLength = 0
  
End Sub
