VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "GEDObject"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' The form using the services contained herein, must
' 1.- Initialize the form. Calling 'Init Me, <flexGrid>'
' 2.- Associate the following Grid's events with the
'     corresponding methods:
'     flexGrid_Scroll = GEDObject.Scroll
'     flexGrid.GotFocus = GEDObject.EnterCell
'     flexGrid.EnterCell = GEDObject.EnterCell
' On loading the form, the following attributes must be
' set for the columns:
'       .ColAlignment
'       .TextMatrix(0, <Col>) (Column's title)
'       .ColWidth
' Plus associating a form's control to the column:
'       GEDObject.AddControl <Col>, <FormControl>
'       [<FormControl> debe poder responder a las propiedades siguientes:
'           Text, SelStart, SelLength, Visible y Enabled. Ademas, debe poder
'           responder a los eventos GotFocus, LostFocus y KeyDown]
'       (Controls should have Visible = NO)
'        Tested controls are MaskedEdit, ComboBoxes and TextBoxes
'        Tambien se han probado diferentes clases de UserControls.
' After processing the grid's contents, and before reusing
' it from within the same instance of the form, you must call
' GEDObject.GED_Clear and reassign the columns titles to .TextMatrix(0, <Col>)
'
' Controls associated with GEDObject must have any value
' in their Tag properties, starting with the string "GED"
' The following events in the associated controls, must
' be mapped to a corresponding GEDObject handler:
'     LostFocus = GEDObject.ControlLost
'     KeyDown = GEDObject.KeyDown (pass the same parameters)
' It is convenient that text boxes set KeyAscii = 0 on response
' to KeyPressed if KeyAscii=vbReturn
' Besides, the form must implement the following public
' functions:
' - ValidateCell(long Row, long Col) as Boolean:
'     Returns whether the user entered contents is valid
'     for the given cell.
' - IsRowValid(long Row) as Boolean
'     Return whether the full contents of the row is valid.
'     (and may change the values in whatever form the app. needs)
' - MayAddRow(long nRows) as Boolean
'     nRows is equal to flexGrid.Rows. The application
'     decides whether a new row may be added, or not.
' - MayDeleteRow(long Row) as Boolean
'     The application decides whether the row(Row) may be
'     deleted.
' - Sub FillNewRow(long Row)
'     The application (form) may set the contents of a
'     newly created row.
' Any given control may be used for different columns.
' BUGS:
' For some reason (so far unknown(*)) the ParentForm requires
' at list one active control besides those used for cell
' editing.
' (*) Tiene que ver con las secuencias de eventos y la trans-
' ferencia de foco entre los controles.
'----------------------------------------------

Public OrgCellContents As String
' Almacena el contenido de la celda ANTES de la edicin...
Public cCol As Long, cRow As Long

Private ColControls As Collection
Private ParentForm As Object        ' La forma que contiene (tal vez indirectamente) al Grid en edicion
Private Parent As Object            ' El objeto que contiene -directamente- al grid. Responsable de las validaciones de celdas y filas
Private cControl As Control
Private cGrid As MSFlexGrid
Public doValidate As Boolean
Public stOriginalContents As String ' Contenido original de la celda
Private Declare Function GetTickCount Lib "Kernel32" () As Long
Private TicksLastEvent As Long, TicksNow As Long

Private AlternateColor As Long, BackColor As Long
Private AlternateForeColor As Long, ForeColor As Long

Private sOrgContents() As String
Private orgRow As Long

Public Property Get OrgContents(Index As Integer)
Dim v
  On Error Resume Next
  v = sOrgContents(Index)
  If Err.Number Then Err.Clear
  OrgContents = v
End Property

' Almacena los valores iniciales del renglon...
Private Sub EnterRow()
Dim i As Long
  If UBound(sOrgContents) < cGrid.Cols Then
    ReDim sOrgContents(cGrid.Cols)
  End If
  If orgRow = cRow Then Exit Sub
  For i = 0 To cGrid.Cols - 1
    Debug.Print "Col(" & i & ") = " & cGrid.TextMatrix(cRow, i) & " ";
    sOrgContents(i) = cGrid.TextMatrix(cRow, i)
  Next
  orgRow = cRow
  Debug.Print
End Sub

Public Function Grid() As MSFlexGrid
  Set Grid = cGrid
End Function

'Private Sub Dump(strID As String)
'On Error Resume Next
'Debug.Print "-------------------------"
'Debug.Print strID
'Debug.Print "Time: " & GetTickCount
'Debug.Print cControl.Name & ": " & cControl.Text
'With cGrid
'    Debug.Print ".Row, .Col: " & .Row & ", " & .col
'    Debug.Print ".TextMatrix: " & .TextMatrix(.Row, .col)
'    Debug.Print "cRow, cCol: " & cRow & ", " & cCol
'    Debug.Print ".TextMatrix: " & .TextMatrix(cRow, cCol)
'    Debug.Print "ParentForm.Control=" & ParentForm.ActiveControl.Name
'    Debug.Print "Parent.Control=" & Parent.ActiveControl.Name
'End With
'End Sub

Public Property Get Name() As String
  Name = TypeName(Me)
End Property

Public Function SumaColumna(Index As Integer) As Double
    SumaColumna = lmGridUtils.SumaColumna(cGrid, (Index))
End Function

Public Function IsEmpty(nRow As Long) As Boolean
    IsEmpty = lmGridUtils.IsEmpty(cGrid, nRow)
End Function

Public Sub CleanRow(nRow As Long)
    lmGridUtils.CleanRow cGrid, nRow
End Sub

Public Sub SetParentForm(p As Form)
    Set ParentForm = p
End Sub

Private Sub SetBackColor(nRow As Long)
Dim nCol As Long, orgValidate As Boolean
Dim orgRow As Long, orgCol As Long
Dim nColor As Long, nForeColor As Long

  If AlternateColor = 0 Then Exit Sub
  If (nRow Mod 2 = 1) Then
    nColor = BackColor
    nForeColor = ForeColor
  Else
    nColor = AlternateColor
    nForeColor = AlternateForeColor
  End If
  orgRow = cGrid.Row: orgCol = cGrid.Col
  orgValidate = doValidate
  cGrid.Row = nRow
  doValidate = False
  For nCol = cGrid.FixedCols To cGrid.Cols - 1
    cGrid.Col = nCol
    cGrid.CellBackColor = nColor
    cGrid.CellForeColor = nForeColor
  Next
  cGrid.Row = orgRow: cGrid.Col = orgCol
  doValidate = orgValidate

End Sub

Public Sub SetGridColors()
Dim bOrgValidate As Boolean, i As Long
  bOrgValidate = doValidate
  doValidate = False
  For i = 1 To cGrid.Rows - 1
    SetBackColor i
  Next
  doValidate = bOrgValidate
End Sub

Public Sub GED_Clear()
Dim i As Integer, j As Integer, pControl As Control
'   cGrid.Clear
    cGrid.Rows = cGrid.FixedRows + 1
    doValidate = False
    cGrid.Row = cGrid.FixedRows: cGrid.Col = cGrid.FixedCols
'   Was: cGrid.Row = cGrid.FixedRows
    cCol = -1: cRow = -1
    i = cGrid.FixedCols
    Do While i < cGrid.Cols
        On Error GoTo ErrHandler
        Set pControl = ColControls.Item(Trim(Str(i)))
        pControl.Visible = False
ResumePoint:
        i = i + 1
    Loop

    On Error GoTo 0

    CleanRow cGrid.FixedRows
    doValidate = True
    
    cGrid.LeftCol = 0
    
    i = cGrid.FixedCols
    
    Do While i < cGrid.Cols
        On Error GoTo ErrHandler2
        Set cControl = ColControls.Item(Trim(Str(i)))
        Exit Sub
ResumePoint2:
        i = i + 1
    Loop

    ReportarError False, vbObjectError + 10001, "GridEditor:No hay controles definidos", "GEDObject::GedClear"
    Exit Sub

ErrHandler:
    Err.Clear
    Resume ResumePoint

ErrHandler2:
    Err.Clear
    Resume ResumePoint2

End Sub

Public Sub init(RefForma As Object, RefGrid As MSFlexGrid)
Dim i As Long

  ReDim sOrgContents(RefGrid.Cols)
  
  If Not ColControls Is Nothing Then
    For i = ColControls.Count To 1 Step -1
      ColControls.Remove i
    Next
    Set ColControls = Nothing
  End If
  
  Set ColControls = New Collection
  Set Parent = RefForma
  Set ParentForm = RefForma
  Set cGrid = RefGrid
  cGrid.LeftCol = cGrid.FixedCols
  cCol = -1: cRow = -1
  If AlternateColor <> 0 Then
    cGrid.Gridlines = flexGridNone
    cGrid.GridLinesFixed = flexGridNone
    If cGrid.RowHeightMin = 0 Then cGrid.RowHeightMin = 285 ' >  * (Screen.Height * Screen.TwipsPerPixelY) / 600
  Else
    If cGrid.RowHeightMin = 0 Then cGrid.RowHeightMin = 315 ' * (Screen.Height / Screen.TwipsPerPixelY) / 600
  End If
  For i = cGrid.FixedRows To cGrid.Rows - 1
    SetBackColor i
  Next
  doValidate = True
'    TicksLastEvent = GetTickCount
End Sub

Public Sub AddControl(Index As Integer, pControl As Control)
    If ColControls.Count = 0 Then Set cControl = pControl
    ColControls.Add pControl, Trim(Str(Index))
'    cGrid.ColWidth(Index) = pControl.Width
End Sub

Public Sub ChangeControl(Index As Integer, pNewControl As Control)
    
    On Error Resume Next
    ColControls.Remove Trim(Str(Index))
    ColControls.Add pNewControl, Trim(Str(Index))

End Sub

Private Sub SetcControl()
'Dump "SetcControl"
' Rev 28-1-2002: Todas las referencias a cCol y cRow eran originalmente a .Col y .Row
  On Error GoTo ErrHandler

  With cGrid
  Set cControl = ColControls.Item(Trim(Str(cCol)))
  cControl.Text = .TextMatrix(cRow, cCol)
  cControl.left = .CellLeft + .left
  cControl.top = .CellTop + .top - 15
  cControl.Width = .ColWidth(cCol)
  cControl.Enabled = True
  cControl.Visible = True
  cControl.ZOrder
  If Not ParentForm.Enabled Then
'Dump "Exit(SetcControl)"
    Exit Sub
  End If
  If cControl.Visible Then cControl.SetFocus
  End With

'Dump "Exit(SetcControl)"
  Exit Sub

ErrHandler:
  If cCol < Grid.Cols - 1 Then
    cCol = cCol + 1
    Grid.Col = cCol
    Err.Clear
    Resume
  End If
  Err.Clear
End Sub

Private Sub GED_Release()
  If Not ColControls Is Nothing Then
    While ColControls.Count > 0
        ColControls.Remove 1
    Wend
  End If
  Set ColControls = Nothing
  Set ParentForm = Nothing
  Set Parent = Nothing
  Set cControl = Nothing
  Set cGrid = Nothing
End Sub

Private Sub GED_HideControl()
    If cControl.Visible Then
        On Error GoTo ErrHandler
        cGrid.TextMatrix(cRow, cCol) = cControl.Text
        If Not Parent.ValidateCell(cRow, cCol) Then
          If cControl.Visible Then cControl.SetFocus
          Exit Sub
        End If
DoHide:
        cControl.Enabled = False
        cControl.Visible = False
    End If
    
    Exit Sub

ErrHandler:

    Resume DoHide
End Sub

Private Sub SureVisible(ByVal Row As Integer, ByVal Col As Integer)
  doValidate = False
  With cGrid
    If Not .ColIsVisible(Col) Then
      If Col < .LeftCol Then
        .LeftCol = Col
      Else
        Do
          .LeftCol = .LeftCol + 1
        Loop Until .ColIsVisible(Col)
      End If
    End If
    If Not .RowIsVisible(Row) Then
      If Row < .TopRow Then
        .TopRow = Row
      Else
        Do
          .TopRow = .TopRow + 1
        Loop Until .RowIsVisible(Row)
      End If
    End If
  End With
  doValidate = True
End Sub

Public Sub ControlLost()
Dim lControl As Control

  TicksNow = GetTickCount
  If TicksNow - TicksLastEvent < 40 Then Exit Sub
  TicksLastEvent = GetTickCount
  
  'Dump "ControlLost"
  DoEvents
  If Not ParentForm.Enabled Then Exit Sub
  If Not cControl.Visible Then Exit Sub
  
  If ParentForm.ActiveControl.Name = "cbCancelar" Then
    cControl.Visible = False
  'Dump "Exit(ControlLost)"
    Exit Sub
  End If
  
  If ParentForm.ActiveControl Is cControl Then
  'Dump "Exit(ControlLost)"
    Exit Sub
  End If
  
  With cGrid
    If cCol = .Col And cRow = .Row Then
  
      If ParentForm.ActiveControl Is cGrid Or left(ParentForm.ActiveControl.Tag, 5) = "GGRID" Then
        cControl.SetFocus
      'Dump "Exit(ControlLost)"
        Exit Sub
      End If
  
  ' Added rev. 24.4.2000
      GED_HideControl
      If cControl.Visible Then cControl.SetFocus
' End add.rev. 24.4.2000
'Dump "Exit(ControlLost)"
      Exit Sub
    End If
  
  '        .Enabled = False         ' Cambio: 27-2-2000
  '        doValidate = False              ' En caso de que el foco est entrando a la celda. Commented out on rev. 24.4.2000
    GED_HideControl
  '        doValidate = True      ' Commented out on rev. 24.4.2000
    If cControl.Visible Then Exit Sub   ' Added Rev. 24.2.2000
  
    If Not Parent.ValidateCell(cRow, cCol) Then
      doValidate = False
      .Row = cRow: .Col = cCol
      SureVisible .Row, .Col
      SetcControl
      doValidate = True
    End If
  '        .Enabled = True
  End With
  TicksLastEvent = GetTickCount
  
  'Dump "Exit(ControlLost)"
End Sub

Public Sub EnterCell()
'TicksNow = GetTickCount
'If TicksNow - TicksLastEvent < 60 Then Exit Sub
  If Not doValidate Then
    Exit Sub
  End If
'Dump "EnterCell"
' Aadido 28-1-2002
'   GED_HideControl
  DoEvents
  With cGrid
  OrgCellContents = .TextMatrix(.Row, .Col)

  If .Row < .FixedRows Then
    If .Rows = .FixedRows Then .Rows = .Rows + 1
    .Row = .FixedRows
'Dump "Exit(EnterCell)"
    Exit Sub
  End If
  
  If cControl.Visible Then
    If .Col = cCol And .Row = cRow Then Exit Sub
'       doValidate = False
    GED_HideControl
'       doValidate = True
    If cControl.Visible Then
      doValidate = False
      .Row = cRow: .Col = cCol
      doValidate = True
'Dump "Exit(EnterCell)"
      Exit Sub       ' ... pero si no la caus, fue porque no pas la validacin
    End If
  End If

  cCol = .Col: cRow = .Row
  EnterRow
  SetcControl
  End With

'Dump "Exit(EnterCell)"

End Sub

Private Function NextCol(ByVal nCol As Long) As Long
Dim nRetVal As Long, isVisible As Boolean

    nRetVal = nCol + 1
    
    Do While nRetVal < cGrid.Cols
        On Error GoTo NoControl
        isVisible = ColControls.Item(Trim(Str(nRetVal))).Visible
        NextCol = nRetVal
        Exit Function
ResumePoint:
        nRetVal = nRetVal + 1
    Loop

    NextCol = nRetVal
    Exit Function

NoControl:
'    nRetVal = nRetVal + 1
    Resume ResumePoint

End Function

Private Function PrevCol(ByVal nCol As Long) As Long
Dim nRetVal As Long, b As Boolean

    nRetVal = nCol - 1
    
    Do While nRetVal > cGrid.FixedCols
        On Error GoTo NoControl
        b = ColControls(Trim(Str(nRetVal))).Visible
        PrevCol = nRetVal
        Exit Function
ResumePoint:
        nRetVal = nRetVal - 1
    Loop

    PrevCol = nRetVal
    Exit Function

NoControl:
    Resume ResumePoint

End Function

Public Sub KeyDown(KeyCode As Integer, Shift As Integer)
Dim DestCol As Integer, i As Long

  DoEvents: DoEvents: DoEvents
  With cGrid
    Select Case KeyCode
    Case vbKeyReturn
      GED_HideControl
      If cControl.Visible Then Exit Sub
      KeyCode = 0
      DestCol = NextCol(.Col)
      If DestCol >= .Cols Then
        If Not Parent.IsRowValid(cRow) Then
          EnterCell
          Exit Sub
        End If
        GotoNextRow
      Else
        .Col = DestCol
      End If
    Case vbKeyDown
      If Shift And 2 Then Exit Sub
    
      GED_HideControl
      If cControl.Visible Then Exit Sub
      KeyCode = 0
      GotoNextRow
    
    Case vbKeyUp
      If Shift And 2 Then Exit Sub
    
      If cRow = cGrid.FixedRows Then
        Exit Sub
      End If
      GED_HideControl
      If cControl.Visible Then Exit Sub
      KeyCode = 0
      GotoPrevRow
    
    Case vbKeyLeft
      If Shift And (vbAltMask Or vbCtrlMask Or vbShiftMask) Then
        GED_HideControl
        If cControl.Visible Then Exit Sub
        KeyCode = 0
        DestCol = PrevCol(.Col)
        If (DestCol >= .FixedCols) Then .Col = DestCol
      End If
    Case vbKeyRight
      If Shift And (vbAltMask Or vbCtrlMask Or vbShiftMask) Then
        GED_HideControl
        If cControl.Visible Then Exit Sub
        KeyCode = 0
        DestCol = NextCol(.Col)
        If DestCol < .Cols Then .Col = DestCol
      End If
    Case vbKeyBack
      If Shift And (vbAltMask Or vbCtrlMask Or vbShiftMask) Then
        KeyCode = 0
        If Parent.MayDeleteRow(.Row) Then
        ' Adicion 26-01-2002
          cControl.Visible = False
          cControl.Enabled = False
        ' Fin Adicion
          GED_HideControl
          doValidate = False
          If .Rows - 1 = .FixedRows Then
            For i = 0 To .Cols - 1
              .TextMatrix(.Row, i) = ""
              'ColControls(i + 1).Text = ""
            Next
          Else
            .RemoveItem .Row
            For i = .TopRow To .Rows - 1
              SetBackColor i
            Next
          End If
          orgRow = 0
          cRow = .Row: .Col = 0: cCol = 0
          If cRow > .Rows - 1 Then cRow = .Rows - 1
          EnterRow
          SetcControl
          doValidate = True
        Else
          EnterCell
        End If
      End If
    End Select
  End With
End Sub

Private Sub GotoNextRow()
Dim i As Long
  If Not Parent.IsRowValid(cGrid.Row) Then
    EnterCell
    Exit Sub
  End If
  With cGrid
    If .Row = .Rows - 1 Then
      If Parent.MayAddRow(.Rows) Then
        .Rows = .Rows + 1
        doValidate = False
        .Col = .FixedCols
        If Not .ColIsVisible(.Col) Then .LeftCol = .Col
        SetBackColor .Rows - 1
        doValidate = True
        On Error Resume Next
        Parent.FillNewRow .Rows - 1
        If Err.Number <> 0 Then Err.Clear
      Else
        EnterCell
        Exit Sub
      End If
    End If
    doValidate = False
    .Row = .Row + 1 ' Aqui se activa  RowColChange
    doValidate = True
    Do While Not .RowIsVisible(.Row)
      .TopRow = .TopRow + 1
    Loop
    EnterCell
  End With
End Sub

Private Sub GotoPrevRow()
  If Not Parent.IsRowValid(cGrid.Row) Then
    EnterCell
    Exit Sub
  End If
  With cGrid
    If .Row > .FixedRows Then
      doValidate = False
      .Row = .Row - 1
      doValidate = True
      Do While Not .RowIsVisible(.Row)
        .TopRow = .TopRow - 1
      Loop
    End If
    EnterCell
  End With
End Sub

Public Sub Scroll()
  With cGrid
    If cControl.Visible Then
      cGrid.TextMatrix(cRow, cCol) = cControl.Text
      cControl.Visible = False
      cControl.Enabled = False
    End If
  End With
End Sub

Private Sub Class_Initialize()
    cCol = -1: cRow = -1
    AlternateColor = Val(GetSetting("VSL", "Config", "GEDITFondoAlterno", "0"))
    AlternateForeColor = Val(GetSetting("VSL", "CONFIG", "GEDITTextoAlterno", "-2147483640"))
    BackColor = Val(GetSetting("VSL", "CONFIG", "GEDITFondoNormal", "-2147483643"))
    ForeColor = Val(GetSetting("VSL", "CONFIG", "GEDITTextoNormal", "-2147483640"))
End Sub

Private Sub Class_Terminate()
    GED_Release
End Sub
