VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "GEDObject"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' The form using the services contained herein, must
' 1.- Initialize the form. Calling 'Init Me, <flexGrid>'
' 2.- Associate the following Grid's events with the
'     corresponding methods:
'     flexGrid_Scroll = GEDObject.Scroll
'     flexGrid.GotFocus = GEDObject.EnterCell
'     flexGrid.EnterCell = GEDObject.EnterCell
' On loading the form, the following attributes must be
' set for the columns:
'       .ColAlignment
'       .TextMatrix(0, <Col>) (Column's title)
'       .ColWidth
' Plus associating a form's control to the column:
'       GEDObject.AddControl <Col>, <FormControl>
'       [<FormControl> debe poder responder a las propiedades siguientes:
'           Text, SelStart, SelLength, Visible y Enabled. Ademas, debe poder
'           responder a los eventos GotFocus, LostFocus y KeyDown]
'       (Controls should have Visible = NO)
'        Tested controls are MaskedEdit, ComboBoxes and TextBoxes
'        Tambien se han probado diferentes clases de UserControls.
' After processing the grid's contents, and before reusing
' it from within the same instance of the form, you must call
' GEDObject.GED_Clear and reassign the columns titles to .TextMatrix(0, <Col>)
'
' Controls associated with GEDObject must have any value
' in their Tag properties, starting with the string "GED"
' The following events in the associated controls, must
' be mapped to a corresponding GEDObject handler:
'     LostFocus = GEDObject.ControlLost
'     KeyDown = GEDObject.KeyDown (pass the same parameters)
' It is convenient that text boxes set KeyAscii = 0 on response
' to KeyPressed if KeyAscii=vbReturn
' Besides, the form must implement the following public
' functions:
' - ValidateCell(long Row, long Col) as Boolean:
'     Returns whether the user entered contents is valid
'     for the given cell.
' - IsRowValid(long Row) as Boolean
'     Return whether the full contents of the row is valid.
'     (and may change the values in whatever form the app. needs)
' - MayAddRow(long nRows) as Boolean
'     nRows is equal to flexGrid.Rows. The application
'     decides whether a new row may be added, or not.
' - MayDeleteRow(long Row) as Boolean
'     The application decides whether the row(Row) may be
'     deleted.
' - Sub FillNewRow(long Row)
'     The application (form) may set the contents of a
'     newly created row.
' Any given control may be used for different columns.
' BUGS:
' For some reason (so far unknown(*)) the ParentForm requires
' at list one active control besides those used for cell
' editing.
' (*) Tiene que ver con las secuencias de eventos y la trans-
' ferencia de foco entre los controles.
'----------------------------------------------

Public Event ValidateCell(ByVal Row As Long, ByVal Col As Long, ByRef isOk As Boolean)
Public Event IsRowValid(ByVal Row As Long, ByRef bisOk As Boolean)
Public Event MayDeleteRow(ByVal nRow As Long, ByRef bisOk As Boolean)
Public Event MayAddRow(ByVal nRows As Long, ByRef bisOk As Boolean)
Public Event FillNewRow(ByVal nRow As Long)

Public OrgCellContents As String

' Almacena el contenido de la celda ANTES de la edicin...

Private ColControls As Collection
Private ParentForm As Object        ' La forma que contiene (tal vez indirectamente) al Grid en edicion
Private Parent As Object            ' El objeto que contiene -directamente- al grid. Responsable de las validaciones de celdas y filas
Private cCol As Long, cRow As Long
Private cControl As Control
Private cGrid As MSFlexGrid
Private doValidate As Boolean
Public stOriginalContents As String ' Contenido original de la celda

Public Function SumaColumna(Index As Integer) As Double
Dim i As Integer, dAcc As Double
    dAcc = 0
    For i = 1 To cGrid.Rows - 1
        dAcc = dAcc + ValOf(cGrid.TextMatrix(i, Index))
    Next i
    SumaColumna = dAcc
End Function

Public Function IsEmpty(nRow As Long) As Boolean
Dim nCol As Integer

    For nCol = 0 To cGrid.Cols - 1
        If Trim(cGrid.TextMatrix(nRow, nCol)) <> "" Then
            IsEmpty = False
            Exit Function
        End If
    Next
    IsEmpty = True

End Function

Public Sub CleanRow(nRow As Long)
Dim nCol As Integer

    For nCol = 0 To cGrid.Cols - 1
        cGrid.TextMatrix(nRow, nCol) = ""
    Next

End Sub

Public Sub SetParentForm(p As Form)
    
    Set ParentForm = p

End Sub

Public Sub GED_Clear()
Dim i As Integer, j As Integer, pControl As Control
'   cGrid.Clear
    cGrid.Rows = cGrid.FixedRows + 1
    doValidate = False
    cGrid.Row = cGrid.FixedRows: cGrid.Col = cGrid.FixedCols
'   Was: cGrid.Row = cGrid.FixedRows
    cCol = -1: cRow = -1
    For i = cGrid.FixedCols To cGrid.Cols - 1
        Set pControl = ColControls.Item(Str(i))
        pControl.Visible = False
    Next

    CleanRow cGrid.FixedRows
    doValidate = True
    
    cGrid.LeftCol = 0
    Set cControl = ColControls.Item(Str(cGrid.FixedCols))

End Sub

Public Sub Init(RefForma As Object, RefGrid As MSFlexGrid)
    Set ColControls = New Collection
    Set Parent = RefForma
    Set ParentForm = RefForma
    Set cGrid = RefGrid
    cGrid.LeftCol = cGrid.FixedCols
    cCol = -1: cRow = -1
    doValidate = True
End Sub

Public Sub AddControl(Index As Integer, pControl As Control)
    If ColControls.Count = 0 Then Set cControl = pControl
    ColControls.Add pControl, Str(Index)
'    cGrid.ColWidth(Index) = pControl.Width
End Sub

Public Sub ChangeControl(Index As Integer, pNewControl As Control)
    
    On Error Resume Next
    ColControls.Remove Str(Index)
    ColControls.Add pNewControl, Str(Index)

End Sub
Private Sub SetcControl()
    With cGrid
    Set cControl = ColControls.Item(Str(.Col))
    cControl.Text = .TextMatrix(.Row, .Col)
    cControl.left = .CellLeft + .left
    cControl.top = .CellTop + .top - 15
    cControl.Width = .ColWidth(.Col)
    cControl.Enabled = True
    cControl.Visible = True
    cControl.ZOrder
    If Not ParentForm.Enabled Then Exit Sub
    If cControl.Visible Then cControl.SetFocus
    End With
End Sub

Private Sub GED_Release()
    While ColControls.Count > 0
        ColControls.Remove 1
    Wend
    Set ColControls = Nothing
    Set ParentForm = Nothing
    Set Parent = Nothing
    Set cControl = Nothing
    Set cGrid = Nothing
End Sub

Private Sub GED_HideControl()
Dim bRetVal As Boolean
'   DoEvents
    If cControl.Visible Then
        stOriginalContents = cGrid.TextMatrix(cRow, cCol)
        cGrid.TextMatrix(cRow, cCol) = cControl.Text
        bRetVal = True
        RaiseEvent ValidateCell(cRow, cCol, bRetVal)
        If Not bRetVal Then
            cControl.SetFocus
            Exit Sub
        End If
        stOriginalContents = cGrid.TextMatrix(cRow, cCol)
        cControl.Enabled = False
        cControl.Visible = False
    End If
End Sub

Private Sub SureVisible(ByVal Row As Integer, ByVal Col As Integer)
    doValidate = False
    With cGrid
        If Not .ColIsVisible(Col) Then
            If Col < .LeftCol Then
                .LeftCol = Col
            Else
                Do
                    .LeftCol = .LeftCol + 1
                Loop Until .ColIsVisible(Col)
            End If
        End If
        If Not .RowIsVisible(Row) Then
            If Row < .TopRow Then
                .TopRow = Row
            Else
                Do
                    .TopRow = .TopRow + 1
                Loop Until .RowIsVisible(Row)
            End If
        End If
    End With
    doValidate = True
End Sub

Public Sub ControlLost()
Dim lControl As Control
Dim bRetVal As Boolean

    DoEvents
    If Not ParentForm.Enabled Then Exit Sub
    If Not cControl.Visible Then Exit Sub

    If ParentForm.ActiveControl.Name = "cbCancelar" Then
        cControl.Visible = False
        Exit Sub
    End If

    If ParentForm.ActiveControl Is cControl Then Exit Sub

    With cGrid
        If cCol = .Col And cRow = .Row Then
            
            If ParentForm.ActiveControl Is cGrid Or left(ParentForm.ActiveControl.Tag, 5) = "GGRID" Then
                cControl.SetFocus
                Exit Sub
            End If

' Added rev. 24.4.2000
            GED_HideControl
            If cControl.Visible Then cControl.SetFocus
' End add.rev. 24.4.2000
            Exit Sub
        End If

'        .Enabled = False         ' Cambio: 27-2-2000
'        doValidate = False              ' En caso de que el foco est entrando a la celda. Commented out on rev. 24.4.2000
        GED_HideControl
'        doValidate = True      ' Commented out on rev. 24.4.2000
        If cControl.Visible Then Exit Sub   ' Added Rev. 24.2.2000

        bRetVal = True
        RaiseEvent ValidateCell(cRow, cCol, bRetVal)
        If Not bRetVal Then
            doValidate = False
            .Row = cRow: .Col = cCol
            SureVisible .Row, .Col
            SetcControl
            doValidate = True
        End If
'        .Enabled = True
    End With
End Sub

Public Sub EnterCell()
    
    If Not doValidate Then Exit Sub
 
    DoEvents
    With cGrid
    
    OrgCellContents = .TextMatrix(.Row, .Col)

    If .Row < .FixedRows Then
        If .Rows = .FixedRows Then .Rows = .Rows + 1
        .Row = .FixedRows
        Exit Sub
    End If
    
    If cControl.Visible Then
        If .Col = cCol And .Row = cRow Then Exit Sub
'       doValidate = False
        GED_HideControl
'       doValidate = True
        If cControl.Visible Then
            doValidate = False
            .Row = cRow: .Col = cCol
            doValidate = True
            Exit Sub       ' ... pero si no la caus, fue porque no pas la validacin
        End If
    End If

    cCol = .Col: cRow = .Row
    SetcControl
    End With
End Sub

Public Sub KeyDown(KeyCode As Integer, Shift As Integer)
Dim DestCol As Integer, bRetVal As Boolean
    
    With cGrid
        Select Case KeyCode
            Case vbKeyReturn
                GED_HideControl
                If cControl.Visible Then Exit Sub
                KeyCode = 0
                DestCol = .Col + 1
                If DestCol >= .Cols Then
                    bRetVal = True
                    RaiseEvent IsRowValid(cRow, bRetVal)
                    If Not bRetVal Then
                        EnterCell
                        Exit Sub
                    End If
                    GotoNextRow
                Else
                    .Col = DestCol
                End If
            Case vbKeyDown
                If Shift And 2 Then Exit Sub
                
                GED_HideControl
                If cControl.Visible Then Exit Sub
'               If Not Parent.ValidateCell(cRow, cCol) Then
'                   EnterCell
'                   Exit Sub
'               End If
                KeyCode = 0
                GotoNextRow
            Case vbKeyUp
                If Shift And 2 Then Exit Sub
                
                If cRow = cGrid.FixedRows Then
                    Exit Sub
                End If
                GED_HideControl
                If cControl.Visible Then Exit Sub
'               If Not Parent.ValidateCell(cRow, cCol) Then
'                   EnterCell
'                   Exit Sub
'               End If
                KeyCode = 0
                GotoPrevRow
            Case vbKeyLeft
                If Shift And (vbAltMask Or vbCtrlMask Or vbShiftMask) Then
                    GED_HideControl
                    If cControl.Visible Then Exit Sub
'                   If Not Parent.ValidateCell(cRow, cCol) Then
'                       EnterCell
'                       Exit Sub
'                   End If
                    KeyCode = 0
                    DestCol = .Col - 1
                    If (DestCol >= .FixedCols) Then .Col = DestCol
                End If
            Case vbKeyRight
                If Shift And (vbAltMask Or vbCtrlMask Or vbShiftMask) Then
                    GED_HideControl
                    If cControl.Visible Then Exit Sub
'                   If Not Parent.ValidateCell(cRow, cCol) Then
'                       EnterCell
'                       Exit Sub
'                   End If
                    KeyCode = 0
                    DestCol = .Col + 1
                    If DestCol < .Cols Then .Col = DestCol
                End If
            Case vbKeyBack
                If Shift And (vbAltMask Or vbCtrlMask Or vbShiftMask) Then
                    KeyCode = 0
                    
                    bRetVal = True
                    RaiseEvent MayDeleteRow(.Row, bRetVal)
                    If bRetVal Then
                        GED_HideControl
                        doValidate = False
                        If .Rows - 1 = .FixedRows Then
                            Dim i As Integer
                            For i = 0 To .Cols - 1
                                .TextMatrix(.Row, i) = ""
                                ColControls(i + 1).Text = ""
                            Next
                        Else
                            .RemoveItem .Row
                        End If
                        cRow = .Row: .Col = 0: cCol = 0
                        If cRow > .Rows - 1 Then cRow = .Rows - 1
                        SetcControl
                        doValidate = True
                    Else
                        EnterCell
                    End If
                End If
        End Select
    End With
End Sub

Private Sub GotoNextRow()
Dim bRetVal As Boolean

    bRetVal = True
    RaiseEvent IsRowValid(cGrid.Row, bRetVal)
    If Not bRetVal Then
        EnterCell
        Exit Sub
    End If
    With cGrid
        If .Row = .Rows - 1 Then
            bRetVal = True
            RaiseEvent MayAddRow(.Rows, bRetVal)
            If bRetVal Then
                .Rows = .Rows + 1
                doValidate = False
                .Col = .FixedCols
                If Not .ColIsVisible(.Col) Then .LeftCol = .Col
                doValidate = True
                RaiseEvent FillNewRow(.Rows - 1)
            Else
                EnterCell
                Exit Sub
            End If
        End If
        doValidate = False
        .Row = .Row + 1 ' Aqui se activa  RowColChange
        doValidate = True
        Do While Not .RowIsVisible(.Row)
            .TopRow = .TopRow + 1
        Loop
        EnterCell
    End With
End Sub

Private Sub GotoPrevRow()
Dim bRetVal As Boolean

    bRetVal = True
    RaiseEvent IsRowValid(cGrid.Row, bRetVal)

    If Not bRetVal Then
        EnterCell
        Exit Sub
    End If
    With cGrid
        If .Row > .FixedRows Then
            doValidate = False
            .Row = .Row - 1
            doValidate = True
            Do While Not .RowIsVisible(.Row)
                .TopRow = .TopRow - 1
            Loop
        End If
        EnterCell
    End With
End Sub

Public Sub Scroll()
    With cGrid
        If cControl.Visible Then
            cGrid.TextMatrix(cRow, cCol) = cControl.Text
            cControl.Visible = False
            cControl.Enabled = Falase
        End If
    End With
End Sub

Private Sub Class_Initialize()
    cCol = -1: cRow = -1
End Sub

Private Sub Class_Terminate()
    GED_Release
End Sub
