VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CexpEvaluator"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para la evaluacion de expresiones"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const opr1 As String = "/*+-%^&|<>="
Const opr2 As String = "+%-%<=>=<>"

Enum SymType
    Numero = 1
    Variable = 2
    Funcion = 3
    Operador = 4
    EOXP = 5
    SyntaxError = 6
End Enum

Private iNextCh As Integer, _
        iState As Integer, _
        cSym As String, _
        sExpression As String
Private instEvaluator As CvarEvaluator
Private dblResultado As String

Property Let Expression(s As String)
    sExpression = s
    Eval
End Property

Property Get Expression() As String
    Expression = sExpression
End Property

Sub SetVarEval(arg As CvarEvaluator)
    Set instEvaluator = arg
End Sub

Property Get CheckSintax() As Boolean
    Eval
    CheckSintax = (iState = 4)
End Property

Property Get Valor() As Double
    Eval
    Valor = dblResultado
End Property

' ------------------------------------------------------------
' Funciones privadas
Private Function isBinOp(s As String) As Integer
Dim i As Integer, l As Integer, found As Boolean, t As String
    i = 1: l = Len(opr2) / 2
    Do
        t = Mid(opr2, i * 2 - 1, 2)
        found = (StrComp(t, s, vbTextCompare) = 0)
        If Not found Then i = i + 1
    Loop While i <= l And Not found
    If i > l Then i = 0
    isBinOp = i
End Function

Private Function isOp(s As String) As Integer
Dim i As Integer, l As Integer, found As Boolean, t As String
    i = 1: l = Len(opr1)
    Do
        t = Mid(opr1, i, 1)
        found = (StrComp(t, s, vbTextCompare) = 0)
        If Not found Then i = i + 1
    Loop While i <= l And Not found
    If i > l Then i = 0
    isOp = i
End Function

Private Function ParseNumero() As SymType
Dim sAcum As String, sNextCh As String, i As Integer, isOk As Boolean
    i = iNextCh: sAcum = "": isOk = True
    Do
        sNextCh = GetCh(sExpression, i)
        Select Case sNextCh
        Case "-"
            If sAcum = "" Then ' Primer caracter (numero negativo)
                sAcum = sAcum & sNextCh
                i = i + 1
            Else
                isOk = False
            End If
        Case "0" To "9", ",", "."
            sAcum = sAcum & sNextCh
            i = i + 1
        Case Else
            isOk = False
        End Select
    Loop While isOk

    iNextCh = i
    If sAcum <> "" Then
        cSym = sAcum
        ParseNumero = Numero
    Else
        ParseNumero = SyntaxError
    End If
End Function

Private Function ParseOperador() As SymType
Dim sAcum As String, sNextCh As String, i As Integer, isOk As Boolean
    i = iNextCh: sAcum = "": isOk = True
    sNextCh = GetCh(sExpression, i)
    sNextCh = sNextCh + GetCh(sExpression, i + 1)
    If isBinOp(sNextCh) Then
        iNextCh = iNextCh + 2
        cSym = sNextCh
    ElseIf isOp(Left(sNextCh, 1)) Then
        cSym = Left(sNextCh, 1)
        iNextCh = iNextCh + 1
    Else
        isOk = False
    End If
    
    If (isOk) Then
        ParseOperador = Operador
    Else
        ParseOperador = SyntaxError
    End If
End Function

Private Function ParseVarFunc() As SymType
Dim sAcum As String, sNextCh As String, i As Integer, isOk As Boolean, iType As SymType
Dim Result As Double
    
    If instEvaluator Is Nothing Then
        ParseVarFunc = SyntaxError
        Exit Function
    End If

    iType = Variable
    i = iNextCh: sAcum = "": isOk = True
    Do
        sNextCh = GetCh(sExpression, i)
        Select Case sNextCh
        Case "a" To "z", "A" To "Z", "0" To "9", "_", "$", "", ""
            sAcum = sAcum & sNextCh
            i = i + 1
        Case "("
            Do
                sAcum = sAcum & sNextCh
                i = i + 1
                sNextCh = GetCh(sExpression, i)
            Loop While sNextCh <> ")" And sNextCh <> ""
            If sNextCh = ")" Then i = i + 1
            sAcum = sAcum & ")"
            iType = Funcion
        Case Else
            isOk = False
        End Select
    Loop While isOk
    
    iNextCh = i

    If sAcum = "" Then
        ParseVarFunc = SyntaxError
    Else
        Result = instEvaluator.EvaluarVariable(sAcum)
        If instEvaluator.EvalResult = False Then
            ParseVarFunc = SyntaxError
        Else
            cSym = Trim(Str(Result))
            ParseVarFunc = Numero
        End If
    End If
End Function

Private Function ParseSubExp() As SymType
Dim sAcum As String, sNextCh As String, i As Integer, isOk As Boolean
Dim nParens As Integer, Result As Double
Dim subExpEval As CexpEvaluator

    i = iNextCh: sAcum = "": isOk = True
    sNextCh = GetCh(sExpression, i)
    If sNextCh = "(" Then
        nParens = 1
        i = i + 1
    Else
        ParseSubExp = SyntaxError
        Exit Function
    End If
    Do
        DoEvents
        sNextCh = GetCh(sExpression, i): i = i + 1
        Select Case sNextCh
        Case "("
            nParens = nParens + 1
            sAcum = sAcum + sNextCh
        Case ")"
            nParens = nParens - 1
            If (nParens) Then
                sAcum = sAcum + sNextCh
            End If
        Case Else
            sAcum = sAcum + sNextCh
        End Select
    Loop While nParens And sNextCh <> ""
    
    If nParens Then     ' Unmatched rParens
        ParseSubExp = SyntaxError
    Else
        iNextCh = i
        Set subExpEval = New CexpEvaluator
        subExpEval.SetVarEval instEvaluator
        subExpEval.Expression = sAcum
        If Not subExpEval.CheckSintax Then
            ParseSubExp = SyntaxError
        Else
            Result = subExpEval.Valor
            sAcum = Trim(Str(Result))
            ParseSubExp = Numero
        End If
        Set subExpEval = Nothing
        cSym = sAcum
    End If
End Function

Private Function Lex() As SymType
Dim sNextCh As String, i As Integer, l As Integer
Dim iSymType As SymType

    i = iNextCh: l = Len(sExpression)
    If i <= l Then
        sNextCh = Mid(sExpression, i, 1)
        Do While sNextCh = " " And i <= l
            i = i + 1
            sNextCh = Mid(sExpression, i, 1)
        Loop
    End If  ' En llegando aqu, estamos al comienzo de un nuevo simbolo, o EOXP
    
    iNextCh = i
    
    If i > l Then
        cSym = ""
        Lex = EOXP
        Exit Function
    End If
' i <= l
    sNextCh = Mid(sExpression, i, 1)
    Select Case sNextCh
        Case "0" To "9"
            iSymType = ParseNumero()
        Case "-"
            If iState = 0 Or iState = 2 Then
                iSymType = ParseNumero()
            Else
                iSymType = ParseOperador()
            End If
        Case "a" To "z", "A" To "Z", "", ""
            iSymType = ParseVarFunc()
        Case "("
            iSymType = ParseSubExp()    ' Devuelve "Numero"
        Case Else
            iSymType = ParseOperador()
    End Select
    Lex = iSymType
End Function

Private Sub Class_Initialize()
    Set instEvaluator = Nothing
    dblResultado = 0#
'   nErrorCode = 0
End Sub

Private Sub Class_Terminate()
    Set instEvaluator = Nothing
End Sub

Private Function xtractOperando(cSym As String) As String
Dim i As Integer
    i = InStr(cSym, " ")
    xtractOperando = Left(cSym, i - 1)
End Function

Private Function xtractOperador(cSym As String) As String
Dim i As Integer
    i = InStr(cSym, " ")
    xtractOperador = Right(cSym, Len(cSym) - i)
End Function

Private Sub Eval()
Dim colTerms(1 To 100) As String, _
    sOperando As String, _
    sOperador As String, _
    sOperandoX As String, _
    sOperadorX As String, _
    iType As SymType, _
    i As Integer, _
    q As Integer, _
    dblTemp1 As Double, _
    dblTemp2 As Double, _
    p As Integer, _
    r As Integer

    iState = 0: iNextCh = 1: q = 0
    Do
        DoEvents
        iType = Lex
        Select Case iState
        Case 0
            If iType <> Numero Then
                iState = 3      ' Error
            Else
                sOperando = cSym
                iState = 1
            End If
        Case 1
            If iType = Operador Then
                sOperador = cSym
                q = q + 1
                colTerms(q) = sOperando & " " & sOperador
                iState = 2
            ElseIf iType = EOXP Then
                q = q + 1
                colTerms(q) = sOperando & " " & "EOXP"
                iState = 4
            Else
                iState = 3
            End If
        Case 2
            If iType <> Numero Then
                iState = 3
            Else
                sOperando = cSym
                iState = 1
            End If
        End Select
    Loop While iState <= 2

    If iState = 3 Then
        dblResultado = 0
        Exit Sub
    End If

' Pasada por colTerms para resolver los operadores MULTIPLICATIVOS (1 nivel):
    i = 1
    Do While i < q
        DoEvents
        cSym = colTerms(i)
        sOperando = xtractOperando(cSym)
        sOperador = xtractOperador(cSym)
        cSym = colTerms(i + 1)
        sOperandoX = xtractOperando(cSym)
        sOperadorX = xtractOperador(cSym)
        If sOperador = "*" Or sOperador = "/" Or sOperador = "%" Or sOperador = "+%" Or sOperador = "-%" Then
            dblTemp1 = Val(sOperando)
            dblTemp2 = Val(sOperandoX)
            Select Case sOperador
            Case "*"
                dblTemp1 = dblTemp1 * dblTemp2
            Case "/"
                If Abs(dblTemp2) > 0.0001 Then
                    dblTemp1 = dblTemp1 / dblTemp2
                Else
                    dblTemp1 = 0
                End If
            Case "%"
                dblTemp1 = dblTemp1 * dblTemp2 / 100#
            Case "+%"
                dblTemp1 = dblTemp1 * (1# + dblTemp2 / 100#)
            Case "-%"
                dblTemp1 = dblTemp1 * (1# - dblTemp2 / 100#)
            End Select
            ' eliminar el termino procesado
            sOperando = Trim(Str(dblTemp1)) & " " & sOperadorX
            colTerms(i) = sOperando
            q = q - 1
            For r = i + 1 To q
                colTerms(r) = colTerms(r + 1)
            Next
        Else
            i = i + 1
        End If
    Loop

' Pasada por colTerms para resolver los operadores ADITIVOS (2 nivel):
    i = 1
    Do While i < q
        DoEvents
        cSym = colTerms(i)
        sOperando = xtractOperando(cSym)
        sOperador = xtractOperador(cSym)
        cSym = colTerms(i + 1)
        sOperandoX = xtractOperando(cSym)
        sOperadorX = xtractOperador(cSym)
        If sOperador = "+" Or sOperador = "-" Then
            dblTemp1 = Val(sOperando)
            dblTemp2 = Val(sOperandoX)
            Select Case sOperador
            Case "+"
                dblTemp1 = dblTemp1 + dblTemp2
            Case "-"
                dblTemp1 = dblTemp1 - dblTemp2
            End Select
            ' eliminar el termino procesado
            sOperando = Trim(Str(dblTemp1)) & " " & sOperadorX
            colTerms(i) = sOperando
            q = q - 1
            For r = i + 1 To q
                colTerms(r) = colTerms(r + 1)
            Next
        Else
            i = i + 1
        End If
    Loop

' Pasada por colTerms para resolver los operadores RELACIONALES (3 nivel):
    i = 1
    Do While i < q
        DoEvents
        cSym = colTerms(i)
        sOperando = xtractOperando(cSym)
        sOperador = xtractOperador(cSym)
        cSym = colTerms(i + 1)
        sOperandoX = xtractOperando(cSym)
        sOperadorX = xtractOperador(cSym)
        If sOperador = ">" Or sOperador = "<" Or sOperador = "=" Or sOperador = "<=" Or sOperador = ">=" Or sOperador = "<>" Then
            dblTemp1 = Val(sOperando)
            dblTemp2 = Val(sOperandoX)
            Select Case sOperador
            Case "<"
                dblTemp1 = dblTemp1 < dblTemp2
            Case ">"
                dblTemp1 = dblTemp1 > dblTemp2
            Case "="
                dblTemp1 = (dblTemp1 = dblTemp2)
            Case ">="
                dblTemp1 = (dblTemp1 >= dblTemp2)
            Case "<="
                dblTemp1 = (dblTemp1 <= dblTemp2)
            Case "<>"
                dblTemp1 = (dblTemp1 <> dblTemp2)
            End Select
            ' eliminar el termino procesado
            If (dblTemp1 <> 0) Then dblTemp1 = 1#
            sOperando = Trim(Str(dblTemp1)) & " " & sOperadorX
            colTerms(i) = sOperando
            q = q - 1
            For r = i + 1 To q
                colTerms(r) = colTerms(r + 1)
            Next
        Else
            i = i + 1
        End If
    Loop

' Pasada por colTerms para resolver los operadores LOGICOS (3 nivel):
    i = 1
    Do While i < q
        DoEvents
        cSym = colTerms(i)
        sOperando = xtractOperando(cSym)
        sOperador = xtractOperador(cSym)
        cSym = colTerms(i + 1)
        sOperandoX = xtractOperando(cSym)
        sOperadorX = xtractOperador(cSym)
        If sOperador = "&" Or sOperador = "^" Or sOperador = "|" Then
            dblTemp1 = Val(sOperando)
            dblTemp2 = Val(sOperandoX)
            Select Case sOperador
            Case "|"
                dblTemp1 = (dblTemp1 <> 0) Or (dblTemp2 <> 0)
            Case "&"
                dblTemp1 = (dblTemp1 <> 0) And (dblTemp2 <> 0)
            Case "^"
                dblTemp1 = (dblTemp1 <> 0) Xor (dblTemp2 <> 0)
            End Select
            ' eliminar el termino procesado
            If (dblTemp1 <> 0) Then dblTemp1 = 1#
            sOperando = Trim(Str(dblTemp1)) & " " & sOperadorX
            colTerms(i) = sOperando
            q = q - 1
            For r = i + 1 To q
                colTerms(r) = colTerms(r + 1)
            Next
        Else
            i = i + 1
        End If
    Loop

    sOperando = xtractOperando(colTerms(1))
    sOperador = xtractOperador(colTerms(1))
    
    If (sOperador <> "EOXP") Then
        iState = 3
        dblResultado = 0
        Exit Sub
    End If

    dblResultado = Val(sOperando)
End Sub
