VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsTextFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_FileName As String
Private m_FileHandle As Integer
Private m_PushBuffHead As Integer
Private m_PushBuffTail As Integer
Private m_PushBuff(0 To 99) As Byte
Private m_BuffArray() As Byte
Private m_BuffLevel As Long
Private m_BuffSize As Long

Public Sub SetFileName(arg As String)
    If m_FileHandle <> 0 Then
        ReportarError False, 1, "El archivo " & m_FileName & "ser cerrado antes de abrir " & arg, "clsTextFile.SetFileName"
        Close m_FileHandle
    End If
    m_BuffSize = FileLen(arg)
    If m_BuffSize = 0 Then
        ReportarError False, 1, "El archivo " & arg & " no parece existir.", "clsTextFile.SetFileName"
        Exit Sub
    End If
    
    m_FileName = arg
    m_FileHandle = FreeFile
    On Error GoTo ErrHandler
    Open arg For Binary Shared As #m_FileHandle
    ReDim m_BuffArray(0 To m_BuffSize - 1)
    Get #m_FileHandle, , m_BuffArray
    Close #m_FileHandle
    m_BuffLevel = 0
ResumePoint:
    Exit Sub
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTextFile.SetFileName"
    Err.Clear
    m_FileHandle = 0
    m_FileName = ""
    On Error GoTo 0
    Resume ResumePoint
End Sub

Private Function GetPushChar() As Integer
Dim iRetVal As Integer
    If m_PushBuffHead = m_PushBuffTail Then
        GetPushChar = -1
        Exit Function
    End If
    iRetVal = m_PushBuff(m_PushBuffHead)
    m_PushBuffHead = m_PushBuffHead + 1
    If m_PushBuffHead = m_PushBuffTail Then
        m_PushBuffHead = 0
        m_PushBuffTail = 0
    End If
    
    GetPushChar = iRetVal
End Function

Public Sub PushBack(iArg As Integer)
    m_PushBuff(m_PushBuffTail) = iArg
    m_PushBuffTail = m_PushBuffTail + 1
End Sub

Public Function NextByte() As Integer
Dim iRetVal As Integer, bByte As Byte
    iRetVal = GetPushChar
    If iRetVal = -1 Then
        If m_BuffLevel < m_BuffSize Then
            bByte = m_BuffArray(m_BuffLevel)
            m_BuffLevel = m_BuffLevel + 1
            iRetVal = bByte
        Else
            iRetVal = -1
        End If
    End If
    NextByte = iRetVal
End Function

Public Sub Rewind()
    m_BuffLevel = 0
End Sub

Public Function Cerrar()
    m_FileHandle = 0
    m_FileName = ""
    m_PushBuffHead = 0
    m_PushBuffTail = 0
    m_BuffLevel = 0
    m_BuffSize = 0
    ReDim m_BuffArray(0)
End Function

Private Sub Class_Initialize()
    m_FileHandle = 0
    m_FileName = ""
    m_PushBuffHead = 0
    m_PushBuffTail = 0
End Sub

Private Sub Class_Terminate()
    Cerrar
End Sub

Public Function NextLine() As String
Dim stBuff As String, nNextChar As Integer

    stBuff = ""
    Do
        nNextChar = Me.NextByte
        If nNextChar = 9 Or nNextChar >= 32 Then
            stBuff = stBuff & Chr$(nNextChar)
        End If
    Loop While nNextChar = 9 Or nNextChar >= 32

    If nNextChar >= 0 Then
    Do
        nNextChar = Me.NextByte
    Loop While nNextChar >= 0 And nNextChar < 32
    End If
    If nNextChar >= 0 Then PushBack nNextChar

    NextLine = stBuff
End Function

Public Function EOF() As Boolean
Dim nNext As Integer

    nNext = Me.NextByte
    If nNext < 0 Then
        EOF = True
        Exit Function
    End If
    PushBack nNext
    EOF = False

End Function
