VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsTablasCodigo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public NombrePlural As String
Public NombreSingular As String
Public Contenido As Collection

Private TableName As String

Public Function Add( _
    Codigo As String, _
    Descripcion As String) As clsTablaCodigos
Dim sqlQuery As String, objNewMember As clsTablaCodigos, i As Integer
    
    On Error GoTo ErrHandler
    sqlQuery = "INSERT INTO " & TableName & "(Codigo, Descripcion) VALUES ('" & Codigo & "', '" & Descripcion & "')"
    dbHandle.Execute sqlQuery, dbFailOnError
    'create a new object
    Set objNewMember = New clsTablaCodigos

    With objNewMember
        .Codigo = Codigo
        .Descripcion = Descripcion
    End With

    'set the properties passed into the method
    
    i = 1
    Do While i <= Contenido.Count
        If Contenido.Item(i).Codigo < Codigo Then
            i = i + 1
        Else
            Exit Do
        End If
    Loop
    
    If i <= Contenido.Count Then
        Contenido.Add objNewMember, Codigo, i
    Else
        Contenido.Add objNewMember, Codigo
    End If
    'return the object created
ResumePoint:
    Set Add = objNewMember
    Set objNewMember = Nothing
    Exit Function
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "TablasCodigo.Add"
    Set objNewMember = Nothing
    Err.Clear
    Resume ResumePoint
End Function

Public Property Get Item(vntIndexKey As Variant) As clsTablaCodigos
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
Dim RetVal As clsTablaCodigos
    On Error GoTo NoHay
    Set RetVal = Contenido.Item(vntIndexKey)
    Set Item = RetVal
    Exit Property
NoHay:
    Set RetVal = Nothing
    Resume Next
End Property

Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = Contenido.Count
End Property

Public Function Remove(vntIndexKey As String) As Boolean
    'used when removing an element from the acollection
    'vntIndexKey contains either the Index or Key, which is why
    'it is declared as a Variant
    'Syntax: x.Remove(xyz)
Dim inst As clsTablaCodigos, sqlQuery As String, isOk As Boolean
    
    Set inst = Item(vntIndexKey)
    If inst Is Nothing Then
        Remove = False
        Exit Function
    End If

    isOk = True
    On Error GoTo ErrorHandler
    sqlQuery = "DELETE * FROM " & TableName & " WHERE Codigo = '" & vntIndexKey & "'"
    dbHandle.Execute sqlQuery, dbFailOnError

    Contenido.Remove vntIndexKey
ResumePoint:
    Remove = isOk
    Exit Function
ErrorHandler:
    ReportarError False, Err.Number, Err.Description, "TablasCodigo.Remove"
    isOk = False
    Resume ResumePoint
End Function

Public Sub Update(Codigo As String, _
    Descripcion As String)
Dim inst As clsTablaCodigos, sqlQuery As String
    
    Set inst = Item(Codigo)
    If inst Is Nothing Then
        mAdvertencia "Error (consistencia) item " & Codigo & " no aparece en 'Almacenes.Update'"
    Else
        inst.Descripcion = Descripcion
    End If
    
    On Error GoTo ErrHandler
    sqlQuery = "UPDATE " & TableName & " SET Descripcion = '" & Descripcion & "' WHERE Codigo = '" & Codigo & "'"
    dbHandle.Execute sqlQuery, dbFailOnError
    Exit Sub
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "TablasCOdigo.Update"
    Resume Next
End Sub

Public Sub SetTableName(stTableName As String, stNombrePlural As String, stNombreSingular As String)
Dim rsHandle As Recordset, inst As clsTablaCodigos
    
    On Error GoTo ErrHandler

    TableName = stTableName
    NombreSingular = stNombreSingular
    NombrePlural = stNombrePlural
    Set Contenido = New Collection
    Set rsHandle = dbHandle.OpenRecordset("SELECT * FROM " & TableName & " ORDER BY Codigo;", dbOpenDynaset)
    With rsHandle
    If Not .BOF Then
        .MoveFirst
        Do While Not .EOF
            Set inst = New clsTablaCodigos
            inst.Codigo = .Fields("Codigo")
            inst.Descripcion = .Fields("Descripcion")
            Contenido.Add inst, inst.Codigo
            .MoveNext
        Loop
    End If
    .Close
    End With
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTablasCodigo::SetTableName"
    Err.Clear

End Sub

Private Sub Class_Terminate()
    Set Contenido = Nothing
End Sub

Public Sub FillCombo(cbx As ComboBox)
Dim inst As clsTablaCodigos, orgText As String
    orgText = cbx.Text
    cbx.Clear
    cbx.Text = orgText
    cbx.SelStart = 0
    cbx.SelLength = Len(cbx.Text)

    For Each inst In Contenido
        cbx.AddItem inst.Descripcion & "(" & inst.Codigo & ")"
    Next
End Sub

Public Function Validar(stCodigo As String) As Boolean
Dim inst As clsTablaCodigos, _
    f As lfMapaCodigo

    If stCodigo = "" Then
        Validar = True
        Exit Function
    End If

    Set inst = Item(stCodigo)
    If inst Is Nothing Then
        If Not Confirmar("Crear " & Me.NombreSingular & " " & stCodigo) Then
            Validar = False
            Exit Function
        End If
        Set f = New lfMapaCodigo
        f.SetParentForm Nothing
        f.SetVars stCodigo, ""
        f.Caption = Me.NombrePlural & ": Creacin"
        f.Show vbModal
        If f.Result Then
            Me.Add f.txCodigo.Text, f.txDescripcion.Text
            Validar = True
        Else
            Validar = False
        End If
        Unload f
    Else
        Validar = True
        Set inst = Nothing
    End If
End Function

' Accesores...
Public Function Nombre(stCodigo As String) As String
Dim inst As clsTablaCodigos
    Set inst = Item(stCodigo)
    If inst Is Nothing Then
        Nombre = "INVALIDA"
    Else
        Nombre = inst.Descripcion
        Set inst = Nothing
    End If
End Function

