VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cSerialPort"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Implements iDevice
Private mComm As Object
Private portNumber As Integer

Private Sub Class_Terminate()

    If Not mComm Is Nothing Then
        mComm.PortOpen = False
        Set mComm = Nothing
    End If

End Sub

Public Function iDevice_SetDeviceName(sDevName As String) As Boolean

    On Error GoTo ErrHandler
    portNumber = Val(Mid(sDevName, 4, 1))
    Set mComm = CreateObject("MSCOMMLib.MSComm")
    mComm.CommPort = portNumber
    mComm.PortOpen = True
    iDevice_SetDeviceName = True
    Exit Function

ErrHandler:

    If Not mComm Is Nothing Then
        mComm.PortOpen = False
        Set mComm = Nothing
    End If
    
    Err.Clear
    iDevice_SetDeviceName = False

End Function

Public Function iDevice_Send(sText As String) As Boolean

    mComm.Output = sText

End Function

Public Function iDevice_GetInput() As String

    iDevice_GetInput = mComm.Input
    
End Function

Public Sub iDevice_Settings(s As String)
    mComm.PortOpen = False
    mComm.Settings = s
    mComm.PortOpen = True
End Sub

Public Function iDevice_ControlFlags(i As Long) As Long
Dim l As Integer, org As Long

    org = mComm.Handshaking
    l = i And 3 ' Get Handshaking
    mComm.Handshaking = l

' Get/Set RTS
    If (mComm.RTSEnable) Then
        org = org + 4
    End If
    If i And 4 Then
        mComm.RTSEnable = True
    Else
        mComm.RTSEnable = False
    End If

' Get/Set DTR
    If mComm.DTREnable Then
        org = org + 8
    End If
    If i And 8 Then
        mComm.DTREnable = True
    Else
        mComm.DTREnable = False
    End If

' Get DSR/CTS/CD
    If mComm.DSRHolding Then org = org + 16
    If mComm.CTSHolding Then org = org + 32
    If mComm.CDHolding Then org = org + 64

    iDevice_ControlFlags = org

End Function
