VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CUnits"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Unidad As String
Public Equivalencia As String
Public Factor As Double

Private Equivalencias As Collection
Private Visited() As String

Private Function Strip(s As String) As String
Dim st As String
  
  st = Trim(UCase(s))
  If (Right(st, 1) = ".") Then st = Left(st, Len(st) - 1)
  Strip = st

End Function

Public Function Convertir(istrUnidad As String, istrDestino As String, Optional ByVal idblValue As Double = 1, Optional ByVal onlyInternalUse As Boolean = False) As Double
Dim pUnit As CUnits, dblTemp As Double, i As Integer

  If Not onlyInternalUse Then
    ReDim Visited(0)
  End If

  If Strip(istrUnidad) = Strip(istrDestino) Then
    Convertir = 1
    Exit Function
  End If

  If Strip(istrUnidad) = "" Or Strip(istrDestino) = "" Then
    Convertir = 1
    Exit Function
  End If

  For i = 1 To UBound(Visited)
    If Visited(i) = Strip(istrUnidad) & "/" & Strip(istrDestino) Then
      Convertir = 0
      Exit Function
    End If
  Next
  
  ReDim Preserve Visited(UBound(Visited) + 1)
  Visited(UBound(Visited)) = Strip(istrUnidad) & "/" & Strip(istrDestino)
  
  Debug.Print istrUnidad, istrDestino

  For Each pUnit In Equivalencias
    If pUnit.Unidad = Strip(istrUnidad) And pUnit.Equivalencia = Strip(istrDestino) Then
      Convertir = idblValue * pUnit.Factor  ' No hay ms que una
      Debug.Print idblValue * pUnit.Factor
      ReDim Preserve Visited(UBound(Visited) - 1)
      Exit Function
    End If
  Next
  
  For Each pUnit In Equivalencias
    If pUnit.Unidad = Strip(istrUnidad) Then
      dblTemp = Convertir(pUnit.Equivalencia, Strip(istrDestino), idblValue, True)
      If dblTemp <> 0 Then
        Convertir = dblTemp * pUnit.Factor
        ReDim Preserve Visited(UBound(Visited) - 1)
        Exit Function
      End If
    End If
  Next

  ReDim Preserve Visited(UBound(Visited) - 1)
  Convertir = 0

End Function

Private Sub Class_Initialize()
  Set Equivalencias = New Collection
End Sub

Public Sub AddEquivalencia(istrTipo1 As String, istrTipo2 As String, idblFactor As Double)
Dim p As CUnits

  For Each p In Equivalencias
    If p.Unidad = istrTipo1 And p.Equivalencia = istrTipo2 Then
      Exit Sub
    End If
  Next
  
  Set p = New CUnits
  p.Unidad = Strip(istrTipo1)
  p.Equivalencia = Strip(istrTipo2)
  p.Factor = idblFactor
  Equivalencias.Add p
  
  Set p = New CUnits
  p.Unidad = Strip(istrTipo2)
  p.Equivalencia = Strip(istrTipo1)
  p.Factor = 1 / idblFactor
  Equivalencias.Add p

End Sub

'Public Sub Dump()
'Dim p As CUnits
'  For Each p In Equivalencias
'    Debug.Print p.Unidad, p.Equivalencia, p.Factor
'  Next
'  Debug.Print "----------------------------------------"
'End Sub

Public Function IsValid(sUnit As String) As Boolean
Dim p As CUnits, lsUnit As String

  lsUnit = Strip(sUnit)
  For Each p In Equivalencias
    If p.Unidad = lsUnit Or p.Equivalencia = lsUnit Then
      IsValid = True
      Exit Function
    End If
  Next
  
  IsValid = False

End Function
