VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CStringBuffer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const Increment As Long = 65536
Private StringBuffer As String
Private StringLen As Long
Private BufferLength As Long

'---------------------------------------------------------------------------------------
' Procedure : CheckSize
' DateTime  : 24/02/2005 16:31
' Author    : Leonardo Azpurua
' Purpose   : Determina si es necesario expandir el bloque para alojar la nueva
'             cadena
'---------------------------------------------------------------------------------------
'
Private Sub CheckSize(Length As Long)
Dim reqLen As Long

  reqLen = StringLen + Length
  If reqLen > BufferLength Then
    StringBuffer = StringBuffer & String(Increment, Chr(0))
    BufferLength = BufferLength + Increment
  End If

End Sub

'---------------------------------------------------------------------------------------
' Procedure : Class_Terminate
' DateTime  : 24/02/2005 16:32
' Author    : Leonardo Azpurua
' Purpose   : Limpia el string, para evitar el desperdicio de espacio
'---------------------------------------------------------------------------------------
'
Private Sub Class_Terminate()
  StringBuffer = ""
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Class_Initialize
' DateTime  : 24/02/2005 16:32
' Author    : Leonardo Azpurua
' Purpose   : Inicia el nuevo bloque
'---------------------------------------------------------------------------------------
'
Private Sub Class_Initialize()
  StringBuffer = String(Increment, Chr(0))
  BufferLength = Increment
  StringLen = 0
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Append
' DateTime  : 24/02/2005 16:32
' Author    : Leonardo Azpurua
' Purpose   : Aade el argumento al final del string (equivale a b = b & s
'---------------------------------------------------------------------------------------
'
Public Sub Append(s As String)
  Dim Length As Long
  Length = Len(s)
  CheckSize Length
  Mid(StringBuffer, StringLen + 1, Length) = s
  StringLen = StringLen + Length
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Remove
' DateTime  : 24/02/2005 16:33
' Author    : Leonardo Azpurua
' Purpose   : Elimina <Length> caracteres a partir de la <index>-ima posicion
'---------------------------------------------------------------------------------------
'
Public Sub Remove(index As Long, Length As Long)
Dim s As String
  If index + Length >= StringLen Then
    Length = StringLen + 1 - index
    Mid(StringBuffer, index, Length) = String(Length, Chr(0))
    StringLen = index - 1
  Else
    Mid(StringBuffer, index, StringLen - index + Length) = Mid(StringBuffer, index + Length, StringLen - index + Length)
    Mid(StringBuffer, StringLen - Length + 1, Length) = String(Length, Chr(0))
    StringLen = StringLen - Length
  End If
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Insert
' DateTime  : 24/02/2005 16:34
' Author    : Leonardo Azpurua
' Purpose   : Inserta <Text> a la izquierda del <index>-imo caracter
'---------------------------------------------------------------------------------------
'
Public Sub Insert(index As Long, Text As String)
Dim Length As Long
  If index > StringLen + 1 Then
    Err.Raise 5
  End If
  Length = Len(Text)
  If Length = StringLen Then
    Append Text
    Exit Sub
  End If
  CheckSize Length
  Mid(StringBuffer, index + Length, StringLen - index + 1) = Mid(StringBuffer, index, StringLen - index + 1)
  Mid(StringBuffer, index, Length) = Text
  StringLen = StringLen + Length
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Replace
' DateTime  : 24/02/2005 16:34
' Author    : Leonardo Azpurua
' Purpose   : Equivalente de la funcion Replace (se basa en ella)
'---------------------------------------------------------------------------------------
'
Public Sub Replace(orgText As String, NewText As String)
  StringBuffer = VBA.Replace(StringBuffer, orgText, NewText)
  BufferLength = Len(StringBuffer)
  StringLen = InStr(StringBuffer, Chr(0)) - 1
  If StringLen = 0 Then StringLen = BufferLength
End Sub

'---------------------------------------------------------------------------------------
' Procedure : value
' DateTime  : 24/02/2005 16:35
' Author    : Leonardo Azpurua
' Purpose   : Devuelve el string
'---------------------------------------------------------------------------------------
'
Public Property Get value() As String
Attribute value.VB_UserMemId = 0
  value = Left(StringBuffer, StringLen)
End Property

Public Property Let value(s As String)
  Class_Initialize
  Append s
End Property
