VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "COutDev"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_DeviceName As String
Private m_Handle As iDevice
Private bIsOpen As Boolean

Public Property Let DeviceName(s As Variant)
Dim sDevName As String

    sDevName = s

    If Left(UCase(sDevName), 3) = "COM" Then
        Set m_Handle = New cSerialPort
    Else
        Set m_Handle = New cTextStream
    End If
    
    If m_Handle.SetDeviceName(sDevName) Then
        m_DeviceName = sDevName
        bIsOpen = True
    Else
        bIsOpen = False
    End If

End Property

Public Property Get DeviceName() As Variant

    If Not bIsOpen Then
        DeviceName = "<NIL>"
    Else
        DeviceName = m_DeviceName
    End If

End Property

Public Function Send(s As Variant) As Boolean
Dim sText As String
    
    sText = s
    If bIsOpen Then
        m_Handle.Send sText
    End If
    
    Send = bIsOpen

End Function

Public Sub Cerrar()

    If bIsOpen Then
        Set m_Handle = Nothing
        bIsOpen = False
    End If

End Sub

Private Sub Class_Terminate()

    Cerrar

End Sub

Public Property Let Settings(s As Variant)
Dim sSettings As String

    sSettings = s
    If bIsOpen Then
        m_Handle.Settings sSettings
    End If

End Property

Public Function GetInput() As String

    If bIsOpen Then
        GetInput = m_Handle.GetInput
    Else
        GetInput = "<NIL>"
    End If

End Function

Public Function ControlFlags(n As Variant) As Long
Attribute ControlFlags.VB_Description = "Bits 0-1: Handshaking. Bit 2:RTS, 3:DTR, 4:DSR, 5:CTS, 6:CD"
Dim i As Long
    i = n
    ControlFlags = m_Handle.ControlFlags(i)

End Function
