VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CMouseInOut"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Uso:
'  En la forma, crear una instancia de CMouseInOut
'  En el evento MouseMove de la forma, llamar a CMouseInOut.MouseOut
'  En el evento MouseMove de cada control llamar a MouseIn con los parmetros
'  adecuados.
'  Actualmente, tiene soporte para TextBox y para PictureBox (o ImageBox),
'  pero puede ampliarse para soportar otros tipos.

Dim hasMouse As Control, orgBackColor As Long, orgForeColor As Long, orgImage As IPictureDisp

Public Sub MouseOut()

    If hasMouse Is Nothing Then Exit Sub
    
    If TypeOf hasMouse Is TextBox Then
        hasMouse.BackColor = orgBackColor
        hasMouse.ForeColor = orgForeColor
    ElseIf TypeOf hasMouse Is PictureBox Then
        Set hasMouse.Picture = orgImage
        hasMouse.Refresh
    ElseIf TypeOf hasMouse Is Image Then
        hasMouse.BorderStyle = 0
    End If
    
    Set hasMouse = Nothing
    
End Sub

Public Sub MouseIn(bControl As Control, ParamArray Parametros() As Variant)
Dim t As Integer

' Impide que se ejecute MouseIn para un control que ya tiene
' el mouse
    If hasMouse Is bControl Then Exit Sub
' Si el ratn se mueve demasiado rpido, algunos eventos no son
' debidamente procesados... De manera que hizo falta la siguiente
' instruccin:
    If Not hasMouse Is Nothing Then MouseOut

    If TypeOf bControl Is TextBox Then
        orgBackColor = bControl.BackColor
        orgForeColor = bControl.ForeColor
        bControl.BackColor = Parametros(0)
        bControl.ForeColor = Parametros(1)
    ElseIf TypeOf bControl Is PictureBox Then
        Set orgImage = bControl.Picture
        Set bControl.Picture = Parametros(0)
        bControl.Refresh
    ElseIf TypeOf bControl Is Image Then
        bControl.BorderStyle = 1
    End If

    Set hasMouse = bControl

End Sub

