VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDifDate"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public _
  Anyos As Integer, _
  Meses As Integer, _
  Dias As Integer, _
  Horas As Integer, _
  Minutos As Integer, _
  Segundos As Integer

Public Sub Calcular(Inicial As Date, Final As Date)
  If Inicial > Final Then
    Err.Raise 5, "CDifTime::Calcular", "Argumentos invalidos (Inicial > Final)"
  End If

  ' Borrar cualquier uso anterior:
  Anyos = 0: Meses = 0: Dias = 0: Horas = 0: Minutos = 0: Segundos = 0

  ' Calcular de menos significativo a mas significativo, por los acarreos
  Segundos = Second(Final) - Second(Inicial)
  If Segundos < 0 Then
    Minutos = Minutos - 1
    Segundos = Segundos + 60
  End If

  Minutos = Minute(Final) - Minute(Inicial) + Minutos
  If Minutos < 0 Then
    Horas = Horas - 1
    Minutos = Minutos + 60
  End If

  Horas = Hour(Final) - Hour(Inicial) + Horas
  If Horas < 0 Then
    Dias = Dias - 1
    Horas = Horas + 24
  End If

  Dias = Day(Final) - Day(Inicial) + Dias
  If (Dias < 0) Then
    Dim ultimo As Integer
    ultimo = Day(DateSerial(Year(Inicial), Month(Inicial) + 1, 0))
    Meses = Meses - 1
    Dias = Dias + ultimo
  End If

  Meses = Month(Final) - Month(Inicial) + Meses
  If Meses < 0 Then
    Anyos = Anyos - 1
    Meses = Meses + 12
  End If

  Anyos = Year(Final) - Year(Inicial) + Anyos
End Sub

Public Function ToString() As String
  ToString = Anyos & " aos, " & Meses & " meses, " & Dias & " dias, " & _
  Horas & " horas, " & Minutos & " minutos y " & Segundos & " segundos."
End Function



