Attribute VB_Name = "lmdbHandle"
' Variables y Funciones dependientes de la base de Datos

Option Explicit

' Las funciones siguientes tienen que ver con el "acceso funcional a la base de datos"
Public Function isField(istrCandidato As String, istrTableName As String) As Boolean
Dim pFld As Field, tDef As TableDef, bRetVal As Boolean

    Set tDef = dbHandle.TableDefs(istrTableName)
    On Error GoTo NoField
    bRetVal = True
    Set pField = tDef.Fields(istrCandidato)

ResumePoint:
    Set pField = Nothing
    Set tDef = Nothing
    isField = bRetVal
    Exit Function

NoField:
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function VarDB(v As Variant) As String

    Select Case VarType(v)
    Case vbDate
        VarDB = FechaDB(CDate(v))
    Case vbString
        VarDB = StringDB(CStr(v))
    Case vbBoolean
        If v Then
            VarDB = "Yes"
        Else
            VarDB = "No"
        End If
    Case vbInteger, _
         vbLong, _
         vbSingle, _
         vbDouble, _
         vbCurrency, _
         vbDecimal, _
         vbByte
            VarDB = Trim(Str(v))
    Case Else
        VarDB = CStr(v)
    End Select

End Function

Public Function FechaDB(Fecha As Date) As String
    FechaDB = "#" & Format(Fecha, "mm-dd-yyyy") & "#"
End Function

Public Function StringDB(starg As String) As String
    StringDB = "'" & starg & "'"
End Function

Public Function StartTransaction() As Boolean
    
    On Error GoTo ErrHandler
    Workspaces(0).BeginTrans
    StartTransaction = True
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmdbHandle.StartTransaction"
    Err.Clear
    StartTransaction = False
End Function

Public Function CommitTransaction() As Boolean
    
    On Error GoTo ErrHandler
    Workspaces(0).CommitTrans
    CommitTransaction = True
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmdbHandle.CommitTransaction"
    Err.Clear
    CommitTransaction = False

End Function

Public Function AbortTransaction() As Boolean
    
    On Error GoTo ErrHandler
    Workspaces(0).Rollback
    AbortTransaction = True
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmdbHandle.CommitTransaction"
    Err.Clear
    AbortTransaction = False

End Function

