Attribute VB_Name = "lmPaperSizes"
Option Explicit
'Constante            Valor  Descripcin
'vbPRPSLetter             1  Carta 216 x 279 mm
'vbPRPSLetterSmall        2  Carta pequea, 216 x 279 mm
'vbPRPSTabloid            3  Tabloide, 279 x 432 mm
'vbPRPSLedger             4  Doble carta, 432 x 280 mm
'vbPRPSLegal              5  Oficio, 216 x 356 mm
'vbPRPSStatement          6  Estamento, 140 x 216 mm
'vbPRPSExecutive          7  Ejecutivo, 190 x 254 mm
'vbPRPSA3                 8  A3, 297 x 420 mm
'vbPRPSA4                 9  A4, 210 x 297 mm
'vbPRPSA4Small           10  A4 pequeo, 210 x 297 mm
'vbPRPSA5                11  A5, 148 x 210 mm
'vbPRPSB4                12  B4, 250 x 354 mm
'vbPRPSB5                13  B5, 182 x 257 mm
'vbPRPSFolio             14  Folio, 216 x 330 mm
'vbPRPSQuarto            15  Cuarto, 215 x 275 mm
'vbPRPS10x14             16  254 x 356 mm
'vbPRPS11x17             17  279 x 431 mm
'vbPRPSNote              18  Nota, 216 x 279 mm

Const Min = 1
Const Max = 18
Const Widths = "216,216,279,432,216,140,190,297,210,210,148,250,182,216,215,254,279,216"
Const Heights = "279,279,432,280,356,216,254,420,297,297,210,354,257,330,275,356,431,279"

' Ancho del papel en pulgadas
Function PageWidth(PaperType As Integer) As Double
Dim RetVal As Double
    If (PaperType > Max Or PaperType < Min) Then
        PageWidth = 0
        Exit Function
    End If
    RetVal = Val(Mid(Widths, (PaperType - 1) * 4 + 1, 3))
    RetVal = RetVal / 25.4
    PageWidth = RetVal
End Function

Function PageHeight(PaperType As Integer) As Double
Dim RetVal As Double
    If (PaperType > Max Or PaperType < Min) Then
        PageHeight = 0
        Exit Function
    End If
    RetVal = Val(Mid(Heights, (PaperType - 1) * 4 + 1, 3))
    RetVal = RetVal / 25.4
    PageHeight = RetVal
End Function

