Attribute VB_Name = "lmLocalizador"
Option Explicit

Private Const START_LOC As Long = 46657

' Excludas del alfabeto: IL\'O'STV para prevenir confusiones
Const Alfabeto As String = "AB0CDE1FG2HJ3K4MN5PQ6R7U8WXY9Z"

Private Function ValorSimbolo(Simbolo As String) As Long
Dim i As Integer
    i = InStr(1, Alfabeto, Simbolo, vbTextCompare)
    ValorSimbolo = i - 1
End Function

Function CodigoLocalizador(arg As Long) As String
Dim Copia As Long, chkSum1 As Long, chkSum2 As Long, RetBuff As String
Dim tmp1 As Long, temp2 As Long
    Copia = arg
    chkSum1 = 0
    Do While (Copia > 0)
        chkSum1 = chkSum1 + (Copia Mod 10)
        Copia = Copia \ 10
    Loop
    chkSum1 = chkSum1 Mod 10
    chkSum2 = 1
    Copia = arg
    Do While Copia > 0
        tmp1 = Copia Mod 10
        If (tmp1 Mod 5) Then chkSum2 = chkSum2 * tmp1
        Copia = Copia \ 10
    Loop
    chkSum2 = chkSum2 + chkSum1
    chkSum2 = chkSum2 Mod 7
        
    Copia = arg
    RetBuff = ""
    Do While Copia
        tmp1 = Copia Mod 30
        tmp1 = tmp1 + chkSum1 + 1
        If tmp1 >= 30 Then tmp1 = tmp1 - 30
        RetBuff = RetBuff & Mid(Alfabeto, tmp1 + 1, 1)
        Copia = Copia \ 30
    Loop
    RetBuff = RetBuff & Chr(48 + chkSum1)
    RetBuff = RetBuff & Chr(48 + chkSum2)
    CodigoLocalizador = RetBuff
End Function

Function ValorLocalizador(localizador As String) As Long
Dim Exponente As Long, Base As Long, Resultado As Long, temp As Long
Dim l As Integer, n As Integer, i As Integer
    
    If localizador = "" Then
        ValorLocalizador = 0
        Exit Function
    End If

    On Error GoTo ErrHandler

    Base = Asc(Left(Right(localizador, 2), 1)) - 48
    Exponente = 1: Resultado = 0
    l = Len(localizador) - 2
    For i = 1 To l
        temp = ValorSimbolo(Mid(localizador, i, 1))
        temp = temp - (Base + 1)
        If temp < 0 Then temp = 30 + temp
        Resultado = Resultado + temp * Exponente
        Exponente = Exponente * 30
    Next

ResumePoint:
    ValorLocalizador = Resultado
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmLocalizador.ValorLocalizador. " & "Arg=" & localizador, "VSLIB"
    Resultado = 0
    Err.Clear
    Resume ResumePoint

End Function

'Secuencia para generar listado de localizadores, de 5 en 5
'Dim l As Long
'Open "\Mis Documentos\Tarjetas.txt" For Output As #1
'For l = 50001 To 50499 Step 5
'Print #1, CodigoLocalizador(l), CodigoLocalizador(l + 1), CodigoLocalizador(l + 2), CodigoLocalizador(l + 3), CodigoLocalizador(l + 4)
'Next
'Close #1

