Attribute VB_Name = "lmFechas"
Public Function BuildFecha(dia As Integer, Mes As Integer, Anho As Integer) As Date
Dim d As Date
Dim lAnho As Integer, lMes As Integer, lDia As Integer

    lAnho = Anho: lDia = dia: lMes = Mes
    On Error GoTo Invalid
    
    If (lMes > 12) Then
        lAnho = lAnho + (lMes - 1) \ 12
        lMes = lMes Mod 12
        If lMes = 0 Then lMes = 12
    End If
    
    If lDia = 0 Or lDia > DiasMes(lMes, lAnho) Then
        lDia = DiasMes(lMes, lAnho)
    End If
    
    d = DateSerial(lAnho, lMes, lDia)
    BuildFecha = d
    Exit Function

Invalid:
    d = Date
    Resume Next

End Function

Public Function ValidarFecha(arg As String) As Boolean
Dim dtFecha As Date, bRetVal As Boolean
    On Error GoTo MalaFecha
    bRetVal = True
    dtFecha = CDate(arg)
    ValidarFecha = bRetVal
    Exit Function
MalaFecha:
    If Err.Number = 13 Then
        mAdvertencia "Fecha invlida", "VSLIB"
        bRetVal = False
        Resume Next
    End If
    On Error GoTo 0
    Resume
End Function

Function NombreMes(ByVal d As Integer) As String
Dim s As String
    Select Case d
        Case 1
            s = "Enero"
        Case 2
            s = "Febrero"
        Case 3
            s = "Marzo"
        Case 4
            s = "Abril"
        Case 5
            s = "Mayo"
        Case 6
            s = "Junio"
        Case 7
            s = "Julio"
        Case 8
            s = "Agosto"
        Case 9
            s = "Septiembre"
        Case 10
            s = "Octubre"
        Case 11
            s = "Noviembre"
        Case 12
            s = "Diciembre"
        Case Else
            s = "INVALIDO"
    End Select
    NombreMes = s
End Function

Function NumeroMes(ByVal s As String) As Integer
Dim i As Integer
    i = 1
    Do While StrComp(s, NombreMes(i), vbTextCompare)
        i = i + 1
        If i > 12 Then
            NumeroMes = 0
            Exit Function
        End If
    Loop
    NumeroMes = i
End Function

Function DiasMes(ByVal Mes As Integer, ByVal Anho As Integer) As Integer
   Dim Result As Integer
   
    If Mes = 2 Then
        If (Anho Mod 4) Then
            Result = 28
        Else
            Result = 29
        End If
    Else
        If Mes = 4 Or Mes = 6 Or Mes = 9 Or Mes = 11 Then
            Result = 30
        Else
            Result = 31
        End If
    End If
    DiasMes = Result
End Function

Public Function DifAnhos(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date) As Integer
Dim nDifAnhos As Integer

    nDifAnhos = Year(dtFechaFinal) - Year(dtFechaInicial)
    If (Month(dtFechaInicial) > Month(dtFechaFinal)) Then nDifAnhos = nDifAnhos - 1
    If (Month(dtFechaInicial) = Month(dtFechaFinal) And Day(dtFechaInicial) > Day(dtFechaFinal)) Then nDifAnhos = nDifAnhos - 1
    
    DifAnhos = nDifAnhos

End Function

Public Function DifMeses(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date) As Integer
Dim nDifAnhos As Integer, nDifMeses As Integer

    nDifAnhos = DifAnhos(dtFechaInicial, dtFechaFinal) * 12
    nDifMeses = Month(dtFechaFinal) - Month(dtFechaInicial)
    If nDifMeses < 0 Then nDifMeses = 12 + nDifMeses
    If Day(dtFechaInicial) > Day(dtFechaFinal) _
    And ( _
        Day(dtFechaInicial) < DiasMes(Month(dtFechaFinal), Year(dtFechaFinal)) _
        Or Day(dtFechaFinal) < DiasMes(Month(dtFechaFinal), Year(dtFechaFinal)) _
    ) Then nDifMeses = nDifMeses - 1

    nDifMeses = nDifMeses + nDifAnhos

    DifMeses = nDifMeses

End Function

Public Function ResiduoMeses(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date) As Integer
Dim nDifAnhos As Integer, nDifMeses As Integer

    nDifAnhos = DifAnhos(dtFechaInicial, dtFechaFinal) * 12
    nDifMeses = DifMeses(dtFechaInicial, dtFechaFinal)
    
    ResiduoMeses = nDifMeses - nDifAnhos

End Function

Public Function ResiduoDiasAnho(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date) As Integer
Dim nDifAnhos As Integer

    nDifAnhos = DifAnhos(dtFechaInicial, dtFechaFinal)
    dtFechaFinal = DateSerial(Year(dtFechaFinal) - nDifAnhos, Month(dtFechaFinal), IIf(Day(dtFechaFinal) > DiasMes(Month(dtFechaFinal), Year(dtFechaFinal) - nDifAnhos), DiasMes(Month(dtFechaFinal), Year(dtFechaFinal) - nDifAnhos), Day(dtFechaFinal)))
    nDifAnhos = dtFechaFinal - dtFechaInicial
    
    ResiduoDiasAnho = nDifAnhos

End Function

Public Function ResiduoDiasMeses(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date) As Integer
Dim nDifAnhos As Integer

    nDifAnhos = DifAnhos(dtFechaInicial, dtFechaFinal)
    dtFechaFinal = DateSerial(Year(dtFechaFinal) - nDifAnhos, Month(dtFechaFinal), IIf(Day(dtFechaFinal) > DiasMes(Month(dtFechaFinal), Year(dtFechaFinal) - nDifAnhos), DiasMes(Month(dtFechaFinal), Year(dtFechaFinal) - nDifAnhos), Day(dtFechaFinal)))
    nDifAnhos = DifMeses(dtFechaInicial, dtFechaFinal)
    dtFechaFinal = DateSerial(Year(dtFechaFinal), Month(dtFechaFinal) - nDifAnhos, IIf(Day(dtFechaFinal) > DiasMes(Month(dtFechaFinal) - nDifAnhos, Year(dtFechaFinal)), DiasMes(Month(dtFechaFinal) - nDifAnhos, Year(dtFechaFinal)), Day(dtFechaFinal)))
    nDifAnhos = dtFechaFinal - dtFechaInicial
    
    ResiduoDiasMeses = nDifAnhos
    
End Function
