VERSION 5.00
Begin VB.UserControl ucComboMapaCodigo 
   ClientHeight    =   315
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   1635
   ScaleHeight     =   315
   ScaleWidth      =   1635
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   1635
   End
End
Attribute VB_Name = "ucComboMapaCodigo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Event KeyDown(KeyCode As Integer, Shift As Integer)
Event RequestCreation(obIsProcessed As Boolean, istrCodigo As String, ostrDescripcion)
Event Change()
' Permite a la forma cliente crear una instancia de MapaCodigo segun un procedimiento particular
' Si la forma Crea un nuevo elemento, coloca obIsProcessed en True, y devuelve la descripcin en ostrDescripcion.
' Si la forma Procesa el mensaje, pero NO crea un nuevo elemento, setea obIsProcessed a True y devuelve una descripcion
' en blanco

Dim m_ParentForm As Form
Dim m_Tabla As clsTablasCodigo
Private pComboWidth As clsComboWidth

Public OrgSize As Long
Public Validando As Boolean

Private Sub Combo1_Change()

    If Len(Combo1.Text) > 24 Then
        Combo1.Text = left(Combo1.Text, 24)
        Combo1.SelStart = 24
    End If
    RaiseEvent Change

End Sub

Public Sub SetTabla(Tabla As clsTablasCodigo)
    
    Set m_Tabla = Tabla

End Sub

Private Sub Combo1_GotFocus()

    If m_Tabla Is Nothing Then
        mAdvertencia "ERROR: Tabla no definida"
    Else
        m_Tabla.FillCombo Combo1
    End If

End Sub

Private Sub Combo1_KeyDown(KeyCode As Integer, Shift As Integer)
    
    RaiseEvent KeyDown(KeyCode, Shift)

End Sub

Public Function Codigo() As String
    
    Codigo = Format(Trim(sExtractRightCode(Text)), ">")

End Function

Private Sub Combo1_LostFocus()
Dim stCopia As String
Dim bIsProcessed As Boolean, strDescripcion As String ' Para permitir que la App defina los datos relevantes
    
    On Error GoTo NoParentForm
    If Not ParentForm.Enabled Then Exit Sub
    If Not ParentForm.Visible Then Exit Sub
    If ParentForm.ActiveControl.Name = "cbCancelar" Then Exit Sub
NoParentForm:
    If Not Me.Enabled Then Exit Sub
    If Combo1.Text = "" Then Exit Sub
    If Validando Then Exit Sub

    Validando = True
    stCopia = Format(Trim(sExtractRightCode(Combo1.Text)), ">")
    Combo1.Text = stCopia
    
    If Not ParentForm Is Nothing Then
        If ParentForm.ActiveControl.Name = "cbCancelar" Then
            Validando = False
            Exit Sub
        End If
    End If

NoParentForm2:
    If Not m_Tabla.Item(stCopia) Is Nothing Then
        Validando = False
        Exit Sub        ' El elemento existe
    Else
            
        Combo1.SetFocus
        bIsProcessed = False
        strDescripcion = ""
        RaiseEvent RequestCreation(bIsProcessed, stCopia, strDescripcion)
        If bIsProcessed Then
            If strDescripcion <> "" Then
                m_Tabla.AddContenido stCopia, strDescripcion
            Else
                Combo1.SetFocus
            End If
            Validando = False
            Exit Sub
        End If
    End If
    
    m_Tabla.Validar stCopia
    
    On Error Resume Next
    If m_Tabla.Item(stCopia) Is Nothing Then Combo1.SetFocus

    Validando = False

End Sub

Public Property Let Text(s As String)
    
    Combo1.Text = s

End Property

Public Property Get Text() As String
    
    Text = Combo1.Text

End Property

Public Property Get Enabled() As Boolean
    
    Enabled = Combo1.Enabled

End Property

Public Property Let Enabled(v As Boolean)
    
    Combo1.Enabled = v

End Property

Public Property Get SelStart() As Integer
    
    SelStart = Combo1.SelStart

End Property

Public Property Let SelStart(arg As Integer)
    
    Combo1.SelStart = arg

End Property

Public Property Get SelLength() As Integer
    
    SelLength = Combo1.SelLength

End Property

Public Property Let SelLength(arg As Integer)
    
    Combo1.SelLength = arg

End Property

Public Property Get ParentForm() As Form
    
    Set ParentForm = m_ParentForm

End Property

Public Property Set ParentForm(ByVal fParentForm As Form)
    
    Set m_ParentForm = fParentForm

End Property

Private Sub UserControl_Initialize()
  Set pComboWidth = New clsComboWidth
  Set pComboWidth.ComboBox = Combo1
End Sub

Private Sub UserControl_Resize()
    
'    UserControl.Height = 315
'    Combo1.Height = 315
    Combo1.Width = UserControl.Width

End Sub

Private Sub UserControl_Show()
    If Not m_Tabla Is Nothing Then m_Tabla.FillCombo Combo1
End Sub
