Attribute VB_Name = "mVariablesRecibo"
Option Explicit

Public Sub SaveVariableRecibo(nNumProceso As Long, istrVarID As String, istrCodTrab As String, iVal)
Dim rs As Recordset

  Set rs = dbHandle.OpenRecordset("nomDetallesRecibo", dbOpenTable)
  rs.AddNew
  rs.Fields("NumeroProceso") = nNumProceso
  rs.Fields("codigoTrabajador") = istrCodTrab
  rs.Fields("varID") = istrVarID
  rs.Fields("varType") = varType(iVal)
  rs.Fields("Value") = CStr(iVal)
  On Error Resume Next
  rs.Update
  rs.Close
  Set rs = Nothing
  
End Sub

Public Function ReadVariableRecibo(nNumProceso As Long, istrVarID As String, istrCodTrab As String) As Variant
Dim rs As Recordset, sQuery As String
Dim v

  sQuery = "SELECT varType, Value FROM nomDetallesRecibo "
  sQuery = sQuery & "WHERE numeroProceso = " & NumeroDB(nNumProceso) & " "
  sQuery = sQuery & "AND varID = " & StringDB(UCase(Trim(istrVarID))) & " "
  sQuery = sQuery & "AND codigoTrabajador = " & StringDB(istrCodTrab) & ";"
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If Not rs.EOF Then
    v = Convert(rs.Fields("varType").Value, rs.Fields("Value").Value)
  End If
  ReadVariableRecibo = v

End Function

Private Function Convert(varType As VbVarType, v) As Variant
Dim vRetVal

  Select Case varType
  Case vbEmpty, vbNull, vbArray, vbVariant, vbDataObject, vbObject, vbArray
    vRetVal = v
  Case vbInteger
    vRetVal = CInt(v)
  Case vbLong
    vRetVal = CLng(v)
  Case vbSingle
    vRetVal = CSng(v)
  Case vbDouble
    vRetVal = CDbl(v)
  Case vbCurrency
    vRetVal = CCur(v)
  Case vbDate
    vRetVal = CDate(v)
  Case vbString
    vRetVal = CStr(v)
  Case vbBoolean
    vRetVal = CBool(v)
  Case vbDecimal
    vRetVal = CDec(v)
  Case vbByte
    vRetVal = CByte(v)
  End Select

  Convert = vRetVal
End Function
