Attribute VB_Name = "lmUsuarios"
Type Usuario
    Codigo  As String
    Clave   As Long
    Nivel   As Byte
    Nombre  As String
    Perfil As String
End Type

Private qAperturas As Integer
Public rsHandle As Recordset
Public cUsuario As Usuario, UsuarioActivo As Usuario

Sub AbrirUsuarios()
    If qAperturas Then
        qAperturas = qAperturas + 1
        Exit Sub
    End If
    Set rsHandle = dbHandle.OpenRecordset("Usuarios", dbOpenTable)
    rsHandle.Index = "PrimaryKey"
    qAperturas = 1
End Sub

Sub CerrarUsuarios()
Dim i As Integer
    If qAperturas = 0 Then Exit Sub
    qAperturas = qAperturas - 1
    If qAperturas > 0 Then Exit Sub
    rsHandle.Close
End Sub

Public Function RegistrarUsuario(ByVal Codigo As String, ByVal Clave As String, ByVal Nivel As Byte, ByVal Nombre As String, ByVal Perfil As String) As Boolean
    Dim s As String

    If Len(Codigo) < 4 Or Len(Clave) < 4 Then
        mAdvertencia "Los codigos y claves de usuario deben tener al menos cuatro caracteres"
        RegistrarUsuario = False
        Exit Function
    End If

    AbrirUsuarios
    With rsHandle
    .AddNew
    .Fields("Codigo") = Codigo
    .Fields("Clave") = CalcActKey(Clave)
    .Fields("Nivel") = Nivel
    .Fields("Nombre") = Nombre
    On Error Resume Next
    .Fields("Perfil") = Perfil
    .Update
    End With
    CerrarUsuarios
    
    RegistrarUsuario = True
End Function

Public Function ActualizarDescriptivosUsuario(ByVal Codigo As String, ByVal Nombre As String, ByVal Nivel As Byte, Perfil As String) As Boolean
Dim bRetVal As Boolean
    AbrirUsuarios
    With rsHandle
    .Seek "=", Codigo
    If Not .NoMatch Then ' Es decir, si NO NO lo encuentra ...
        .Edit
        .Fields("Nivel") = Nivel
        .Fields("Nombre") = Nombre
        On Error Resume Next
        .Fields("Perfil") = Perfil
        
        .Update
        bRetVal = True
    Else
        bRetVal = False
    End If
    End With
    CerrarUsuarios
    ActualizarDescriptivosUsuario = bRetVal
End Function

Public Function LeerUsuario(Codigo As String) As Boolean
Dim found As Boolean

    AbrirUsuarios
    With rsHandle
        .Seek "=", Codigo
        found = Not .NoMatch
        If found Then
            cUsuario.Codigo = stGetStringFromVariant(.Fields("Codigo"))
            cUsuario.Clave = .Fields("Clave")
            cUsuario.Nivel = .Fields("Nivel")
            cUsuario.Nombre = stGetStringFromVariant(.Fields("Nombre"))
            On Error Resume Next
            cUsuario.Perfil = .Fields("Perfil")
            If Err.Number <> 0 Then
                Err.Clear
                cUsuario.Perfil = "SUPER"
            End If
        End If
    End With
    CerrarUsuarios

    LeerUsuario = found
End Function

Public Function ActualizarClaveUsuario(ByVal Codigo As String, ByVal Clave As String) As Boolean
Dim bRetVal As Boolean
    bRetVal = False
    AbrirUsuarios
    With rsHandle
    .Seek "=", Codigo
    If Not .NoMatch Then
        .Edit
        .Fields("Clave") = CalcActKey(Clave)
        .Update
        bRetVal = True
    End If
    End With
    CerrarUsuarios
    ActualizarClaveUsuario = bRetVal
End Function

Public Function ExisteUsuario(Codigo As String) As Boolean
Dim found As Boolean
    AbrirUsuarios
    With rsHandle
        .Seek "=", Codigo
        found = Not .NoMatch
    End With
    CerrarUsuarios
    ExisteUsuario = found
End Function

Public Function VerificarUsuario(stArgCaption As String) As Integer
Dim f As New LFGetUser, etVal As Integer
Dim tmpUsuario As Usuario

    f.Caption = stArgCaption
    f.Show 1
    If f.txCodigo = "" Then
        RetVal = 0
    Else
        tmpUsuario = cUsuario
        If Not LeerUsuario(f.txCodigo.Text) Then
            RetVal = 0
        Else
            RetVal = cUsuario.Nivel
        End If
        cUsuario = tmpUsuario
    End If
    Unload f
    Set f = Nothing
    
    VerificarUsuario = RetVal
End Function

Public Function ClaveEspecial() As Long

    ClaveEspecial = 110954

End Function

Public Function ValidarClaveUsuario(Codigo As String, Clave As String) As Boolean
    
    Codigo = Format(Codigo, ">")
    Clave = Format(Clave, ">")
    If Not LeerUsuario(Codigo) Then
        ValidarClaveUsuario = False
        Exit Function
    End If

    If Val(Clave) = ClaveEspecial Then
        ValidarClaveUsuario = True
        Exit Function
    End If

    If CalcActKey(Clave) <> cUsuario.Clave Then
        ValidarClaveUsuario = False
    Else
        ValidarClaveUsuario = True
    End If

End Function

Public Sub EliminarUsuario(Codigo As String)
    AbrirUsuarios
    With rsHandle
    .Seek "=", Codigo
    If Not .NoMatch Then .Delete
    End With
    CerrarUsuarios
End Sub

Public Function EstaAutorizado(sCodigo As String, pOperacion As PermisosUsuario) As Boolean
Dim rs As Recordset, sPerfil As String, nPermiso As Integer

    EstaAutorizado = True
    Exit Function

    On Error Resume Next
    Set rs = dbHandle.OpenRecordset("SELECT Perfil FROM Usuarios WHERE Codigo = " & StringDB(sCodigo), dbOpenForwardOnly)
    If Err.Number <> 0 Then
        Err.Clear
        EstaAutorizado = True
        Exit Function
    End If
    
    On Error GoTo 0

    sPerfil = stGetStringFromVariant(rs.Fields("Perfil"))
    If sPerfil = "" Then
        sPerfil = "SUPER"
    End If

    Set rs = Nothing
    
    If sPerfil = "SUPER" Then
        EstaAutorizado = True
        Exit Function
    End If

    Set rs = dbHandle.OpenRecordset("SELECT COUNT(Permiso) AS TienePermiso FROM perfilesPermisos WHERE CodigoPerfil = " & StringDB(sPerfil) & " AND Permiso = " & NumeroDB(pOperacion), dbOpenForwardOnly)
    nPermiso = rs.Fields("TienePermiso")
    Set rs = Nothing
    
    If nPermiso = 0 Then
        mAdvertencia "Acceso no autorizado... Lo siento"
    End If

    EstaAutorizado = (nPermiso <> 0)

End Function
