Attribute VB_Name = "mSQLFromCriterios"
Option Explicit

' Slo para ser usada en clsTrabajadores.

Public Function SQLFromCriterios(icolCriterios As Collection) As String
' iCol contiene una coleccin de elementos de la clase Filtro, ordenados por
' Codigo del Atributo, y los valores inicial y final del rango de seleccion
Dim strResult As String, strCurrentSegment As String, strCurrentAttrib As String
Dim bSegmentOverriden As Boolean, pFiltro As clsFiltro, varVariantD As Variant, varVariantH As Variant
Dim strCurrentCondition As String
Dim bIsField As Boolean ' para no estar llamando a IsField a cada rato
Dim bIsFirst As Boolean

    strResult = "SELECT T.* FROM nomTrabajadores T "
    
    strCurrentSegment = "": strCurrentAttrib = "": strCurrentCondition = ""
    bIsFirst = True

    For Each pFiltro In icolCriterios

        If Right(strResult, 6) <> " WHERE" Then
            strResult = strResult & " WHERE"
        End If
    
        If pFiltro.Atributo <> strCurrentAttrib Then
            
            If strCurrentSegment <> "" Then
                If Not bIsFirst Then strResult = strResult & " AND "
                strResult = strResult & "(" & strCurrentSegment & ")"
                bIsFirst = False
            End If
            
            strCurrentAttrib = pFiltro.Atributo
            strCurrentSegment = ""
            bSegmentOverriden = False

            bIsField = lmDAOFields.isField(strCurrentAttrib, "nomTrabajadores")
        End If
        
        If Not bSegmentOverriden Then   ' Si bSegmentOverriden lo que hay que hacer es ignorar otras definiciones sobre el mismo Atributo
        
            If bIsField Then            ' Si se trata de un campo, entonces

                varVariantD = Convert2Type(pFiltro.ValorDesde, DAOType2VBType(lmDAOFields.fldType(pFiltro.Atributo, "nomTrabajadores")))
                varVariantH = Convert2Type(pFiltro.ValorHasta, DAOType2VBType(lmDAOFields.fldType(pFiltro.Atributo, "nomTrabajadores")))
                
                If varVariantD = FieldNullValue(pFiltro.Atributo, "nomTrabajadores") Then
                ' Desde contiene un valor nulo
                    If varVariantH = FieldNullValue(pFiltro.Atributo, "nomTrabajadores") Then
                    ' Hasta tambien
                        bSegmentOverriden = True
                        strCurrentSegment = ""          ' Se ignora cualquier resultado previo acumulado
                        varVariantD = FieldNullValue(pFiltro.Atributo, "nomTrabajadores")
                        strCurrentCondition = "T." & pFiltro.Atributo & " <> " & VarDB(varVariantD)
                    
                    Else
                    ' Hasta No contiene un valor nulo, luego se requieren los menores que "Hasta"
                        strCurrentCondition = "T." & pFiltro.Atributo & " < " & VarDB(varVariantH)    ' Se especifico solo valor hasta
                    End If
                
                Else ' Desde no contiene un valor nulo
                
                    If varVariantH = FieldNullValue(pFiltro.Atributo, "nomTrabajadores") Then
                    ' Pero Hasta s, entonces se requieren los Mayores que Desde
                        strCurrentCondition = "T." & pFiltro.Atributo & " > " & VarDB(varVariantD)    ' Se especifico solo valor desde
                        
                    Else
                    ' Se especificaron ambos, entoces se quiere un "BETWEEN"
                        strCurrentCondition = "T." & pFiltro.Atributo & " BETWEEN " & VarDB(varVariantD) & " AND " & VarDB(varVariantH)
                        
                    End If
                    
                End If  ' Lista una condicion
    
            Else    ' Si no es un campo, entonces es un atributo del trabajador... los atributos son NUMERICOS (siempre), y siempre se leen con Val() y se generan con Trim(Str())

                varVariantD = Val(pFiltro.ValorDesde)
                varVariantH = Val(pFiltro.ValorHasta)
                strCurrentCondition = "T.Codigo IN (Select Codigo FROM nomAttribTrabajador A WHERE A.CodTrab = T.Codigo AND A.CodAttrib = " & StringDB(strCurrentAttrib)
                
                If varVariantD = 0 Then
                ' Desde contiene CERO
                    If varVariantH = 0 Then
                    ' Hasta tambien
                        bSegmentOverriden = True
                        strCurrentSegment = ""          ' Se ignora cualquier resultado previo acumulado, y no se especifica ningun criterio adicional a la EXISTENCIA del atributo
                    Else
                    ' Hasta No contiene un valor nulo, luego se requieren los menores que "Hasta"
                        strCurrentCondition = strCurrentCondition & " AND A.ValAttrib < " & VarDB(varVariantH)
                    End If
                Else
                ' Desde contiene != 0
                    If varVariantH = 0 Then
                    ' Solo se quieren los mayores que...
                        strCurrentCondition = strCurrentCondition & " AND A.ValAttrib > " & VarDB(varVariantD)
                    Else
                    ' H <> 0 y D <> 0, es decir, se requiere un BETWEEN
                        strCurrentCondition = strCurrentCondition & " AND A.ValAttrib BETWEEN " & VarDB(varVariantD) & " AND " & VarDB(varVariantH)
                    End If
                End If

                strCurrentCondition = strCurrentCondition & ")"

            End If

            If strCurrentSegment <> "" Then
                If Left(strCurrentSegment, 1) <> "(" Then   ' Cada condicin va separada encerrada entre parntesis
                    strCurrentSegment = "(" & strCurrentSegment & ")"
                End If
                strCurrentSegment = strCurrentSegment & " OR (" & strCurrentCondition & ")"
            Else
                strCurrentSegment = strCurrentCondition
            End If

        End If
            
    Next

    If strCurrentSegment <> "" Then
        If Not bIsFirst Then strResult = strResult & " AND "
        strResult = strResult & " (" & strCurrentSegment & ")"
    End If

    SQLFromCriterios = strResult

End Function

