Attribute VB_Name = "mMain"
Option Explicit

Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public Empresa As clsParametrosEmpresa

Public Tarjetas As clsTarjetas

Public ptClasificacionesLaborales As clsTablasCodigo
Public ptCodigosReporte As clsTablasCodigo
Public ptCodigosRecibo As clsTablasCodigo
Public ptDepartamentos As clsTablasCodigo
Public ptCargos As clsTablasCodigo
Public ptExcepciones As clsTablasCodigo
Public ptAtributos As clsTablasCodigo
Public ptTiposObservacion As clsTablasCodigo

Public AlmacenCuentas As clsAlmacenCuentas
Public AlmacenPrefijos As clsAlmacenPrefijos
Public AlmacenComprobantes As clsAlmacenComprobantes
Public AlmacenDetalles As clsAlmacenDetalles
Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenContactos As clsAlmacenContactos
Public AlmacenBancos As clsAlmacenBancos
Public AlmacenDetallesEntidad As clsAlmacenDetallesEntidad
Public AlmacenSaldosEntidad As clsAlmacenSaldosEntidad
Public AlmacenDocumentosISPC As clsAlmacenDocumentosISPC
Public AlmacenVencimientosISPC As clsAlmacenVencISPC
Public AlmacenIndicadores As clsAlmacenIndicadores

Public Condiciones As clsCondiciones
Public Contadores As CContadores

Public pGlobalScript As Object
Public pFactoria As CFactoria

Public Sesiones As clsSesionesPOS
Public SesionActiva As clsSesionPOS
Public Serial As Long

Public pScanner As CLectorHuellas

Public Const TAD_ASIGNACION = 0
Public Const TAD_DEDUCCION = 1
Public Const TAD_APORTE = 2
Public pScriptPOS As Object

Public Sub ResetGlobalScript()
Dim nFileHandle As Integer, sFileName As String, sInString As String, sScriptText As String
    
    On Error Resume Next
    pGlobalScript.Reset
    On Error GoTo 0
    pGlobalScript.Language = "VBScript"
    If mScriptExecute.LoadScriptFile("Global.vbs", pGlobalScript, True) Then
      If pFactoria Is Nothing Then Set pFactoria = New CFactoria
      pGlobalScript.AddObject "Factoria", pFactoria
    End If

End Sub

Private Sub InstanciarAlmacenes()
Dim pTrabajador As clsTrabajador
Dim tmpObject As Object

  Set Contadores = New CContadores
  Set Empresa = New clsParametrosEmpresa
  Set Sesiones = New clsSesionesPOS

  Set Tarjetas = New clsTarjetas
  Set AlmacenCuentas = New clsAlmacenCuentas
  Set AlmacenPrefijos = New clsAlmacenPrefijos
  Set AlmacenComprobantes = New clsAlmacenComprobantes
  Set AlmacenDetalles = New clsAlmacenDetalles
  Set AlmacenSaldos = New clsAlmacenSaldos
  Set AlmacenContactos = New clsAlmacenContactos
  Set AlmacenBancos = New clsAlmacenBancos
  Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
  Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
  Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
  Set AlmacenVencimientosISPC = New clsAlmacenVencISPC

  Set Condiciones = New clsCondiciones

  Set ptClasificacionesLaborales = New clsTablasCodigo
  ptClasificacionesLaborales.SetTableName "nomCategoriasLaborales", "Clasificaciones laborales", "Clasificacin laboral"
  Set ptCodigosReporte = New clsTablasCodigo
  ptCodigosReporte.SetTableName "nomCodigosReporte", "Cdigos de agrupacin para reportes", "Cdigo de agrupacin para reportes"
  Set ptCodigosRecibo = New clsTablasCodigo
  ptCodigosRecibo.SetTableName "nomCodigosRecibo", "Cdigos de agrupacin para los recibos", "Cdigo de agrupacin para los recibos"
  Set ptDepartamentos = New clsTablasCodigo
  ptDepartamentos.SetTableName "nomDepartamentos", "Departamentos", "Departamento"
  Set ptCargos = New clsTablasCodigo
  ptCargos.SetTableName "nomDescCargos", "Cargos", "Cargo"
  Set ptExcepciones = New clsTablasCodigo
  ptExcepciones.SetTableName "nomTiposExcepcion", "Excepcin", "Excepciones"
  Set ptExcepciones.pCreator = New CDefinirExcepcion
  Set ptAtributos = New clsTablasCodigo
  ptAtributos.AllowRefresh = False
  ptAtributos.SetTableName "nomTiposAtributo", "Atributos", "Atributo"
  Set pTrabajador = New clsTrabajador
  pTrabajador.AgregarContenidoAtibutos ptAtributos
  Set pTrabajador = Nothing

  Set ptTiposObservacion = New clsTablasCodigo
  ptTiposObservacion.SetTableName "nomTiposObservacion", "Tipos de Observacion", "Tipo de Observacion"
  Set pGlobalScript = CreateObject("ScriptControl")
  ResetGlobalScript

End Sub

Private Sub DestruirAlmacenes()

  If Not pGlobalScript Is Nothing Then pGlobalScript.Reset
  Set pGlobalScript = Nothing
  
  Set Contadores = Nothing
  Set ptAtributos = Nothing
  Set ptExcepciones = Nothing
  Set ptCargos = Nothing
  Set ptDepartamentos = Nothing
  Set ptCodigosRecibo = Nothing
  Set ptCodigosReporte = Nothing
  Set ptClasificacionesLaborales = Nothing

  Set Condiciones = Nothing

  Set AlmacenVencimientosISPC = Nothing
  Set AlmacenDocumentosISPC = Nothing
  Set AlmacenDetallesEntidad = Nothing
  Set AlmacenSaldosEntidad = Nothing
  Set AlmacenBancos = Nothing
  Set AlmacenContactos = Nothing
  Set AlmacenSaldos = Nothing
  Set AlmacenDetalles = Nothing
  Set AlmacenComprobantes = New clsAlmacenComprobantes
  Set AlmacenPrefijos = Nothing
  Set AlmacenCuentas = Nothing
  Set Tarjetas = Nothing

  Set Sesiones = Nothing
  Set Empresa = Nothing
  Set pGlobalScript = Nothing

End Sub

Private Function VerificarDirectorioDatos() As Boolean
Dim stTemp As String, orgCancelError As Boolean
    
    stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    If stTemp = "UNDEF" Then
        mainForm.CommonDialog1.InitDir = "\"
    Else
        mainForm.CommonDialog1.InitDir = stTemp
    End If

    mainForm.CommonDialog1.DialogTitle = "ClearLight: Seleccione el archivo deseado"
    mainForm.CommonDialog1.FileName = "bo01.mdb"
    mainForm.CommonDialog1.flags = cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist ' Or cdlOFNExplorer
    mainForm.CommonDialog1.Filter = "Bases de Datos de Clear Nomina|bo01.mdb"
    orgCancelError = mainForm.CommonDialog1.CancelError
    mainForm.CommonDialog1.CancelError = True
    
    On Error GoTo ErrHandler
    mainForm.CommonDialog1.ShowOpen
    
    mainForm.CommonDialog1.CancelError = orgCancelError
    stTemp = left(mainForm.CommonDialog1.FileName, Len(mainForm.CommonDialog1.FileName) - Len(mainForm.CommonDialog1.FileTitle))
    
    SaveSetting AppName:=AppName, Section:="General", Key:="DataDir", Setting:=stTemp

    VerificarDirectorioDatos = True
    
    Exit Function

ErrHandler:
    If Err.Number = cdlCancel Then
        Err.Clear
        VerificarDirectorioDatos = False
        mainForm.CommonDialog1.CancelError = False
        Exit Function
    End If

    ReportarError True, Err.Number, Err.Description, "mMain::VerificarDirectorioDatos"
    End

End Function

Public Sub PrepararEntorno()
Dim fLogin As LFGetUser, lrefPeriodo As Long

    DestruirAlmacenes
CheckDataDir:
    If Not VerificarDirectorioDatos Then
        If mainForm.Visible Then mainForm.Hide
        End
    End If

    On Error GoTo ErrHandler
    Set dbHandle = Workspaces(0).OpenDatabase(BuildDataPath("bo01.mdb", AppName))

    Set fLogin = New LFGetUser
    
    fLogin.Show 1
    UsuarioActivo.Codigo = fLogin.txCodigo.Text
    If UsuarioActivo.Codigo = "" Then
        dbHandle.Close
        End
    End If
    Unload fLogin
    Set fLogin = Nothing
    lmUsuarios.LeerUsuario UsuarioActivo.Codigo
    UsuarioActivo = lmUsuarios.cUsuario

    InstanciarAlmacenes

    Set SesionActiva = New clsSesionPOS
    Set Sesiones = New clsSesionesPOS

    If Not SesionActiva.IniciarSesion(UsuarioActivo.Codigo) Then
        dbHandle.Close
        End
    End If

    lrefPeriodo = Empresa.AnhoMes2Periodo(Year(Date), Month(Date))
    If (Empresa.PeriodoCurso < lrefPeriodo) Then
        If Empresa.UsaContabilidad Then
            If VerificarUsuario("Abrir nuevo periodo contable") < 5 Then
                End
            End If
            Empresa.ActualizarUltimoPeriodo lrefPeriodo
        End If
    End If

    Exit Sub

ErrHandler:
    If Err.Number = 3024 Then
        mAdvertencia "ERROR: No puedo localizar la Base de Datos" & Chr(13) & _
                     "en la ubicacin especificada... Por favor, intentelo de nuevo" & Chr(13) & _
                     "(" & BuildDataPath("bo01.mdb", AppName) & ")"
        SaveSetting AppName, "General", "DataDir", "UNDEF"
        Resume CheckDataDir
    Else
        On Error GoTo 0
        Resume
    End If
End Sub

Public Sub Main()

    VSLIB.AppName = "ClearLight"

    CheckKey AppName
    Serial = VSLIB.Serial(GetSetting(AppName, "General", "Serial", "INVALIDA"))
    Splash.Show vbModal
    Unload Splash
    Set pFactoria = New CFactoria
    PrepararEntorno
    
    On Error Resume Next
    Set pScanner = New CLectorHuellas
    If Err.Number <> 0 Then
      Set pScanner = Nothing
    Else
      pScanner.dbName = GetSetting("VSL", "VFINGER", "dbPathName")
    End If
    
    mainForm.Caption = "Clear Nomina, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
    ShowNonModal mainForm
    
    Unload mainForm
    Set mainForm = Nothing
    Set pScanner = Nothing
    
    DestruirAlmacenes
    Set pFactoria = Nothing
    

End Sub
