VERSION 5.00
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#1.1#0"; "ucDate.ocx"
Begin VB.Form frmComprobantes 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Comprobantes"
   ClientHeight    =   6720
   ClientLeft      =   1185
   ClientTop       =   1305
   ClientWidth     =   10710
   ControlBox      =   0   'False
   HelpContextID   =   28
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   6720
   ScaleWidth      =   10710
   Begin SimplexW.ucECC ucECC1 
      Height          =   2985
      Left            =   60
      TabIndex        =   17
      Top             =   2310
      Width           =   10665
      _ExtentX        =   18812
      _ExtentY        =   5265
   End
   Begin ucDate.ucDateBox txFecha 
      Height          =   315
      Left            =   960
      TabIndex        =   1
      Top             =   120
      Width           =   1485
      _ExtentX        =   2619
      _ExtentY        =   556
      Fecha           =   36609
   End
   Begin VB.TextBox txNumeroCorrelativo 
      Height          =   315
      Left            =   2430
      TabIndex        =   8
      Text            =   "0000"
      Top             =   1200
      Width           =   465
   End
   Begin VB.Frame Frame2 
      Height          =   735
      Left            =   60
      TabIndex        =   23
      Top             =   5280
      Width           =   5325
      Begin VB.Label lblDescCuenta 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   90
         TabIndex        =   24
         Top             =   210
         Width           =   5175
         WordWrap        =   -1  'True
      End
   End
   Begin VB.CommandButton cbCerrar 
      Cancel          =   -1  'True
      Caption         =   "Cerrar"
      Height          =   615
      Left            =   9030
      TabIndex        =   20
      Top             =   5370
      Width           =   1635
   End
   Begin VB.CommandButton cbCancelar 
      Caption         =   "&Borrar"
      Height          =   615
      Left            =   7290
      TabIndex        =   19
      Top             =   5370
      Width           =   1635
   End
   Begin VB.CommandButton cbProcesar 
      Caption         =   "Procesar (O&k)"
      Height          =   615
      Left            =   5580
      TabIndex        =   18
      Top             =   5370
      Width           =   1635
   End
   Begin VB.Frame Frame1 
      Height          =   675
      Left            =   60
      TabIndex        =   21
      Top             =   6000
      Width           =   10605
      Begin VB.Label lblEstatus 
         Alignment       =   2  'Center
         Height          =   405
         Left            =   120
         TabIndex        =   22
         Top             =   210
         Width           =   10365
      End
   End
   Begin VB.TextBox txBalance 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   7680
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   1890
      Width           =   1665
   End
   Begin VB.TextBox txCreditos 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   4290
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   1890
      Width           =   1665
   End
   Begin VB.TextBox txDebitos 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   900
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   1890
      Width           =   1665
   End
   Begin VB.TextBox txDescripcion 
      Height          =   315
      Left            =   1320
      MaxLength       =   50
      TabIndex        =   5
      Top             =   570
      Width           =   6225
   End
   Begin VB.TextBox txReferencia 
      Height          =   315
      Left            =   3840
      MaxLength       =   20
      TabIndex        =   3
      Top             =   120
      Width           =   1905
   End
   Begin VB.TextBox txOperador 
      Enabled         =   0   'False
      Height          =   315
      Left            =   4440
      TabIndex        =   10
      TabStop         =   0   'False
      Top             =   1200
      Width           =   1485
   End
   Begin VB.TextBox txCorrelativo 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1770
      TabIndex        =   7
      Text            =   "000000"
      Top             =   1200
      Width           =   645
   End
   Begin VB.Label Label9 
      AutoSize        =   -1  'True
      Caption         =   "Balance:"
      Height          =   195
      Left            =   6780
      TabIndex        =   15
      Top             =   1920
      Width           =   630
   End
   Begin VB.Line Line2 
      BorderColor     =   &H8000000C&
      X1              =   0
      X2              =   10725
      Y1              =   1050
      Y2              =   1050
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000005&
      X1              =   0
      X2              =   10725
      Y1              =   1020
      Y2              =   1020
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Crditos:"
      Height          =   195
      Left            =   3450
      TabIndex        =   13
      Top             =   1920
      Width           =   615
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Dbitos:"
      Height          =   195
      Left            =   120
      TabIndex        =   11
      Top             =   1950
      Width           =   585
   End
   Begin VB.Line Line4 
      BorderColor     =   &H8000000C&
      X1              =   0
      X2              =   10725
      Y1              =   1710
      Y2              =   1710
   End
   Begin VB.Line Line3 
      BorderColor     =   &H80000005&
      X1              =   0
      X2              =   10725
      Y1              =   1680
      Y2              =   1680
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcin:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   885
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "&Referencia:"
      Height          =   195
      Left            =   2670
      TabIndex        =   2
      Top             =   150
      Width           =   825
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Operador:"
      Height          =   195
      Left            =   3450
      TabIndex        =   9
      Top             =   1230
      Width           =   705
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Fecha:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   495
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Comprobante &No.:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   1230
      Width           =   1290
   End
End
Attribute VB_Name = "frmComprobantes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


' Esta forma es la responsable de permitir la transcripcin o modificacin de un asiento.
' Se ocupa de todo el proceso del asiento transcrito.

Const _
    ColCodigo = 0, _
    ColDescripcion = 1, _
    ColDebe = 2, _
    ColHaber = 3

Option Explicit

Private instComprobante As clsComprobante
Private Modo As Integer ' 0: Nuevo, 1: Modificado
Private isNumCorrChanged As Boolean

Sub SetModo(ByVal newModo As Integer)
    Modo = newModo
End Sub

Sub SetComprobante(orgInst As clsComprobante)
Dim col As Collection, instDetalle As clsDetalles
    Set instComprobante = Nothing
    Set instComprobante = orgInst
    SetModo 1
    Set col = New Collection

    AlmacenDetalles.FillDetallesComprobante instComprobante.NumeroComprobante, col

    For Each instDetalle In col
        ucECC1.AddDetalle instDetalle.Cuenta, instDetalle.Descripcion, instDetalle.Debe, instDetalle.Haber
    Next

    Me.txDescripcion.Text = orgInst.Descripcion
    Me.txReferencia.Text = orgInst.Referencia
    Me.txCorrelativo.Text = Format(orgInst.periodo, "000000")
    Me.txNumeroCorrelativo.Text = Format(orgInst.CorrelativoPeriodo, "0000")
    txNumeroCorrelativo.Enabled = False
    Me.txFecha.Text = Format(orgInst.Fecha, "dd/mm/yyyy")
    Me.Show 0
End Sub

Private Sub UpdateDisplay()
Dim lrefPeriodo As Long, i As Integer
Dim tDeb, tCred As Double

    If Modo = 0 Then
        lrefPeriodo = Empresa.Fecha2RefPeriodo(CVDate(txFecha.Text))
        txCorrelativo.Text = Format(lrefPeriodo, "000000")
        If Not isNumCorrChanged Then txNumeroCorrelativo.Text = Format(instComprobante.ProximoNumeroPeriodo(lrefPeriodo), "0000")
    End If

    tDeb = ucECC1.Debitos
    tCred = ucECC1.Creditos
    txDebitos.Text = Format(tDeb, Empresa.FormatoSaldos)
    txCreditos.Text = Format(tCred, Empresa.FormatoSaldos)
    tDeb = tDeb - tCred
    txBalance.Text = Format(tDeb, Empresa.FormatoSaldos)

End Sub

Private Sub Reinit()
    BlankControls Me
    Me.txFecha.Fecha = Date
    ucECC1.Reinit
    If Me.Visible Then txFecha.SetFocus
End Sub

Private Sub cbCancelar_Click()
    
    cbCancelar.SetFocus
    If Modo = 1 Then
        If Confirmar("Cancelar la edicin del comprobante") Then
            Me.Hide
        End If
        Exit Sub
    End If
    
    If ucECC1.isData Then
        If Not Confirmar("Quiere BORRAR el comprobante en elaboracin") Then
            Exit Sub
        End If
        Reinit
    End If

End Sub

Private Sub cbCerrar_Click()
    If ucECC1.isData Then
        If Not Confirmar("Est seguro de que desa cerrar" & Chr(13) & "(tiene detalles...)") Then Exit Sub
    End If
    Me.Hide
End Sub

Private Sub cbProcesar_Click()
Dim tD, tC As Double
Dim f As lfProgresoOperacion
Dim i As Integer, p As Integer
Dim isOk As Boolean, pDetalle As clsDetalles

    tD = ucECC1.Debitos
    tC = ucECC1.Creditos
    
    If Not ucECC1.Validar Then
        ucECC1.SetFocus
        Exit Sub
    End If
    
    If (tD < 0.01) And (tC < 0.01) Then
        mAdvertencia "No ha definido montos... Imposible registrar el comprobante"
        ucECC1.SetFocus
        Exit Sub
    End If
' Proceso...
    Select Case Modo
        Case 0
            With instComprobante
            .NumeroComprobante = 0
            .Fecha = CDate(txFecha.Text)
            .Autor = UsuarioActivo.Codigo
            .Debitos = 0#
            .Creditos = 0#
            .Referencia = txReferencia.Text
            .Descripcion = txDescripcion.Text
            .periodo = Empresa.Fecha2RefPeriodo(.Fecha)
            .CorrelativoPeriodo = Val(Me.txNumeroCorrelativo)
            Set f = New lfProgresoOperacion
            f.SetMax ucECC1.Grid.Rows - 1
            If isNumCorrChanged Then
                .Insertar PeriodoPeriodo(.periodo), AnhoPeriodo(.periodo), .CorrelativoPeriodo
            End If
            isOk = .StartProcess
            If isOk Then
                For Each pDetalle In ucECC1.Detalles
                    f.NextPoint
                    isOk = .AddDetalle(pDetalle.Cuenta, _
                                pDetalle.Descripcion, _
                                "", _
                                pDetalle.Debe, _
                                pDetalle.Haber)
                    If Not isOk Then Exit For
                Next
            End If
            
            f.Hide
            Unload f
            Set f = Nothing
            
            Reinit
            
            If (isOk) Then
                .EndProcess True
            Else
                .AbortProcess
            End If
            End With
        Case 1
            With instComprobante
            .Debitos = 0#
            .Creditos = 0#
            .Autor = UsuarioActivo.Codigo
            .Referencia = txReferencia.Text
            .Descripcion = txDescripcion.Text
            .Fecha = CDate(txFecha.Text)
            .Debitos = 0#
            .Creditos = 0#
            .periodo = Empresa.Fecha2RefPeriodo(.Fecha)
            .CorrelativoPeriodo = Val(Me.txNumeroCorrelativo)
            Set f = New lfProgresoOperacion
            f.SetMax ucECC1.Grid.Rows - 1
            isOk = .StartProcess
            .Reverse False
            
            If isOk Then
                For Each pDetalle In ucECC1.Detalles
                    f.NextPoint
                    isOk = .AddDetalle(pDetalle.Cuenta, _
                                pDetalle.Descripcion, _
                                "", _
                                pDetalle.Debe, _
                                pDetalle.Haber)
                    If Not isOk Then Exit For
                Next
            End If
            
            f.Hide
            Unload f
            Set f = Nothing
            
            Reinit
            
            If (isOk) Then
                .EndProcess True
            Else
                .AbortProcess
            End If
            Me.Hide
            End With
    End Select
End Sub

Private Sub Form_Initialize()

    txFecha.Text = Format(BuildFecha(1, Empresa.MesActual, Empresa.AnhoCalendarioActual), "dd-mm-yyyy")
    Set instComprobante = New clsComprobante

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()
    Centrar Me
    Me.Top = Me.Top - Me.Height / 8

    ucECC1.SetParentForm Me

End Sub

Private Sub txDescripcion_GotFocus()

    lblEstatus.Caption = "Escriba una descripcin para la transcripcin del comprobante (ser registrado en el perodo correspondiente)"
    txDescripcion.SelStart = 0
    txDescripcion.SelLength = Len(txDescripcion.Text)

End Sub

Private Sub txFecha_GotFocus()
    
    lblEstatus.Caption = "Escriba la fecha de transcripcin del comprobante (ser registrado en el perodo correspondiente)"
    txFecha.SelStart = 0
    txFecha.SelLength = Len(txFecha.Text)

End Sub

Private Sub txFecha_LostFocus()
Dim dt As Date, lrefPeriodo As Long, newRefPeriodo As String

    If Not Me.Visible Then Exit Sub
    If Me.ActiveControl.Name = "cbCerrar" Then Exit Sub
    
    If Not mainForm.ActiveForm Is Me Then
        Exit Sub
    End If

    dt = txFecha.Fecha
    If Modo = 1 Then
        lrefPeriodo = ValOf(txCorrelativo.Text)
        If Empresa.MesPeriodo(lrefPeriodo) <> Month(dt) Or Empresa.AnhoCalendarioFromPeriodo(lrefPeriodo) <> Year(dt) Then
            mAdvertencia "ERROR: El comprobante debe pertenecer al mes " & str(Empresa.MesPeriodo(lrefPeriodo)) & " de" & str(Empresa.AnhoCalendarioFromPeriodo(lrefPeriodo))
            txFecha.SetFocus
            Exit Sub
        End If
        Exit Sub
    End If
    
    lrefPeriodo = Empresa.Fecha2RefPeriodo(dt)
    If (lrefPeriodo > Empresa.refPeriodoActual) Then
        mAdvertencia "Fecha posterior al perodo en proceso..."
        txFecha.SetFocus
        Exit Sub
    End If
    newRefPeriodo = Format(lrefPeriodo, "000000")
    If newRefPeriodo <> txCorrelativo.Text Then
        txCorrelativo.Text = newRefPeriodo
        isNumCorrChanged = False
    End If
    If Not isNumCorrChanged Then Me.txNumeroCorrelativo.Text = Format(instComprobante.ProximoNumeroPeriodo(lrefPeriodo), "0000")

End Sub

Private Sub txNumeroCorrelativo_GotFocus()
    Me.lblEstatus.Caption = "Puede asignar un nmero correlativo al comprobante"
    HighLight txNumeroCorrelativo
End Sub

Private Sub txNumeroCorrelativo_KeyPress(KeyAscii As Integer)
    If Chr(KeyAscii) >= "0" And Chr(KeyAscii) <= "9" Then isNumCorrChanged = True
End Sub

'Private Sub txRefDetalle_LostFocus()
'    GEditor.ControlLost
'End Sub

Private Sub txReferencia_GotFocus()
    lblEstatus.Caption = "Introduzca una referencia para la transaccin o comprobante consignado"
    txReferencia.SelStart = 0
    txReferencia.SelLength = Len(txReferencia.Text)
End Sub

Private Sub ucECC1_AccountSelected(stTitulo As String)
Dim Cuenta As clsCuenta
    Set Cuenta = New clsCuenta
    If Cuenta.Load(stTitulo) Then
        Me.lblDescCuenta.Caption = stTitulo & ": " & Cuenta.Titulo
    Else
        Me.lblDescCuenta.Caption = " CUENTA INVALIDA !!!"
    End If
End Sub

Private Sub ucECC1_DataChanged()
    UpdateDisplay
End Sub

Private Sub ucECC1_SetMessage(stMessage As String)
    lblEstatus.Caption = stMessage
End Sub
