VERSION 5.00
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#33.0#0"; "UCGRAPHLABEL.OCX"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#1.1#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#4.0#0"; "UCFRAMEDLABEL.OCX"
Begin VB.UserControl controlTrabajador 
   BackStyle       =   0  'Transparent
   ClientHeight    =   4020
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   6450
   EditAtDesignTime=   -1  'True
   KeyPreview      =   -1  'True
   LockControls    =   -1  'True
   ScaleHeight     =   4020
   ScaleWidth      =   6450
   ToolboxBitmap   =   "controlTrabajador.ctx":0000
   Begin SimplexW.ucComboMapaCodigo cbxCargo 
      Height          =   315
      Left            =   4410
      TabIndex        =   10
      Top             =   1350
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   556
   End
   Begin SimplexW.ucComboMapaCodigo cbxDepartamento 
      Height          =   315
      Left            =   1410
      TabIndex        =   8
      Top             =   1350
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   556
   End
   Begin prjUcFramedLabel.ucFramedLabel lblCodigo 
      Height          =   315
      Left            =   1770
      Top             =   0
      Width           =   2235
      _ExtentX        =   3942
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.CommandButton cbCancelar 
      Caption         =   "Cancelar"
      Height          =   525
      Left            =   4740
      TabIndex        =   24
      Top             =   3420
      Width           =   1635
   End
   Begin VB.CommandButton cbEliminar 
      Caption         =   "Eliminar"
      Height          =   525
      Left            =   4740
      TabIndex        =   23
      Top             =   2820
      Width           =   1635
   End
   Begin VB.CommandButton cbEditar 
      Caption         =   "Editar"
      Height          =   525
      Left            =   4740
      TabIndex        =   22
      Top             =   2220
      Width           =   1635
   End
   Begin ucGraphLabel.ucGraphicLabel cbDatosPersonales 
      Height          =   525
      Left            =   3150
      TabIndex        =   21
      Top             =   2220
      Width           =   1485
      _ExtentX        =   2619
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      Picture         =   "controlTrabajador.ctx":0312
      Caption         =   "Datos &Personales"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Frame Frame1 
      Caption         =   "Base Salarial"
      Height          =   1725
      Left            =   0
      TabIndex        =   15
      Top             =   2190
      Width           =   2835
      Begin VB.OptionButton optBaseSueldo 
         Caption         =   "Mens&ual"
         Height          =   285
         Index           =   4
         Left            =   180
         TabIndex        =   20
         Top             =   1350
         Width           =   2535
      End
      Begin VB.OptionButton optBaseSueldo 
         Caption         =   "&Quincenal"
         Height          =   285
         Index           =   3
         Left            =   180
         TabIndex        =   19
         Top             =   1080
         Width           =   2535
      End
      Begin VB.OptionButton optBaseSueldo 
         Caption         =   "Se&manal"
         Height          =   285
         Index           =   2
         Left            =   180
         TabIndex        =   18
         Top             =   810
         Width           =   2535
      End
      Begin VB.OptionButton optBaseSueldo 
         Caption         =   "&Diario"
         Height          =   285
         Index           =   1
         Left            =   180
         TabIndex        =   17
         Top             =   540
         Width           =   2535
      End
      Begin VB.OptionButton optBaseSueldo 
         Caption         =   "Desta&jo (eventual, por tarea)"
         Height          =   285
         Index           =   0
         Left            =   180
         TabIndex        =   16
         Top             =   270
         Width           =   2535
      End
   End
   Begin ucNumero.ucNumBox ucSueldo 
      Height          =   315
      Left            =   1410
      TabIndex        =   12
      Top             =   1800
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucDate.ucDateBox dtFechaAsignacion 
      Height          =   315
      Left            =   4980
      TabIndex        =   14
      Top             =   1800
      Width           =   1395
      _ExtentX        =   2461
      _ExtentY        =   556
      Fecha           =   36994
   End
   Begin ucDate.ucDateBox dtFechaIngreso 
      Height          =   315
      Left            =   1410
      TabIndex        =   6
      Top             =   900
      Width           =   1395
      _ExtentX        =   2461
      _ExtentY        =   556
      Fecha           =   36994
   End
   Begin VB.TextBox txCedula 
      Height          =   315
      Left            =   4590
      TabIndex        =   2
      Top             =   0
      Width           =   1545
   End
   Begin VB.TextBox txNombre 
      Height          =   315
      Left            =   1770
      TabIndex        =   4
      Top             =   450
      Width           =   4395
   End
   Begin VB.Image imgAnterior 
      Height          =   525
      Left            =   3600
      Picture         =   "controlTrabajador.ctx":0764
      Stretch         =   -1  'True
      Top             =   3420
      Width           =   525
   End
   Begin VB.Image imgSiguiente 
      Height          =   525
      Left            =   4110
      Picture         =   "controlTrabajador.ctx":0BA6
      Stretch         =   -1  'True
      Top             =   3420
      Width           =   525
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Sueldo &Bsico:"
      Height          =   195
      Left            =   30
      TabIndex        =   11
      Top             =   1860
      Width           =   1065
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Fecha de &Asignacin:"
      Height          =   195
      Left            =   3330
      TabIndex        =   13
      Top             =   1860
      Width           =   1545
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "&Cargo:"
      Height          =   195
      Left            =   3870
      TabIndex        =   9
      Top             =   1380
      Width           =   465
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Depar&tamento:"
      Height          =   195
      Left            =   0
      TabIndex        =   7
      Top             =   1380
      Width           =   1050
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "&Fecha de Ingreso:"
      Height          =   195
      Left            =   0
      TabIndex        =   5
      Top             =   930
      Width           =   1290
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&ID.:"
      Height          =   195
      Left            =   4200
      TabIndex        =   1
      Top             =   30
      Width           =   255
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Nombre del Trabajador:"
      Height          =   195
      Left            =   0
      TabIndex        =   3
      Top             =   480
      Width           =   1665
   End
   Begin VB.Label Label1 
      Caption         =   "Cdigo del Trabajador:"
      Height          =   285
      Left            =   0
      TabIndex        =   0
      Top             =   30
      Width           =   1635
   End
End
Attribute VB_Name = "controlTrabajador"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

Option Explicit

Public Contexto As Integer
Private mParentForm As Form
Private fPersonal As frmPersonalData

Private tablaDeptos As clsTablasCodigo
Private tablaCargos As clsTablasCodigo

Private didOpenPersonal As Boolean
Private mActive As Boolean

Public Event NextPrev()
Public Event CerrarControl()
Public Event ChangeContexto(nNewContexto As Integer)
Public Event QueryDelete(sCodigoCuenta As String, ByRef isOk As Boolean)
Public Event QueryEdit(ByRef isOk As Boolean)
Public Event ButtonDown(sButtonID As String, ByVal nContexto As Integer, ByRef isOk As Boolean)

Public Property Get CodigoTrabajador()

    CodigoTrabajador = lblCodigo.Caption

End Property


Public Property Get ParentForm() As Object

    Set ParentForm = mParentForm
    
End Property

Public Property Set ParentForm(f As Object)

    Set mParentForm = f
    Set UserControl.cbxCargo.ParentForm = f
    Set UserControl.cbxDepartamento.ParentForm = f
    
End Property

Private Function BaseSueldo() As Integer
Dim i As Integer

    For i = 0 To 4
        If UserControl.optBaseSueldo(i).Value Then
            BaseSueldo = i
            Exit Function
        End If
    Next
    
    mAdvertencia "ERROR (BaseSueldo)"
    
    BaseSueldo = -1

End Function

Private Function IndiceSexo() As Integer
Dim nRetVal As Integer

    Select Case UCase(fPersonal.cbxSexo.Text)
    Case "FEMENINO"
        nRetVal = 0
    Case "MASCULINO"
        nRetVal = 1
    Case Else
        nRetVal = -1
    End Select
    
    IndiceSexo = nRetVal

End Function

Private Function IndiceEstadoCivil() As Integer
Dim nRetVal As Integer

    Select Case UCase(fPersonal.cbxEstadoCivil.Text)
    Case "SOLTERO", "SOLTERA", "SOLTERO/A"
        nRetVal = 0
    Case "CASADO", "CASADA", "CASADO/A"
        nRetVal = 1
    Case "AMANCEBADO", "AMANCEBADA", "AMANCEBADO/A"
        nRetVal = 2
    Case "VIUDO", "VIUDA", "VIUDO/A"
        nRetVal = 3
    Case "DIVORCIADO", "DIVORCIADA", "DIVORCIADO/A"
        nRetVal = 4
    Case Else
        nRetVal = -1
    End Select
    
    IndiceEstadoCivil = nRetVal

End Function
' Siendo este un mdulo dentro de la definicin de la entidad, tiene
' "derecho" a establecer los requerimientos de validez
Private Function ValidarForma() As Boolean

    If Contexto = 3 And Not didOpenPersonal Then
        mAdvertencia "Debe llenar la forma de datos personales para nuevos trabajadores"
        fPersonal.Show vbModal
        didOpenPersonal = True
    End If

    With UserControl
    .txCedula.Text = UCase(Trim(txCedula.Text))
    If Len(.txCedula.Text) < 4 Then
        mAdvertencia "La identificacin personal debe tener al menos 4 caracteres de longitud"
        txCedula.SetFocus
        ValidarForma = False
        Exit Function
    End If
    
    .txNombre.Text = Trim(.txNombre.Text)
    If Len(.txNombre.Text) < 8 Then
        mAdvertencia "El nombre completo debe tener al menos ocho caracteres"
        .txNombre.SetFocus
        ValidarForma = False
        Exit Function
    End If

    If .ucSueldo.Value <= 0.01 Then
        mAdvertencia "Debe definir el sueldo"
        .ucSueldo.SetFocus
        ValidarForma = False
        Exit Function
    End If

    If IndiceSexo < 0 Then
        mAdvertencia "Por favor, defina el gnero del trabajador"
        fPersonal.Show vbModal
        ValidarForma = False
        Exit Function
    End If

    If IndiceSexo < 0 Then
        mAdvertencia "Por favor, defina el estado civil del trabajador"
        fPersonal.Show vbModal
        ValidarForma = False
        Exit Function
    End If

    ' Validacin del Departamento
    ' Validacin del Cargo
    ' Validacin de la fecha de asignacion
    ' Validacion de los datos personales
    End With

    ValidarForma = True
        
End Function


Public Property Get isActive() As Boolean

    isActive = mActive

End Property

Public Property Let isActive(bNewVal As Boolean)
Dim c As Control

    mActive = bNewVal
    
    If mActive Then
        EnableControls fPersonal
    Else
        DisableControls fPersonal
    End If

End Property

Private Sub FillFromInstance(pInstance As clsTrabajador)

    With UserControl
    .lblCodigo.Caption = pInstance.Codigo
    .txCedula.Text = pInstance.ci
    .txNombre.Text = pInstance.Nombre
    .ucSueldo.Value = pInstance.Sueldo
    .optBaseSueldo(pInstance.BaseSueldo).Value = True
    .cbxDepartamento.Text = pInstance.Departamento
    .cbxCargo.Text = pInstance.Cargo
    .dtFechaAsignacion.Fecha = pInstance.FechaAsignacion
    .dtFechaIngreso.Fecha = pInstance.FechaIngreso
    End With
    
    With fPersonal
    .txDireccion.Text = pInstance.Direccion
    .cbxEstadoCivil.ListIndex = pInstance.EstadoCivil + 1
    .cbxSexo.ListIndex = pInstance.Sexo + 1
    .txLugarNacimiento.Text = pInstance.LugarNacimiento
    .txNombreConyuge.Text = pInstance.NombreConyuge
    .txNumeroHijos.Value = pInstance.NumeroDeHijos
    .lblCodigoTrabajador.Caption = pInstance.Codigo
    .lblIdTrabajador.Caption = pInstance.ci
    .lblNombreTrabajador.Caption = pInstance.Nombre
    .dtFechaNacimiento.Fecha = pInstance.FechaNacimiento
    .txTelefonos.Text = pInstance.Telefono
    End With
    
End Sub

Public Sub SetCodigo(InCodigo As String)
Dim pInstance As clsTrabajador

    lblCodigo.Caption = InCodigo
    Set pInstance = New clsTrabajador
    If pInstance.Load(InCodigo) Then
        FillFromInstance pInstance
    End If
    Set pInstance = Nothing

End Sub


Private Sub cbDatosPersonales_Click()

    didOpenPersonal = True
    fPersonal.Show vbModal

End Sub

Private Sub InitCBX()

    Set tablaDeptos = New clsTablasCodigo
    tablaDeptos.SetTableName "nomDepartamentos", "Departamentos", "Departamento"
    UserControl.cbxDepartamento.SetTabla tablaDeptos
    
    Set tablaCargos = New clsTablasCodigo
    tablaCargos.SetTableName "nomDescCargos", "Cargos", "Cargo"
    UserControl.cbxCargo.SetTabla tablaCargos

End Sub

Private Sub DeinitCBX()

    Set tablaDeptos = Nothing
    Set tablaCargos = Nothing

End Sub

Private Sub UserControl_Initialize()

    SetContexto 0
    Set fPersonal = New frmPersonalData
    lmFillCombo.FillCombo fPersonal.cbxSexo, "Femenino", "Masculino"
    lmFillCombo.FillCombo fPersonal.cbxEstadoCivil, "Soltero", "Casado", "Amancebado", "Viudo", "Divorciado"

End Sub

Private Sub UserControl_KeyPress(KeyAscii As Integer)

    TranslateReturn KeyAscii, UserControl.ActiveControl

End Sub

Private Sub UserControl_Show()

    If Contexto = 2 Or Contexto = 3 Then
        txCedula.SetFocus
    End If

End Sub

Private Sub UserControl_Terminate()

    DeinitCBX
    Unload fPersonal
    Set fPersonal = Nothing

End Sub

Private Sub cbCancelar_Click()
Dim pInstance As clsTrabajador
Dim isOk As Boolean

    isOk = True
    RaiseEvent ButtonDown("cbCancelar", Contexto, isOk)
    If Not isOk Then Exit Sub
    
    cbCancelar.SetFocus
    
    Select Case Contexto
        Case 0:          ' Seleccin, o creacin de nuevo registro
            RaiseEvent CerrarControl
            Exit Sub
        Case 1:             ' Seleccin de nuevo item
            SetContexto 0
            Exit Sub
        Case 2:             ' Si estaba editando el registro
            Set pInstance = New clsTrabajador
            If pInstance.Load(lblCodigo.Caption) Then
                FillFromInstance pInstance
                SetContexto 1
            Else
                mAdvertencia "Imposible recargar datos...Registro eliminado"
                SetContexto 0
            End If
            Set pInstance = Nothing
            Exit Sub
        Case 3:
            RaiseEvent CerrarControl
            Exit Sub
    End Select
End Sub

Private Sub cbEditar_Click()
Dim pInstance As clsTrabajador
Dim isOk As Boolean

    isOk = True
    RaiseEvent ButtonDown("cbEditar", Contexto, isOk)
    If Not isOk Then Exit Sub

    Select Case Contexto
    
    Case 1
        SetContexto 2
        Exit Sub
        
    Case 2
        If Not ValidarForma Then Exit Sub
            
        Set pInstance = New clsTrabajador
        With UserControl
        If pInstance.Load(lblCodigo.Caption) Then
            
            If Not pInstance.ActualizarDescriptivos( _
              .lblCodigo.Caption, _
              .txNombre.Text, _
              .txCedula.Text, _
              .dtFechaIngreso.Fecha, _
              fPersonal.txDireccion.Text, _
              fPersonal.txTelefonos.Text, _
              IndiceSexo, _
              IndiceEstadoCivil, _
              fPersonal.dtFechaNacimiento.Fecha, _
              fPersonal.txLugarNacimiento.Text, _
              fPersonal.txNombreConyuge.Text, _
              fPersonal.txNumeroHijos.Value) Then
    
                mAdvertencia "Imposible actualizar los datos"
    
                If Not pInstance.Load(lblCodigo.Caption) Then
                    mAdvertencia "Aprentemente el registro fue borrado"
                    SetContexto 0
                    Exit Sub
                End If
                FillFromInstance pInstance
    
            End If
    
        Else
    
            mAdvertencia "El registro parece haber sido eliminado"
            SetContexto 0
    
        End If
    
        End With
    
        SetContexto 1
        Set pInstance = Nothing
        Exit Sub
        
    Case 3
            
        If Not ValidarForma Then Exit Sub
            
        Set pInstance = New clsTrabajador
        With UserControl
        pInstance.SaveNew .lblCodigo.Caption, _
            .txNombre.Text, _
            .txCedula.Text, _
            .cbxDepartamento.Text, _
            .cbxCargo.Text, _
            .dtFechaIngreso.Fecha, _
            .dtFechaAsignacion.Fecha, _
            .ucSueldo.Value, _
            BaseSueldo, _
            fPersonal.txDireccion.Text, _
            fPersonal.txTelefonos.Text, _
            IndiceSexo, _
            IndiceEstadoCivil, _
            fPersonal.dtFechaNacimiento.Fecha, _
            fPersonal.txLugarNacimiento.Text, _
            fPersonal.txNombreConyuge.Text, _
            fPersonal.txNumeroHijos.Value
        End With

        Set pInstance = Nothing

        RaiseEvent CerrarControl
            
        Exit Sub
    
    End Select

End Sub


Public Property Get ActiveControl() As Object

    Set ActiveControl = UserControl.ActiveControl

End Property

Private Sub cbEliminar_Click()
Dim pInstance As clsTrabajador, bIsOk As Boolean
Dim isOk As Boolean

    isOk = True
    RaiseEvent ButtonDown("cbEliminar", Contexto, isOk)
    If Not isOk Then Exit Sub
    
    If Contexto <> 1 Then
        Exit Sub
    End If
    
    bIsOk = False
    ' El procedimiento que maneje el evento DEBE setear isOk a true para proceder con la eliminacion
    RaiseEvent QueryDelete(lblCodigo.Caption, bIsOk)
    If Not bIsOk Then
        Exit Sub
    End If

'   La verificacin del permiso para borrar no nos interesa a nosotros... es responsabilidad de la aplicacin
'   If VerificarUsuario("Eliminar Cuenta") < 5 Then Exit Sub
    
    Set pInstance = New clsTrabajador
    
    If pInstance.Load(lblCodigo.Caption) Then

        On Error GoTo ErrHandler

        If pInstance.Eliminar Then
            SetContexto 0
        End If
    
    End If

ResumePoint:

    Exit Sub

ErrHandler:

    ReportarError False, Err.Number, Err.Description, Err.Source
    Resume ResumePoint

End Sub

Private Sub imgSiguiente_Click()
Dim pInstance As clsTrabajador

    If Contexto <> 1 Then Exit Sub
    
    Set pInstance = New clsTrabajador
    pInstance.Codigo = lblCodigo.Caption
    
    If Not pInstance.LoadSiguiente Then
        mAdvertencia "Este es el ltimo registro"
    Else
        FillFromInstance pInstance
        RaiseEvent NextPrev
    End If
    
    Set pInstance = Nothing

End Sub

Private Sub imgAnterior_Click()
Dim pInstance As clsTrabajador

    If Contexto <> 1 Then Exit Sub
    
    Set pInstance = New clsTrabajador
    pInstance.Codigo = lblCodigo.Caption
    
    If Not pInstance.LoadAnterior Then
        mAdvertencia "Este es el primer registro"
    Else
        FillFromInstance pInstance
        RaiseEvent NextPrev
    End If
    
    Set pInstance = Nothing

End Sub

Public Sub SetContexto(newContexto As Integer)
Dim i As Integer, isOk As Boolean

    Contexto = newContexto
    With UserControl
    cbEditar.Default = False
    Select Case Contexto
        Case 0          ' Seleccin de nuevo item
            DeinitCBX
            .lblCodigo.Caption = ""
            Disable .cbEditar: .cbEditar.Caption = "&Editar"
            Disable .cbEliminar: .cbEliminar.Caption = "Eli&minar"
            Enable .cbCancelar: .cbCancelar.Caption = "Terminar"
            .imgAnterior.Enabled = False
            .imgSiguiente.Enabled = False
            Enable .txCedula: .txCedula.Text = ""
            Disable .txNombre: .txNombre.Text = ""
            Disable .ucSueldo: .ucSueldo.Text = ""
            Disable .Frame1
            Disable .cbDatosPersonales
            Disable .cbxCargo: .cbxCargo.Text = ""
            Disable .cbxDepartamento: .cbxDepartamento.Text = ""
            Disable .dtFechaAsignacion: .dtFechaAsignacion.Text = ""
            Disable .dtFechaIngreso: .dtFechaIngreso.Text = ""
            RaiseEvent ChangeContexto(0)
            Exit Sub
        
        Case 1:         ' Item seleccionado: Operaciones posibles
            DeinitCBX
            cbEditar.Caption = "&Editar"
            Enable cbEditar
            cbEliminar.Caption = "Eli&minar"
            Enable cbEliminar
            cbCancelar.Caption = "Otro"
            Enable cbCancelar
            imgAnterior.Enabled = True
            imgSiguiente.Enabled = True
            Disable .txNombre
            Disable .txCedula
            Disable .ucSueldo
            Disable .Frame1
            Disable .cbDatosPersonales
            Disable .cbxCargo
            Disable .cbxDepartamento
            Disable .dtFechaAsignacion
            Disable .dtFechaIngreso
            
            cbCancelar.SetFocus
            RaiseEvent ChangeContexto(1)
            Exit Sub
        Case 2:         ' Edicin de los datos descriptivos
            
            RaiseEvent QueryEdit(isOk)
            If Not isOk Then
                Contexto = 1
                Exit Sub
            End If

            InitCBX
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            cbEditar.Caption = "&Guardar"
            cbEditar.Enabled = True
            cbEliminar.Enabled = False
            cbEliminar.Caption = "Eli&minar"
            cbCancelar.Caption = "Cancelar"
            cbCancelar.Enabled = True
            
            Enable .txNombre
            Enable .txCedula
            Disable .ucSueldo
            Disable .Frame1
            Enable .cbDatosPersonales
            Disable .cbxCargo
            Disable .cbxDepartamento
            Disable .dtFechaAsignacion
            Enable .dtFechaIngreso
            
            .txCedula.SetFocus

            RaiseEvent ChangeContexto(2)
            Exit Sub
        Case 3:         ' Modo de "creacion" de nueva entidad
            
            InitCBX
            didOpenPersonal = False
            cbEditar.Caption = "Crear"
            Enable cbEditar
            Enable cbEliminar
            cbEliminar.Caption = "Eliminar"
            cbCancelar.Caption = "Cancelar"
            Enable cbCancelar
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            
            Enable .txNombre
            Enable .txCedula
            Enable .ucSueldo
            Enable .Frame1
            Enable .cbDatosPersonales
            Enable .cbxCargo
            Enable .cbxDepartamento
            Enable .dtFechaAsignacion
            Enable .dtFechaIngreso
'           .txCedula.SetFocus
            
            RaiseEvent ChangeContexto(3)
            Exit Sub
    End Select
    End With
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,Enabled
Public Property Get Enabled() As Boolean
Attribute Enabled.VB_Description = "Returns/sets a value that determines whether an object can respond to user-generated events."
    Enabled = UserControl.Enabled
End Property

Public Property Let Enabled(ByVal New_Enabled As Boolean)
    UserControl.Enabled() = New_Enabled
    PropertyChanged "Enabled"
End Property

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    UserControl.Enabled = PropBag.ReadProperty("Enabled", True)

End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("Enabled", UserControl.Enabled, True)

End Sub

