VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsTrabajador"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const BASE_EVENTUAL = 0
Private Const BASE_DIARIO = 1
Private Const BASE_SEMANAL = 2
Private Const BASE_QUINCENAL = 3
Private Const BASE_MENSUAL = 4

Private Const ATR_INVALIDO = 0
Private Const ATR_DECLARATIVO = 1
Private Const ATR_NUMERICO = 2
Private Const ATR_FECHA = 3
Private Const ATR_TEXTO = 4

' ClassGen v2.0
Public Codigo As String
Public Nombre As String
Public CI As String
Public Departamento As String
Public Cargo As String
Public FechaIngreso As Date ' Fecha de  ingreso a la empresa.
Public FechaAsignacion As Date ' Fecha en que fue asignado al cargo actual
Public Sueldo As Currency
Public BaseSueldo As Integer ' 0: Eventual o a destajo, 1:Diario, 2:Semanal, 3:Quincenal, 4:Mensual
Public Direccion As String
Public Telefono As String
Public Sexo As Integer ' 0: Femenino, 1:Masculino
Public EstadoCivil As Integer ' 0: Soltero, 1: Casado, 2: Amancebado, 3: Divorciado, 4:Viudo
Public FechaNacimiento As Date
Public LugarNacimiento As String
Public NombreConyuge As String
Public NumeroDeHijos As Integer

Private pScript As Object

Private Enum ctResult
    CT_ERROR = 0
    CT_ATRIBUTO = 1
    CT_RELACION = 2
End Enum

Public Sub LoadInstance(rs As Recordset, Optional pDest As Object = Nothing)
Dim lpDest As clsTrabajador

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With rs
    lpDest.Codigo = stGetStringFromVariant(.Fields("Codigo"))
    lpDest.Nombre = stGetStringFromVariant(.Fields("Nombre"))
    lpDest.CI = stGetStringFromVariant(.Fields("CI"))
    lpDest.Departamento = stGetStringFromVariant(.Fields("Departamento"))
    lpDest.Cargo = stGetStringFromVariant(.Fields("Cargo"))
    lpDest.FechaIngreso = GetDateFromVariant(.Fields("FechaIngreso"))
    lpDest.FechaAsignacion = GetDateFromVariant(.Fields("FechaAsignacion"))
    lpDest.Sueldo = GetNumeroFromVariant(.Fields("Sueldo"))
    lpDest.BaseSueldo = GetNumeroFromVariant(.Fields("BaseSueldo"))
    lpDest.Direccion = stGetStringFromVariant(.Fields("Direccion"))
    lpDest.Telefono = stGetStringFromVariant(.Fields("Telefono"))
    lpDest.Sexo = GetNumeroFromVariant(.Fields("Sexo"))
    lpDest.EstadoCivil = GetNumeroFromVariant(.Fields("EstadoCivil"))
    lpDest.FechaNacimiento = GetDateFromVariant(.Fields("FechaNacimiento"))
    lpDest.LugarNacimiento = stGetStringFromVariant(.Fields("LugarNacimiento"))
    lpDest.NombreConyuge = stGetStringFromVariant(.Fields("NombreConyuge"))
    lpDest.NumeroDeHijos = GetNumeroFromVariant(.Fields("NumeroDeHijos"))
    End With

End Sub

Public Function Load(Codigo As String, Optional destino As Object = Nothing) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT * FROM nomTrabajadores WHERE Codigo = " & StringDB(Codigo)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, destino
    End If

ResumePoint:

    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    
    Err.Raise Err.Number, "clsTrabajador::Load", Err.Description
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function LoadAnterior(Optional destino As Object = Nothing) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
Dim pInstance As clsTrabajador

    If destino Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = destino
    End If
    
    sQuery = "SELECT * FROM nomTrabajadores WHERE Codigo IN (Select Max(Codigo) FROM nomTrabajadores WHERE Codigo < " & StringDB(pInstance.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        bResult = True
        LoadInstance rs, pInstance
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsTrabajador::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadSiguiente(Optional destino As Object = Nothing) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
Dim pInstance As clsTrabajador

    If destino Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = destino
    End If
    sQuery = "SELECT * FROM nomTrabajadores WHERE Codigo IN (Select Min(Codigo) FROM nomTrabajadores WHERE Codigo > " & StringDB(pInstance.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        bResult = True
        LoadInstance rs, pInstance
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsTrabajador::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT Codigo FROM nomTrabajadores WHERE Codigo = " & StringDB(arg)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    bRetVal = Not rs.EOF

ResumePoint:

    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsTrabajador::ExisteCodigo", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function SaveNew( _
    Codigo As String, _
    istrNombre As String, _
    istrCI As String, _
    istrDepartamento As String, _
    istrCargo As String, _
    ByVal idtFechaIngreso As Date, _
    ByVal idtFechaAsignacion As Date, _
    ByVal ivmSueldo As Currency, _
    ByVal inBaseSueldo As Integer, _
    istrDireccion As String, _
    istrTelefono As String, _
    ByVal inSexo As Integer, _
    ByVal inEstadoCivil As Integer, _
    ByVal idtFechaNacimiento As Date, _
    istrLugarNacimiento As String, _
    istrNombreConyuge As String, _
    ByVal inNumeroDeHijos As Integer) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "INSERT INTO nomTrabajadores (Codigo, Nombre, CI, Departamento, Cargo, FechaIngreso, FechaAsignacion, Sueldo, BaseSueldo, Direccion, Telefono, Sexo, EstadoCivil, FechaNacimiento, LugarNacimiento, NombreConyuge, NumeroDeHijos) VALUES ("
    sQuery = sQuery & StringDB(Codigo)
    sQuery = sQuery & "," & StringDB(istrNombre)
    sQuery = sQuery & "," & StringDB(istrCI)
    sQuery = sQuery & "," & StringDB(istrDepartamento)
    sQuery = sQuery & "," & StringDB(istrCargo)
    sQuery = sQuery & "," & FechaDB(idtFechaIngreso)
    sQuery = sQuery & "," & FechaDB(idtFechaAsignacion)
    sQuery = sQuery & "," & Trim(ivmSueldo)
    sQuery = sQuery & "," & Trim(inBaseSueldo)
    sQuery = sQuery & "," & StringDB(istrDireccion)
    sQuery = sQuery & "," & StringDB(istrTelefono)
    sQuery = sQuery & "," & Trim(inSexo)
    sQuery = sQuery & "," & Trim(inEstadoCivil)
    sQuery = sQuery & "," & FechaDB(idtFechaNacimiento)
    sQuery = sQuery & "," & StringDB(istrLugarNacimiento)
    sQuery = sQuery & "," & StringDB(istrNombreConyuge)
    sQuery = sQuery & "," & Trim(inNumeroDeHijos)
    sQuery = sQuery & ")"


    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    SaveNew = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::AddNew"
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(sCodigo As String, _
    istrNombre As String, _
    istrCI As String, _
    istrDepartamento As String, _
    istrCargo As String, _
    ByVal idtFechaIngreso As Date, _
    ByVal idtFechaAsignacion As Date, _
    ByVal ivmSueldo As Currency, _
    ByVal inBaseSueldo As Integer, _
    istrDireccion As String, _
    istrTelefono As String, _
    ByVal inSexo As Integer, _
    ByVal inEstadoCivil As Integer, _
    ByVal idtFechaNacimiento As Date, _
    istrLugarNacimiento As String, _
    istrNombreConyuge As String, _
    ByVal inNumeroDeHijos As Integer) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "UPDATE nomTrabajadores SET "
    sQuery = sQuery & "Nombre = " & StringDB(istrNombre)
    sQuery = sQuery & ", CI = " & StringDB(istrCI)
    sQuery = sQuery & ", Departamento = " & StringDB(istrDepartamento)
    sQuery = sQuery & ", Cargo = " & StringDB(istrCargo)
    sQuery = sQuery & ", FechaIngreso = " & FechaDB(idtFechaIngreso)
    sQuery = sQuery & ", FechaAsignacion = " & FechaDB(idtFechaAsignacion)
    sQuery = sQuery & ", Sueldo = " & Trim(ivmSueldo)
    sQuery = sQuery & ", BaseSueldo = " & Trim(inBaseSueldo)
    sQuery = sQuery & ", Direccion = " & StringDB(istrDireccion)
    sQuery = sQuery & ", Telefono = " & StringDB(istrTelefono)
    sQuery = sQuery & ", Sexo = " & Trim(inSexo)
    sQuery = sQuery & ", EstadoCivil = " & Trim(inEstadoCivil)
    sQuery = sQuery & ", FechaNacimiento = " & FechaDB(idtFechaNacimiento)
    sQuery = sQuery & ", LugarNacimiento = " & StringDB(istrLugarNacimiento)
    sQuery = sQuery & ", NombreConyuge = " & StringDB(istrNombreConyuge)
    sQuery = sQuery & ", NumeroDeHijos = " & Trim(inNumeroDeHijos)

    sQuery = sQuery & " WHERE Codigo = " & StringDB(Codigo)

    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:
    ActualizarDescriptivos = bRetVal
    Exit Function

ErrHandler:
    Err.Raise Err.Number, "clsTrabajador::ActualizarDescriptivos", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Eliminar() As Boolean
Dim sQuery As String, bRetVal As Boolean

        sQuery = "DELETE * FROM nomTrabajadores WHERE Codigo = " & StringDB(Me.Codigo)
        bRetVal = True
        On Error GoTo ErrHandler

        dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::Eliminar"
    Resume ResumePoint

End Function

Public Sub SetScript(ipScript As Object)

    Set pScript = ipScript

End Sub

Public Function EvalVar(istrVarID As String, ByRef ovarRetBuffer As Variant, ByRef ostrRetString As String) As Boolean
Dim strVarId As String, bRetVal As Boolean
Dim strFuncName As String, dtFechaProceso As Date, dblAuxiliar As Double
Dim difAnhos As Integer, difMeses As Integer, difDias As Integer

    strVarId = UCase(istrVarID)
    
    bRetVal = True
    
    Select Case strVarId
    
    Case "SUELDO"
        ovarRetBuffer = Me.Sueldo
        ostrRetString = Format(Me.Sueldo, "#,###,###,###,##0.00")
    
    Case "BASESUELDO"
        ovarRetBuffer = Me.BaseSueldo
        ostrRetString = Format(Me.BaseSueldo, "0")

    Case "NOMBREBASESUELDO", "NOMBRE_BASE_SUELDO"
        Select Case Me.BaseSueldo
        Case 0
            ostrRetString = "Destajo"
        Case 1
            ostrRetString = "Diario"
        Case 2
            ostrRetString = "Semanal"
        Case 3
            ostrRetString = "Quincenal"
        Case 4
            ostrRetString = "Mensual"
        End Select
        ovarRetBuffer = ostrRetString

    Case "SUELDODIARIO"
        Select Case Me.BaseSueldo
        Case 1
            ovarRetBuffer = Me.Sueldo
        Case 2
            ovarRetBuffer = Me.Sueldo / 7
        Case 3
            ovarRetBuffer = Me.Sueldo * 24 / 365
        Case 4
            ovarRetBuffer = Me.Sueldo * 12 / 365
        Case Else
            ovarRetBuffer = 0#
        End Select
        ostrRetString = Format(ovarRetBuffer, "###,###,###,##0.00")
    
    Case "ANTIGUEDAD_AOS"
        pScript.EvalVar "FECHA_PROCESO", dtFechaProceso, ostrRetString
        difAnhos = VSLRTLIB.difAnhos(FechaIngreso, dtFechaProceso)
        ovarRetBuffer = difAnhos
        ostrRetString = Format(difAnhos, "##0")
        
    Case "ANTIGUEDAD_MESES"
        pScript.EvalVar "FECHA_PROCESO", dtFechaProceso, ostrRetString
        difAnhos = VSLRTLIB.difMeses(FechaIngreso, dtFechaProceso)
        ovarRetBuffer = difAnhos
        ostrRetString = Format(difAnhos, "##0")
    
    Case "RESIDUO_MESES"
        pScript.EvalVar "FECHA_PROCESO", dtFechaProceso, ostrRetString
        difAnhos = VSLRTLIB.ResiduoMeses(FechaIngreso, dtFechaProceso)
        ovarRetBuffer = difAnhos
        ostrRetString = Format(difAnhos, "##0")

    Case "RESIDUO_DIAS_MES"
        pScript.EvalVar "FECHA_PROCESO", dtFechaProceso, ostrRetString
        difAnhos = VSLRTLIB.ResiduoDiasMeses(FechaIngreso, dtFechaProceso)
        ovarRetBuffer = difAnhos
        ostrRetString = Format(difAnhos, "##0")

    Case "RESIDUO_DIAS"
        pScript.EvalVar "FECHA_PROCESO", dtFechaProceso, ostrRetString
        difAnhos = VSLRTLIB.ResiduoDiasAnho(FechaIngreso, dtFechaProceso)
        ovarRetBuffer = difAnhos
        ostrRetString = Format(difAnhos, "##0")

    Case "ANTIGUEDAD_DIAS"
        pScript.EvalVar "FECHA_PROCESO", dtFechaProceso, ostrRetString
        difAnhos = dtFechaProceso - FechaIngreso
        ovarRetBuffer = difAnhos
        ostrRetString = Format(difAnhos, "##0")
        
    Case "CODIGO"
        ovarRetBuffer = Codigo
        ostrRetString = Codigo

    Case "NOMBRE"
        ovarRetBuffer = Nombre
        ostrRetString = Nombre

    Case "CI", "CEDULA", "ID"
        ovarRetBuffer = CI
        ostrRetString = CI

    Case "DEPARTAMENTO", "DEPT", "DEPTO"
        ovarRetBuffer = Departamento
        ostrRetString = Departamento

    Case "CARGO", "PUESTO", "POSICION"
        ostrRetString = Cargo
        ovarRetBuffer = ostrRetString

    Case "INGRESO", "FECHA_INGRESO", "FECHAINGRESO"
        ostrRetString = Format(FechaIngreso, "Short Date")
        ovarRetBuffer = FechaIngreso
    
    Case "ASIGNACION", "FECHA_ASIGNACION", "FECHAASIGNACION"
        ostrRetString = Format(FechaAsignacion, "Short Date")
        ovarRetBuffer = FechaAsignacion

    Case Else
    
        bRetVal = pScript.EvalVar(strVarId, ovarRetBuffer, ostrRetString)
    
    End Select

    EvalVar = bRetVal

End Function

Public Function TipoAtributo(istrVarID As String) As Integer
Dim strRetBuff As String, vRetBuffer As Variant, bIsValid As Boolean

    bIsValid = Me.EvalVar(istrVarID, vRetBuffer, strRetBuff)
    If Not bIsValid Then
        TipoAtributo = ATR_INVALIDO
    Else
        Select Case VarType(vRetBuffer)
        Case vbInteger To vbCurrency, vbDecimal, vbByte
            TipoAtributo = ATR_NUMERICO
        Case vbDate
            TipoAtributo = ATR_FECHA
        Case vbString
            TipoAtributo = ATR_TEXTO
        Case Else
            TipoAtributo = ATR_INVALIDO
        End Select
    End If

End Function

