VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsTrabajador"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' ClassGen v2.0
Public Codigo As String
Public Nombre As String
Public ci As String
Public Departamento As String
Public Cargo As String
Public FechaIngreso As Date     ' Fecha de  ingreso a la empresa.
Public FechaAsignacion As Date  ' Fecha en que fue asignado al cargo actual
Public Sueldo As Currency
Public BaseSueldo As Integer    ' 0: Eventual o a destajo, 1:Diario, 2:Semanal, 3:Quincenal, 4:Mensual
Public Direccion As String
Public Telefono As String
Public Sexo As Integer          ' 0: Femenino, 1:Masculino
Public EstadoCivil As Integer   ' 0: Soltero, 1: Casado, 2: Amancebado, 3: Divorciado, 4:Viudo
Public FechaNacimiento As Date
Public LugarNacimiento As String
Public NombreConyuge As String
Public NumeroDeHijos As Integer
Public ImageFile As String

Private pScript As Object

Private Enum ctResult
    CT_ERROR = 0
    CT_ATRIBUTO = 1
    CT_RELACION = 2
End Enum

Public Event ExcepcionProcesada(lngNumeroExcepcion As String)
' Este evento se agrega para informar al controlador del proceso
' que se proces una excepcin.
' MOTIVACION:
' Las excepciones recurrentes deben ser actualizadas -y eventualmente
' eliminadas, si se ha cumplido el fin de su condicin de permanencia.
' Los procesos pueden ser REALES o SIMULACIONES. En un proceso REAL
' las excepciones deben ser actualizadas; en un proceso simulado NO.
' El Trabajador no tiene manera de saber el tipo proceso (y sera en-
' gorroso pasar un parmetro a travs de una cadena de evaluadores
' potencialmente compleja). De manera que mediante un evento, el trabajador
' le informa al proceso anfitrin que una excepcin fue "usada". Al
' terminar cada trabajador, es responsabilidad del proceso actualizar o
' no las excepciones.

Public Function ImagenBaseSalarial(Optional ByVal inBas As Integer = -1)
Dim sRetString As String

    If inBas < 0 Then inBas = Me.BaseSueldo
    Select Case inBas
    Case 0
        sRetString = "Destajo"
    Case 1
        sRetString = "Diario"
    Case 2
        sRetString = "Semanal"
    Case 3
        sRetString = "Quincenal"
    Case 4
        sRetString = "Mensual"
    Case Else
        sRetString = "INVALIDA"
    End Select
    
    ImagenBaseSalarial = sRetString

End Function

Public Function IndiceImagenBase(istrImagen As String) As Integer
Dim iRetVal As Integer

    Select Case UCase(istrImagen)
    Case "DESTAJO"
        iRetVal = 0
    Case "DIARIO"
        iRetVal = 1
    Case "SEMANAL"
        iRetVal = 2
    Case "QUINCENAL"
        iRetVal = 3
    Case "MENSUAL"
        iRetVal = 4
    Case Else
        ReportarError True, 1001, "Argumento Invlido: " & istrImagen, "clsTrabajador::IndiceImagenBase"
        End
    End Select
    
    IndiceImagenBase = iRetVal

End Function

Public Sub Clone(pDest As clsTrabajador)

    With Me
    pDest.Codigo = .Codigo
    pDest.Nombre = .Nombre
    pDest.ci = .ci
    pDest.Departamento = .Departamento
    pDest.Cargo = .Cargo
    pDest.FechaIngreso = .FechaIngreso
    pDest.FechaAsignacion = .FechaAsignacion
    pDest.Sueldo = .Sueldo
    pDest.BaseSueldo = .BaseSueldo
    pDest.Direccion = .Direccion
    pDest.Telefono = .Telefono
    pDest.Sexo = .Sexo
    pDest.EstadoCivil = .EstadoCivil
    pDest.FechaNacimiento = .FechaNacimiento
    pDest.LugarNacimiento = .LugarNacimiento
    pDest.NombreConyuge = .NombreConyuge
    pDest.NumeroDeHijos = .NumeroDeHijos
    pDest.ImageFile = .ImageFile
    End With

End Sub

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsTrabajador = Nothing)
Dim lpDest As clsTrabajador

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With rs
    lpDest.Codigo = stGetStringFromVariant(.Fields("Codigo"))
    lpDest.Nombre = stGetStringFromVariant(.Fields("Nombre"))
    lpDest.ci = stGetStringFromVariant(.Fields("CI"))
    lpDest.Departamento = stGetStringFromVariant(.Fields("Departamento"))
    lpDest.Cargo = stGetStringFromVariant(.Fields("Cargo"))
    lpDest.FechaIngreso = GetDateFromVariant(.Fields("FechaIngreso"))
    lpDest.FechaAsignacion = GetDateFromVariant(.Fields("FechaAsignacion"))
    lpDest.Sueldo = GetNumeroFromVariant(.Fields("Sueldo"))
    lpDest.BaseSueldo = GetNumeroFromVariant(.Fields("BaseSueldo"))
    lpDest.Direccion = Replace(Replace(stGetStringFromVariant(.Fields("Direccion")), "<LF>", vbCrLf), "<QUOT>", "'")
    lpDest.Telefono = stGetStringFromVariant(.Fields("Telefono"))
    lpDest.Sexo = GetNumeroFromVariant(.Fields("Sexo"))
    lpDest.EstadoCivil = GetNumeroFromVariant(.Fields("EstadoCivil"))
    lpDest.FechaNacimiento = GetDateFromVariant(.Fields("FechaNacimiento"))
    lpDest.LugarNacimiento = stGetStringFromVariant(.Fields("LugarNacimiento"))
    lpDest.NombreConyuge = stGetStringFromVariant(.Fields("NombreConyuge"))
    lpDest.NumeroDeHijos = GetNumeroFromVariant(.Fields("NumeroDeHijos"))
    lpDest.ImageFile = GetStringFromVariant(.Fields("ImageFile"))
    End With

End Sub

Public Function AgregarExcepcion(ByVal istrTipoEx As String, ByVal idtFechaEx As Date, ByVal idblValorExcepcion As Double, ByVal inTipoRecurrencia As Integer, ByVal ivRecurrencia As Double, ByVal istrComentarios As String) As Boolean
Dim pExcepcion As clsExcepcion, bRetVal As Boolean

    Set pExcepcion = New clsExcepcion
    bRetVal = pExcepcion.SaveNew(Me.Codigo, istrTipoEx, idtFechaEx, idblValorExcepcion, inTipoRecurrencia, ivRecurrencia, istrComentarios)
    Set pExcepcion = Nothing

    AgregarExcepcion = bRetVal

End Function

Public Function EliminarExcepciones(ByVal istrTipoEx As String)
Dim pExcepcion As clsExcepcion, bRetVal As Boolean

    Set pExcepcion = New clsExcepcion
    bRetVal = pExcepcion.EliminarExcepciones(Me.Codigo, istrTipoEx)
    Set pExcepcion = Nothing
    
    EliminarExcepciones = bRetVal

End Function

Public Function Load(Codigo As String, Optional destino As clsTrabajador = Nothing) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT * FROM nomTrabajadores WHERE Codigo = " & StringDB(Codigo)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, destino
    End If

ResumePoint:

    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    
    Err.Raise Err.Number, "clsTrabajador::Load", Err.Description
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function LoadAnterior(Optional destino As clsTrabajador = Nothing) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
Dim pInstance As clsTrabajador

    If destino Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = destino
    End If
    
    sQuery = "SELECT * FROM nomTrabajadores WHERE Codigo IN (Select Max(Codigo) FROM nomTrabajadores WHERE Codigo < " & StringDB(pInstance.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        bResult = True
        LoadInstance rs, pInstance
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsTrabajador::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadSiguiente(Optional destino As clsTrabajador = Nothing) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
Dim pInstance As clsTrabajador

    If destino Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = destino
    End If
    sQuery = "SELECT * FROM nomTrabajadores WHERE Codigo IN (Select Min(Codigo) FROM nomTrabajadores WHERE Codigo > " & StringDB(pInstance.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        bResult = True
        LoadInstance rs, pInstance
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsTrabajador::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT Codigo FROM nomTrabajadores WHERE Codigo = " & StringDB(arg)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    bRetVal = Not rs.EOF

ResumePoint:

    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsTrabajador::ExisteCodigo", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function SaveNew( _
    Codigo As String, _
    istrNombre As String, _
    istrCI As String, _
    istrDepartamento As String, _
    istrCargo As String, _
    ByVal idtFechaIngreso As Date, _
    ByVal idtFechaAsignacion As Date, _
    ByVal ivmSueldo As Currency, _
    ByVal inBaseSueldo As Integer, _
    istrDireccion As String, _
    istrTelefono As String, _
    ByVal inSexo As Integer, _
    ByVal inEstadoCivil As Integer, _
    ByVal idtFechaNacimiento As Date, _
    istrLugarNacimiento As String, _
    istrNombreConyuge As String, _
    ByVal inNumeroDeHijos As Integer, _
    istrImageFile As String) As Boolean
Dim sQuery As String, bRetVal As Boolean
Dim pHistoria As clsHistoriaTrabajador

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "INSERT INTO nomTrabajadores (Codigo, Nombre, CI, Departamento, Cargo, FechaIngreso, FechaAsignacion, Sueldo, BaseSueldo, Direccion, Telefono, Sexo, EstadoCivil, FechaNacimiento, LugarNacimiento, NombreConyuge, NumeroDeHijos, ImageFile) VALUES ("
    sQuery = sQuery & StringDB(Codigo)
    sQuery = sQuery & "," & StringDB(istrNombre)
    sQuery = sQuery & "," & StringDB(istrCI)
    sQuery = sQuery & "," & StringDB(istrDepartamento)
    sQuery = sQuery & "," & StringDB(istrCargo)
    sQuery = sQuery & "," & FechaDB(idtFechaIngreso)
    sQuery = sQuery & "," & FechaDB(idtFechaAsignacion)
    sQuery = sQuery & "," & NumeroDB(ivmSueldo)
    sQuery = sQuery & "," & NumeroDB(inBaseSueldo)
    sQuery = sQuery & "," & StringDB(Replace(Replace(istrDireccion, vbCrLf, "<LF>"), "'", "<QUOT>"))
    sQuery = sQuery & "," & StringDB(istrTelefono)
    sQuery = sQuery & "," & NumeroDB(inSexo)
    sQuery = sQuery & "," & NumeroDB(inEstadoCivil)
    sQuery = sQuery & "," & FechaDB(idtFechaNacimiento)
    sQuery = sQuery & "," & StringDB(istrLugarNacimiento)
    sQuery = sQuery & "," & StringDB(istrNombreConyuge)
    sQuery = sQuery & "," & Trim(inNumeroDeHijos)
    sQuery = sQuery & "," & StringDB(istrImageFile)
    sQuery = sQuery & ")"

    dbHandle.Execute sQuery, dbFailOnError

    Set pHistoria = New clsHistoriaTrabajador
    With pHistoria
    .Base = inBaseSueldo
    .Cargo = istrCargo
    .CodigoTrabajador = Codigo
    .Departamento = istrDepartamento
    .Desde = idtFechaAsignacion
    .Sueldo = ivmSueldo
    .Save
    End With
    Set pHistoria = Nothing
    
    bRetVal = Me.Load(Codigo)
ResumePoint:
    SaveNew = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::AddNew"
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(sCodigo As String, _
    istrNombre As String, _
    istrCI As String, _
    ByVal idtFechaIngreso As Date, _
    istrDireccion As String, _
    istrTelefono As String, _
    ByVal inSexo As Integer, _
    ByVal inEstadoCivil As Integer, _
    ByVal idtFechaNacimiento As Date, _
    istrLugarNacimiento As String, _
    istrNombreConyuge As String, _
    ByVal inNumeroDeHijos As Integer, _
    istrImageFile As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "UPDATE nomTrabajadores SET "
    sQuery = sQuery & "Nombre = " & StringDB(istrNombre)
    sQuery = sQuery & ", CI = " & StringDB(istrCI)
    sQuery = sQuery & ", FechaIngreso = " & FechaDB(idtFechaIngreso)
    sQuery = sQuery & ", Direccion = " & StringDB(Replace(Replace(istrDireccion, vbCrLf, "<LF>"), "'", "<QUOT>"))
    sQuery = sQuery & ", Telefono = " & StringDB(istrTelefono)
    sQuery = sQuery & ", Sexo = " & Trim(inSexo)
    sQuery = sQuery & ", EstadoCivil = " & Trim(inEstadoCivil)
    sQuery = sQuery & ", FechaNacimiento = " & FechaDB(idtFechaNacimiento)
    sQuery = sQuery & ", LugarNacimiento = " & StringDB(istrLugarNacimiento)
    sQuery = sQuery & ", NombreConyuge = " & StringDB(istrNombreConyuge)
    sQuery = sQuery & ", NumeroDeHijos = " & Trim(inNumeroDeHijos)
    sQuery = sQuery & ", ImageFile = " & StringDB(istrImageFile)
    sQuery = sQuery & " WHERE Codigo = " & StringDB(Codigo)

    dbHandle.Execute sQuery, dbFailOnError
    Load sCodigo
    
ResumePoint:
    ActualizarDescriptivos = bRetVal
    Exit Function

ErrHandler:
    Err.Raise Err.Number, "clsTrabajador::ActualizarDescriptivos", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ActualizarPosicion(istrDepartamento As String, istrCargo As String, ivmSueldo As Currency, inBase As Integer, idtDesde As Date) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "UPDATE nomTrabajadores SET "
    sQuery = sQuery & "Departamento = " & StringDB(istrDepartamento) & ", "
    sQuery = sQuery & "Cargo = " & StringDB(istrCargo) & ", "
    sQuery = sQuery & "Sueldo = " & NumeroDB(ivmSueldo) & ", "
    sQuery = sQuery & "BaseSueldo = " & NumeroDB(inBase) & ", "
    sQuery = sQuery & "FechaAsignacion = " & FechaDB(idtDesde)
    sQuery = sQuery & " WHERE Codigo = " & StringDB(Codigo)

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    ActualizarPosicion = bRetVal
    Exit Function

ErrHandler:
    Err.Raise Err.Number, "clsTrabajador::ActualizarPosicion", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Eliminar() As Boolean
Dim sQuery As String, bRetVal As Boolean

        sQuery = "DELETE * FROM nomTrabajadores WHERE Codigo = " & StringDB(Me.Codigo)
        bRetVal = True
        On Error GoTo ErrHandler

        dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::Eliminar"
    Resume ResumePoint

End Function

Public Sub SetScript(ipScript As Object)
  Set pScript = ipScript
End Sub

Public Function EvalVar(istrVarID As String, ByRef ovarRetBuffer As Variant, ByRef ostrRetString As String) As Boolean
Dim strVarId As String, bRetVal As Boolean
Dim strFuncName As String, dtFechaProceso As Date, dblAuxiliar As Double
Dim difAnhos As Integer, difMeses As Integer, DifDias As Integer

  On Error GoTo ErrHandler
  strVarId = UCase(istrVarID)
  bRetVal = True
  
  Select Case strVarId
  
  Case "SUELDO"
    ovarRetBuffer = Me.Sueldo
    ostrRetString = Format(Me.Sueldo, "#,###,###,###,##0.00")
  
  Case "BASESUELDO"
    ovarRetBuffer = Me.BaseSueldo
    ostrRetString = Format(Me.BaseSueldo, "0")
  
  Case "NOMBREBASESUELDO", "NOMBRE_BASE_SUELDO"
    Select Case Me.BaseSueldo
    Case 0
      ostrRetString = "Destajo"
    Case 1
      ostrRetString = "Diario"
    Case 2
      ostrRetString = "Semanal"
    Case 3
      ostrRetString = "Quincenal"
    Case 4
      ostrRetString = "Mensual"
    End Select
    ovarRetBuffer = ostrRetString

  Case "SUELDODIARIO", "SUELDOHORA"
    Select Case Me.BaseSueldo
    Case 1
      ovarRetBuffer = Me.Sueldo
    Case 2
      ovarRetBuffer = Me.Sueldo / 7
    Case 3
      ovarRetBuffer = Me.Sueldo * 24 / 364
    Case 4
      ovarRetBuffer = Me.Sueldo * 12 / 364
    Case Else
      ovarRetBuffer = 0#
    End Select
      
    If istrVarID = "SUELDOHORA" Then
        ovarRetBuffer = ovarRetBuffer / 8
    End If

    ostrRetString = Format(ovarRetBuffer, "###,###,###,##0.00")

  Case "ANTIGUEDAD_AOS"
    dtFechaProceso = pScript.FechaCierre
    difAnhos = VSLRTLIB.difAnhos(FechaIngreso, dtFechaProceso)
    ovarRetBuffer = difAnhos
    ostrRetString = Format(difAnhos, "##0")
      
  Case "ANTIGUEDAD_MESES"
    dtFechaProceso = pScript.FechaCierre
    difAnhos = VSLRTLIB.difMeses(FechaIngreso, dtFechaProceso)
    ovarRetBuffer = difAnhos
    ostrRetString = Format(difAnhos, "##0")

  Case "RESIDUO_MESES"
    dtFechaProceso = pScript.FechaCierre
    difAnhos = VSLRTLIB.ResiduoMeses(FechaIngreso, dtFechaProceso)
    ovarRetBuffer = difAnhos
    ostrRetString = Format(difAnhos, "##0")

  Case "RESIDUO_DIAS_MES"
    dtFechaProceso = pScript.FechaCierre
    difAnhos = VSLRTLIB.ResiduoDiasMeses(FechaIngreso, dtFechaProceso)
    ovarRetBuffer = difAnhos
    ostrRetString = Format(difAnhos, "##0")

  Case "RESIDUO_DIAS"
    dtFechaProceso = pScript.FechaCierre
    difAnhos = VSLRTLIB.ResiduoDiasAnho(FechaIngreso, dtFechaProceso)
    ovarRetBuffer = difAnhos
    ostrRetString = Format(difAnhos, "##0")

  Case "ANTIGUEDAD_DIAS"
    dtFechaProceso = pScript.FechaCierre
    difAnhos = dtFechaProceso - FechaIngreso
    ovarRetBuffer = difAnhos
    ostrRetString = Format(difAnhos, "##0")
      
  Case "CODIGO", "CODIGOTRABAJADOR", "CODIGO_TRABAJADOR"
    ovarRetBuffer = Codigo
    ostrRetString = Codigo

  Case "NOMBRE_TRABAJADOR", "NOMBRETRABAJADOR"
    ovarRetBuffer = Nombre
    ostrRetString = Nombre

  Case "CI", "CEDULA", "ID"
    ovarRetBuffer = ci
    ostrRetString = ci

  Case "DEPARTAMENTO", "DEPT", "DEPTO"
    ovarRetBuffer = Departamento
    ostrRetString = Departamento

  Case "CARGO", "PUESTO", "POSICION"
    ostrRetString = Cargo
    ovarRetBuffer = ostrRetString

  Case "INGRESO", "FECHA_INGRESO", "FECHAINGRESO"
    ostrRetString = Format(FechaIngreso, "Short Date")
    ovarRetBuffer = FechaIngreso
  
  Case "ASIGNACION", "FECHA_ASIGNACION", "FECHAASIGNACION"
    ostrRetString = Format(FechaAsignacion, "Short Date")
    ovarRetBuffer = FechaAsignacion

  Case Else

    bRetVal = EvaluarAtributo(istrVarID, dblAuxiliar)
    If bRetVal Then
      ostrRetString = Format(dblAuxiliar, "###,###,##0.00")
      ovarRetBuffer = dblAuxiliar
    Else
      If Not pScript Is Nothing Then
        On Error Resume Next
        bRetVal = pScript.EvalVar(strVarId, ovarRetBuffer, ostrRetString)
      Else
        bRetVal = False
      End If
    End If
  
  End Select

ResumePoint:

  EvalVar = bRetVal
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  bRetVal = False
  ReportarError False, nErrN, sErrD, "clsTrabajador::EvalVar"
  Resume ResumePoint

End Function

' ATRIBUTOS....

Public Function TipoAtributo(istrVarID As String) As TipoAtributo
Dim vVar As Variant, sImg As String, bRetVal As Boolean

    bRetVal = EvalVar(istrVarID, vVar, sImg)

    If Not bRetVal Then
        TipoAtributo = TA_INVALIDO
    Else
        Select Case varType(vVar)
        Case vbInteger To vbCurrency, vbDecimal, vbByte, vbBoolean
            TipoAtributo = TA_NUMERO
        Case vbDate
            TipoAtributo = TA_FECHA
        Case vbString
            TipoAtributo = TA_TEXTO
        Case Else
            TipoAtributo = TA_INVALIDO
        End Select
    End If

End Function

Public Function EvaluarAtributo(istrAtributo As String, odblValor As Double) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "SELECT * FROM nomAtribTrabajador "
    sQuery = sQuery & "WHERE CodTrab = " & StringDB(Me.Codigo) & " "
    sQuery = sQuery & "AND CodAttrib = " & StringDB(istrAtributo)

    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        odblValor = GetNumeroFromVariant(rs.Fields("ValAttrib"))
    End If
    
ResumePoint:
    Set rs = Nothing
    EvaluarAtributo = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::EvaluarAtributo"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ValorAtributo(iAtributo) As Double
Dim str As String, bResult As Boolean, dblResult As Double

    str = iAtributo
    bResult = EvaluarAtributo(CStr(iAtributo), dblResult)
    If Not bResult Then
        dblResult = 0
    End If
    ValorAtributo = dblResult

End Function

Public Function ListaAtributos() As Collection
Dim pRetCol As Collection, pWrkAttr As clsAtributoTrabajador
Dim rs As Recordset

    On Error GoTo ErrHandler

    Set pRetCol = New Collection
    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomAtribTrabajador WHERE CodTrab = " & StringDB(Me.Codigo), dbOpenForwardOnly)
    Do While Not rs.EOF
        Set pWrkAttr = New clsAtributoTrabajador
        With pWrkAttr
        .CodAttrib = rs!CodAttrib
        .CodTrab = rs!CodTrab
        .ValAttrib = rs!ValAttrib
        End With
        pRetCol.Add pWrkAttr
        rs.MoveNext
    Loop
    
ResumePoint:
    Set rs = Nothing
    Set ListaAtributos = pRetCol
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::ListaAtributos"
    Set pRetCol = Nothing
    Resume ResumePoint

End Function

Public Function RemoveAtributo(istrNombreAtributo As Variant) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE * FROM nomAtribTrabajador WHERE CodTrab = " & StringDB(Me.Codigo) & " AND CodAttrib = " & StringDB(CStr(istrNombreAtributo)), dbFailOnError

ResumePoint:
    RemoveAtributo = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::RemoveAtributo"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function UpdateCreateAtributo(istrCodigoAtributo As Variant, idblValor As Variant) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    
    If InStr(1, "FECHAINGRESO|FECHAASIGNACION|SUELDO|BASESUELDO|NUMERODEHIJOS|CI", istrCodigoAtributo, vbTextCompare) > 0 Then
        mAdvertencia istrCodigoAtributo & " es un atributo intrnseco, y no puede ser actualizado."
        UpdateCreateAtributo = False
        Exit Function
    End If

    If Not ptAtributos.Validar(CStr(istrCodigoAtributo)) Then
        bRetVal = False
        Exit Function
    End If
    
    bRetVal = True

    sQuery = "UPDATE nomAtribTrabajador SET ValAttrib = " & NumeroDB(idblValor) & " "
    sQuery = sQuery & "WHERE CodTrab = " & StringDB(Me.Codigo) & " "
    sQuery = sQuery & "AND CodAttrib = " & StringDB(CStr(istrCodigoAtributo))
    
    dbHandle.Execute sQuery, dbFailOnError

    If dbHandle.RecordsAffected = 0 Then
        sQuery = "INSERT INTO nomAtribTrabajador (CodTrab, CodAttrib, ValAttrib) SELECT "
        sQuery = sQuery & StringDB(Me.Codigo) & ", "
        sQuery = sQuery & StringDB(CStr(istrCodigoAtributo)) & ", "
        sQuery = sQuery & NumeroDB(idblValor)
        
        dbHandle.Execute sQuery, dbFailOnError
    End If

ResumePoint:
    UpdateCreateAtributo = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsTrabajador::UpdateCreateAtributo"
    bRetVal = False
    Resume ResumePoint

End Function

' EXCEPCIONES ...

Public Function ValorExcepciones(istrCodEx, Optional ByVal FechaCierre As Date) As Double
Dim dblRetVal As Double, pExcepcion As clsExcepcion

    If Year(FechaCierre) < 1900 Then FechaCierre = Date

    Set pExcepcion = New clsExcepcion
    dblRetVal = pExcepcion.ValorExcepcionesTrabajador(Me.Codigo, CStr(istrCodEx), FechaCierre)
    RaiseEvent ExcepcionProcesada(CStr(istrCodEx))    ' Informa al proceso anfitrin.
    Set pExcepcion = Nothing
    
    ValorExcepciones = dblRetVal

End Function

' Acumuladores laborales...

Public Function Acumulado(istrClaseLaboral, idtFechaDesde, idtFechaHasta)
Dim vRetVal As Currency, rs As Recordset, sQuery As String

    sQuery = "SELECT SUM(Valor) AS Total FROM nomDetallesProceso WHERE Trabajador = " & StringDB(Me.Codigo) & " AND ClaseLaboral = " & StringDB(CStr(istrClaseLaboral)) & " AND FechaCierre BETWEEN " & FechaDB(CDate(idtFechaDesde)) & " AND " & FechaDB(CDate(idtFechaHasta))
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        vRetVal = 0
    Else
        vRetVal = GetNumeroFromVariant(rs.Fields("Total"))
    End If
    Set rs = Nothing

    Acumulado = vRetVal

End Function

Public Function ValorUltimoPago(istrClaseLaboral)
Dim vRetVal As Currency, rs As Recordset, sQuery As String
' Esta vaina funciona si los detalles acumulan por CategoriaLaboral + Proceso.
' de lo contrario, habra que utilizar una funcin de valor agregado
    
    sQuery = "SELECT TOP 1 Valor FROM nomDetallesProceso WHERE Trabajador = " & StringDB(Me.Codigo) & " AND ClaseLaboral = " & StringDB(CStr(istrClaseLaboral)) & " ORDER BY FechaCierre, ProcessID DESC"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        vRetVal = 0
    Else
        vRetVal = GetNumeroFromVariant(rs.Fields("Valor"))
    End If
    Set rs = Nothing

    ValorUltimoPago = vRetVal

End Function

Public Sub AgregarContenidoAtibutos(tAtributos As clsTablasCodigo)
    
    tAtributos.AddContenido "FechaIngreso", "*Fecha de ingreso a la empresa"
    tAtributos.AddContenido "FechaAsignacion", "*Fecha de asignacin al cargo actual"
    tAtributos.AddContenido "Sueldo", "*Sueldo base actual"
    tAtributos.AddContenido "BaseSueldo", "*Base salarial"
    tAtributos.AddContenido "NumeroDeHijos", "*Numero de hijos o cargas familiares"
    tAtributos.AddContenido "CI", "*Cedula de Identidad"
    tAtributos.AddContenido "Codigo", "*Codigo del trabajador"
    tAtributos.AddContenido "Departamento", "*Departamento en el cual presta servicios"
    tAtributos.AddContenido "Cargo", "*Cargo que desempea"
    tAtributos.AddContenido "Sexo", "*0:Femenino,1:Masculino"
    tAtributos.AddContenido "EstadoCivil", "*Estado civil del trabajador"
    tAtributos.AddContenido "FechaNacimiento", "*Fecha de Nacimiento"
    tAtributos.AddContenido "LugarNacimiento", "*Lugar de Nacimiento"

End Sub

Public Function Posiciones() As Collection
Dim pPosicion As clsHistoriaTrabajador
Dim xPosicion As clsHistoriaTrabajador
Dim retCol As Collection

    Set pPosicion = New clsHistoriaTrabajador
    Set retCol = New clsHistoriaTrabajador
    pPosicion.IniciarIterador Me.Codigo
    Do
        xPosicion = pPosicion.NextItemIterador
        If Not xPosicion Is Nothing Then
            retCol.Add xPosicion
        End If
    Loop While Not xPosicion Is Nothing
    Set pPosicion = Nothing
    
    Set Posiciones = retCol

End Function

Public Function Habilidades() As Collection
Dim pHabilidad As clsHabilidadTrabajador
Dim xHabilidad As clsHabilidadTrabajador
Dim retCol As Collection

    Set pHabilidad = New clsHabilidadTrabajador
    Set retCol = New clsHabilidadTrabajador
    pHabilidad.IniciarIteradorTrabajador Me.Codigo
    Do
        xHabilidad = pHabilidad.NextHabilidadTrabajador
        If Not xHabilidad Is Nothing Then
            retCol.Add xHabilidad
        End If
    Loop While Not xHabilidad Is Nothing
    Set pHabilidad = Nothing
    
    Set Habilidades = retCol

End Function

Public Function Observaciones() As Collection
Dim pNota As clsObservaciones
Dim xNota As clsObservaciones
Dim retCol As Collection

    Set pNota = New clsObservaciones
    pNota.IniciarIteradorTrabajador Me.Codigo, #1/1/1900#
    Set retCol = New Collection
    Do
        Set xNota = pNota.NextItem
        If Not xNota Is Nothing Then
            retCol.Add xNota
        End If
    Loop While Not xNota Is Nothing
    Set pNota = Nothing
    
    Set Observaciones = retCol

End Function

Public Function Posicion(idtFecha As Date) As clsHistoriaTrabajador
Dim pHistoria As clsHistoriaTrabajador

    Set pHistoria = New clsHistoriaTrabajador
    If Not pHistoria.LoadPosicionTrabajador(Me.Codigo, idtFecha) Then
        Set pHistoria = Nothing
    End If
    
    Set Posicion = pHistoria

End Function

Public Function DetallesProceso(ilngNumProceso As Long) As Collection
Dim pDetalle As clsDetalleProceso, pProceso As clsProcesoNomina, retCol As Collection

    Set pProceso = New clsProcesoNomina
    If Not pProceso.Load(ilngNumProceso) Then
        mAdvertencia "clsTrabajador::DetallesProceso: Proceso " & ilngNumProceso & " no localizado."
        Set pProceso = Nothing
        Set DetallesProceso = Nothing
        Exit Function
    End If
    
    Set retCol = New Collection
    If pProceso.IniciarIteradorDetallesTrabajador(Me.Codigo) Then
        Do
            Set pDetalle = pProceso.NextDetalleTrabajador
            If Not pDetalle Is Nothing Then
                retCol.Add pDetalle
            End If
        Loop While Not pDetalle Is Nothing
    End If
    
    Set pProceso = Nothing
    
    Set DetallesProceso = retCol

End Function
