VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsSesionesPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Sub LoadInstance(pDest As clsSesionPOS, rs As Recordset)
    
    If pDest Is Nothing Then Exit Sub
    
    With pDest
    .SessionID = rs.Fields("SessionID")
    .MachineID = rs.Fields("MachineID")
    .Cerrada = GetNumeroFromVariant(rs.Fields("Cerrada"))
    .usrID = rs.Fields("usrID")
    .Fecha = rs.Fields("Fecha")
    .StartTime = GetDateFromVariant(rs.Fields("StartTime"))
    .CurrentAccount = rs.Fields("CurrentAccount")
    .CurrentAmount = GetNumeroFromVariant(rs.Fields("CurrentAmount"))
    .FacturasRealizadas = GetNumeroFromVariant(rs.Fields("FacturasRealizadas"))
    .ImpuestoCobrado = GetNumeroFromVariant(rs.Fields("ImpuestoCobrado"))
    .MontoFacturado = GetNumeroFromVariant(rs.Fields("MontoFacturado"))
    .EfectivoEnCaja = GetNumeroFromVariant(rs.Fields("EfectivoEnCaja"))
    .TTCVisa = GetNumeroFromVariant(rs.Fields("TTCVisa"))
    .TTCMaster = GetNumeroFromVariant(rs.Fields("TTCMaster"))
    .TTCOtras = GetNumeroFromVariant(rs.Fields("TTCOtras"))
    .TDebito = GetNumeroFromVariant(rs.Fields("TDebito"))
    .ChequesEnCaja = GetNumeroFromVariant(rs.Fields("ChequesEnCaja"))
    .Anulaciones = GetNumeroFromVariant(rs.Fields("Anulaciones"))
    .MontoAnulaciones = GetNumeroFromVariant(rs.Fields("MontoAnulaciones"))
    .ImpuestoAnulado = GetNumeroFromVariant(rs.Fields("ImpuestoAnulado"))
    .Retiros = GetNumeroFromVariant(rs.Fields("Retiros"))
    .MontoRetirado = GetNumeroFromVariant(rs.Fields("MontoRetirado"))
    .CobrosRealizados = GetNumeroFromVariant(rs.Fields("CobrosRealizados"))
    .MontoCobrado = GetNumeroFromVariant(rs.Fields("MontoCobrado"))
    .ServicioCobrado = GetNumeroFromVariant(rs!ServicioCobrado)
    .ServicioAnulado = GetNumeroFromVariant(rs!ServicioAnulado)
    
    End With

End Sub

Private Function LoadSQL(dest As clsSesionPOS, stQuery As String) As Boolean
Dim sqlQuery As String, rs As Recordset, bRetVal As Boolean
    
    On Error GoTo ErrHandler
    
    sqlQuery = "SELECT * FROM  SesionesPos WHERE " & stQuery
    Set rs = dbHandle.OpenRecordset(sqlQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        LoadInstance dest, rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    
ResumePoint:
    If Not rs Is Nothing Then rs.Close
    Set rs = Nothing
    LoadSQL = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.LoadFromMachineID"
    Err.Clear
    bRetVal = False
    Resume ResumePoint
End Function


Public Function LoadFromMachineID(machID As Long, dest As clsSesionPOS) As Boolean
Dim stQuery As String
    stQuery = "MachineID = " & str(machID) & " AND Cerrada = 0"
    LoadFromMachineID = LoadSQL(dest, stQuery)
End Function

Public Function LoadFromUsrID(usrID As String, dest As clsSesionPOS) As Boolean
Dim stQuery As String
    stQuery = "usrID = " & StringDB(usrID) & " AND Cerrada = 0"
    LoadFromUsrID = LoadSQL(dest, stQuery)
End Function

Public Function Load(dest As clsSesionPOS, Numero As Long) As Boolean
Dim stQuery As String
    stQuery = "SessionID =" & str(Numero)
    Load = LoadSQL(dest, stQuery)
End Function

Public Function CrearSesion(MachineID As Long, usrID As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "INSERT INTO SesionesPOS ( usrID, MachineID ) SELECT " & StringDB(usrID) & ", " & NumeroDB(MachineID) & ";"

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    CrearSesion = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.CrearSesion"
    Err.Clear
    bRetVal = False
    Resume ResumePoint
End Function

Public Function MudarSesion(sUser As String, ByVal nNewMachine As Long) As Boolean
Dim bRetVal As Boolean, sQuery As String

    sQuery = "UPDATE SesionesPOS SET MachineID =" & str(nNewMachine) & " WHERE usrID = " & StringDB(sUser)
    bRetVal = True

    On Error GoTo ErrHandler

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

    MudarSesion = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "clsSesionesPOS::MudarSesion"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Sesion(Numero As Long) As clsSesionPOS
Dim pSesion As clsSesionPOS, rs As Recordset
    Set rs = dbHandle.OpenRecordset("SELECT * FROM SesionesPOS WHERE SessionID =" & str(Numero), dbOpenForwardOnly)
    If rs.EOF Then
        Set pSesion = Nothing
    Else
        Set pSesion = New clsSesionPOS
        LoadInstance pSesion, rs
    End If
    rs.Close
    Set rs = Nothing
    
    Set Sesion = pSesion
End Function
