VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSesionPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Variables publicas de la BD
Public SessionID As Long
Public MachineID As Long
Public usrID As String
Public Fecha As Date
Public StartTime As Date
Public ComprobanteAlmacen As Long
Public CurrentAccount As Long
Public CurrentAmount As Currency
Public FacturasRealizadas As Integer
Public MontoFacturado As Currency
Public ImpuestoCobrado As Currency
Public EfectivoEnCaja As Currency
Public TTCVisa As Currency
Public TTCMaster As Currency
Public TTCOtras As Currency
Public TDebito As Currency
Public ChequesEnCaja As Currency
Public Anulaciones As Integer
Public MontoAnulaciones As Currency
Public ImpuestoAnulado As Currency
Public Retiros As Integer
Public MontoRetirado As Currency
Public CobrosRealizados As Integer
Public MontoCobrado As Currency
Public ServicioCobrado As Currency
Public ServicioAnulado As Currency
Public Cerrada As Integer
Public VentasACredito As Currency
Public MontoEnCaja As Currency
Public TTCAmex As Currency
Public OtrosMedios As Currency
Public Propinas As Currency

' Para cobros a cuenta
Public pComprobante As clsBufferComprobante
Private inProcess As Boolean
Private dtFechaCobro As Date
Private nPermitirSobregiro

Public NumeroDetalle As Long
' En clrCaja3, es necesario saber el nmero del renglon para almacenar la descripcin relacionada...

Public Enum TiposRetiro
    TR_EFECTIVO = 0
    TR_PAGO = 1
    TR_EGRESO = 2
End Enum

' Variables locales
Private colDetalles As Collection
Private SubTotal1 As Currency, SubTotal2 As Currency, SubTotal3 As Currency

Public Property Get TipoEntidad() As String
    TipoEntidad = "SSN"
End Property

Public Property Get Descripcion() As String
    Descripcion = "SESION CAJA No " & Me.SessionID & ", Term.ID: " & Me.MachineID & ", OPR: " & Me.usrID
End Property

Public Property Get Concepto() As String
    Concepto = Descripcion
End Property

Public Property Get Referencia() As String
    Referencia = "SSN:" & Format(Me.SessionID, "000000")
End Property

Public Function LoadByReferenciaISDOC(istrRef As String) As Boolean
Dim lNumero As Long
  lNumero = Val(right(istrRef, Len(istrRef) - 4)) ' 4 = Len("SSN:)
  If Not Me.Load(lNumero) Then
    LoadByReferenciaISDOC = False
  Else
    LoadByReferenciaISDOC = True
  End If

End Function

Public Sub Show()
End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
End Sub

Public Function TotalSalidas() As Currency
  TotalSalidas = Me.MontoRetirado + Me.MontoAnulaciones + Me.ImpuestoAnulado + Me.ServicioAnulado
End Function

Public Function TotalEntradas() As Currency
  TotalEntradas = Me.MontoFacturado + Me.MontoCobrado + Me.ImpuestoCobrado + Me.ServicioCobrado + Me.Propinas
End Function

Public Function Load(lNumero As Long) As Boolean
    
    Load = Sesiones.Load(Me, lNumero)

End Function

Public Sub CrearSesion(MachineID As Long, usrID As String)
    
    If MachineID <= 0 Then
        mAdvertencia "ERROR FATAL: Identificacion de mquina invlida en SesionPOS::CrearSesion"
        End
    End If

    Sesiones.CrearSesion MachineID, usrID

End Sub

Public Sub ActivarSesion()
    
#If Nomina = 0 Then
    Set colDetalles = Sesiones.Detalles(Me.SessionID)   ' Carga cualesquiera detalles hubiera
#End If

End Sub

' Elementos de interfaz con la aplicacion:

    Private Function MudarSesion(sUser As String, ByVal nNewMachine As Long) As Boolean
    Dim bRetVal As Boolean, sQuery As String

        sQuery = "UPDATE SesionesPOS SET MachineID =" & str(nNewMachine) & " WHERE usrID = " & StringDB(sUser)
        bRetVal = True

        On Error GoTo ErrHandler

        dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

        MudarSesion = bRetVal
        Exit Function

ErrHandler:

        ReportarError False, Err.Number, Err.Description, "clsSesionesPOS::MudarSesion"
        bRetVal = False
        Resume ResumePoint

    End Function

Public Function IniciarSesion(usrID As String, Optional bPermitirMudanza As Boolean = False, Optional nMachID As Long = 0) As Boolean
Dim machID As Long

  machID = mMachineID.MachineID
  If machID <= 0 Then
    mAdvertencia "ERROR FATAL: Identificacion de mquina invlida en SesionPOS::CrearSesion"
    End
  End If

  If Sesiones.LoadFromUsrID(usrID, Me) Then
    
    If machID <> Me.MachineID Then
      If Me.FacturasRealizadas > 0 Then ' no se permite la mudanza de sesiones con facturas en proceso...
        mAdvertencia "Tiene una sesin ABIERTA y ACTIVA en el terminal " & Me.MachineID
        bPermitirMudanza = False
        IniciarSesion = False
        Exit Function
      End If
      
      If Not bPermitirMudanza Then
        mAdvertencia "Ya tiene una sesin en otro terminal..." & Chr(13) & "Debe cerrarla antes de abrir otra"
        If lmUsuarios.VerificarUsuario("Autorizar mudanza de sesion") < 5 Then
          IniciarSesion = False
          Exit Function
        End If
      End If
      
      If Not MudarSesion(usrID, machID) Then
        IniciarSesion = False
        Exit Function
      End If
    End If
  Else
    If Sesiones.LoadFromMachineID(machID, Me) Then
      If usrID = GetSetting("ClearLight", "General", "UserName") Then bPermitirMudanza = True
      If Not bPermitirMudanza Then
        If VerificarUsuario("Autorizar mltiples sesiones en este terminal") < 5 Then
          IniciarSesion = False
          Exit Function
        End If
      End If
    End If

    CrearSesion machID, usrID
    Sesiones.LoadFromUsrID usrID, Me
  End If
  
  ActivarSesion       ' Carga los detalles...
  IniciarSesion = True

End Function

Public Function RegistrarRetiro( _
  iTipo As TiposRetiro, _
  ivmMonto As Currency, _
  sDescripcion As String, _
  Optional colSubDocs As Collection = Nothing, _
  Optional sTipoEntidad As String = "", _
  Optional sCodigoEntidad As String = "", _
  Optional sTipoDocumento As String = "", _
  Optional iNumeroDocumento As Long = 0, _
  Optional FechaTrans As Date = #1/1/1700#) As Boolean
Dim pRetiro As clsRetiroPOS, bRetVal As Boolean, sqlCommand As String
Dim pMovCaja As CMovimientoCaja, fechaMovCaja As Date

  Set pRetiro = New clsRetiroPOS
  bRetVal = pRetiro.RegistrarSalida(Me.SessionID, iTipo, ivmMonto, sDescripcion)
  Set pRetiro = Nothing
  
  fechaMovCaja = FechaTrans
  If Year(fechaMovCaja) = 1700 Then
    fechaMovCaja = Date
  End If

  If Not bRetVal Then
    RegistrarRetiro = False
    Exit Function
  End If

  Me.Retiros = Me.Retiros + 1
  Me.MontoRetirado = Me.MontoRetirado + ivmMonto

  sqlCommand = "UPDATE SesionesPOS SET Retiros = Retiros + 1, MontoRetirado = MontoRetirado +" & str(ivmMonto) & " WHERE SessionID =" & str(Me.SessionID)
  
  On Error GoTo ErrHandler
  dbHandle.Execute sqlCommand, dbFailOnError

  If iTipo = TR_EGRESO Or iTipo = TR_PAGO Then
    Set pMovCaja = New CMovimientoCaja
    bRetVal = pMovCaja.Save(0, ivmMonto, sTipoEntidad, sCodigoEntidad, sTipoDocumento, iNumeroDocumento, fechaMovCaja, Nothing, sDescripcion)
    If Not colSubDocs Is Nothing Then
    Dim pSubDoc As CDocsMovCaja
      For Each pSubDoc In colSubDocs
        pMovCaja.AddConcepto pSubDoc.Debitos, pSubDoc.Creditos, pSubDoc.TipoDoc, pSubDoc.NumeroDoc
      Next
    End If
    Set pMovCaja = Nothing
  End If

ResumePoint:
  If bRetVal Then
    If LoadScriptFile("postRetiroPOS.vbs") Then
      pScript.ExecuteStatement "iTipo = " & str(iTipo)
      pScript.ExecuteStatement "ivmMonto = " & str(ivmMonto)
      pScript.ExecuteStatement "sDescripcion = """ & Replace(sDescripcion, Chr(34), Chr(34) & Chr(34)) & """"
      pScript.AddObject "Factoria", New CFactoria
      On Error Resume Next
      pScript.Run "Main"
      pScript.Reset
    End If
  End If
  RegistrarRetiro = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "SesionesPOS.RegistrarRetiro"
  bRetVal = False
  Err.Clear
  Resume ResumePoint
    
End Function

Public Sub Reinit()
    
    Me.CurrentAmount = 0
    Me.CurrentAccount = 0
    Set colDetalles = Nothing
    Set colDetalles = New Collection

End Sub

Private Sub Class_Initialize()
  nPermitirSobregiro = Val(GetSetting("ClearLight", "General", "SobregiroPOS", "0"))
  If nPermitirSobregiro < 0 Or nPermitirSobregiro > 2 Then
    mAdvertencia "Valor invlido para ""SobregiroPOS"": ignorado::clsSesionPOS"
    nPermitirSobregiro = 0
  End If
End Sub

