VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsScript"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const TABLE_NAME = "nomScripts"

Public Codigo As String
Public Descripcion As String
Public codePostTrabajador As String
Public codeVerificarRestricciones As String
Public codeBaseScript As String
Public codeTrabajadorElegible

Public Filtros As Collection
Public AsigDed As Collection
Public Recibos As Collection

Public TipoEntidad As String

Private Interprete As Object
Private rsIterador As Recordset
Private pProceso As clsProcesoNomina
Private nNextAsigDed As Integer

Public Sub Eliminar()
Dim sQuery As String

  On Error GoTo ErrHandler
  StartTransaction
  sQuery = "DELETE FROM nomAsigDedScript WHERE CodigoScript = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery, dbFailOnError
  sQuery = "DELETE FROM nomFiltrosScript WHERE CodigoScript = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery, dbFailOnError
  sQuery = "DELETE FROM nomRecibosScript WHERE CodigoScript = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery, dbFailOnError
  sQuery = "DELETE FROM nomScripts WHERE Codigo = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery, dbFailOnError
  CommitTransaction

ResumePoint:
  Exit Sub

ErrHandler:
  AbortTransaction
  ReportarError False, Err.Number, Err.Description, "clsScripts::Eliminar"
  Resume ResumePoint

End Sub

Private Function LoadFiltros(istrCodigoScript As String) As Collection
Dim pRetCol As Collection, pFiltro As clsFiltro

    Set pFiltro = New clsFiltro
    Set pRetCol = pFiltro.FiltrosScript(istrCodigoScript)
    Set LoadFiltros = pRetCol
    Set pFiltro = Nothing

End Function

Private Function LoadAsigded(istrCodigoScript As String) As Collection
Dim pRetCol As Collection, pAsigDed As clsAsigDed

    Set pAsigDed = New clsAsigDed
    Set pRetCol = pAsigDed.AsigDedScript(istrCodigoScript)
    Set LoadAsigded = pRetCol
    Set pAsigDed = Nothing

End Function

Private Function LoadRecibos(istrCodigo As String) As Collection
Dim pRetCol As Collection, pRef As clsDatosRecibo, rs As Recordset

    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomRecibosScript WHERE COdigoScript = " & StringDB(Me.Codigo) & " ORDER BY Filename", dbOpenForwardOnly)
    Set pRetCol = New Collection
    Do While Not rs.EOF
        Set pRef = New clsDatosRecibo
        pRef.NombreArchivo = rs.Fields("FileName")
        pRef.NombrePrinter = rs.Fields("PrinterName")
        pRetCol.Add pRef
        rs.MoveNext
    Loop

ResumePoint:
    Set rs = Nothing
    Set LoadRecibos = pRetCol
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsScript.LoadRecibos"
    Set pRetCol = Nothing
    Resume ResumePoint

End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsScript = Nothing)
Dim lpDest As clsScript

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With lpDest
    .Codigo = GetStringFromVariant(rs.Fields("Codigo"))
    .Descripcion = GetStringFromVariant(rs.Fields("DescripcionScript"))
    .codePostTrabajador = Field2Function(GetStringFromVariant(rs.Fields("codePostTrabajador")))
    .codeVerificarRestricciones = Field2Function(GetStringFromVariant(rs.Fields("codeVerificarRestricciones")))
    .codeBaseScript = Field2Function(GetStringFromVariant(rs.Fields("codeBaseScript")))
    .codeTrabajadorElegible = Field2Function(GetStringFromVariant(rs.Fields("codeTrabajadorElegible")))

    Set .Filtros = LoadFiltros(.Codigo)
    Set .Recibos = LoadRecibos(.Codigo)
    Set .AsigDed = LoadAsigded(.Codigo)
    
    End With

End Sub

Private Sub Class_Initialize()

    Set Interprete = CreateObject("ScriptControl")

End Sub

Private Sub Class_Terminate()

    Set Interprete = Nothing

End Sub

Public Sub CancelUpdate()

    AbortTransaction

End Sub

Public Function StartUpdate(istrDescripcion As String, istrRestricciones As String, istrAfterWorker As String, istrBaseScript As String, istrTrabajadorElegible As String) As Boolean
Dim isOk As Boolean, sQuery As String

    On Error GoTo ErrHandler
    
    isOk = True
    StartTransaction

    nNextAsigDed = 1

    sQuery = "UPDATE nomScripts SET descripcionScript = " & StringDB(istrDescripcion) & ", "
    sQuery = sQuery & "codePostTrabajador = " & StringDB(Function2Field(istrAfterWorker)) & ", "
    sQuery = sQuery & "codeVerificarRestricciones = " & StringDB(Function2Field(istrRestricciones)) & ", "
    sQuery = sQuery & "codeBaseScript = " & StringDB(Function2Field(istrBaseScript)) & ", "
    sQuery = sQuery & "codeTrabajadorElegible = " & StringDB(Function2Field(istrTrabajadorElegible))
    sQuery = sQuery & "WHERE Codigo = " & StringDB(Me.Codigo)
    
    dbHandle.Execute sQuery, dbFailOnError

    dbHandle.Execute "DELETE * FROM nomRecibosScript WHERE CodigoScript = " & StringDB(Me.Codigo), dbFailOnError
    dbHandle.Execute "DELETE * FROM nomFiltrosScript WHERE CodigoScript = " & StringDB(Me.Codigo), dbFailOnError
    dbHandle.Execute "DELETE * FROM nomAsigdedScript WHERE CodigoScript = " & StringDB(Me.Codigo), dbFailOnError

ResumePoint:

    StartUpdate = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsScript::StartUpdate"
    AbortTransaction
    isOk = False
    Resume ResumePoint

End Function

Public Function StartCreation(istrCodigo As String, istrDescripcion As String, istrRestricciones As String, istrAfterWorker As String, istrBaseScript As String, istrTrabajadorElegible As String) As Boolean
Dim isOk As Boolean, sQuery As String
    
    On Error GoTo ErrHandler
    isOk = True
    StartTransaction

    nNextAsigDed = 1
    
    Me.Codigo = istrCodigo
    sQuery = "INSERT INTO nomScripts (Codigo, descripcionScript, codePostTrabajador, codeVerificarRestricciones, codeBaseScript, codeTrabajadorElegible) SELECT "
    sQuery = sQuery & StringDB(istrCodigo) & ", "
    sQuery = sQuery & StringDB(istrDescripcion) & ", "
    sQuery = sQuery & StringDB(Function2Field(istrAfterWorker)) & ", "
    sQuery = sQuery & StringDB(Function2Field(istrRestricciones)) & ", "
    sQuery = sQuery & StringDB(Function2Field(istrBaseScript)) & ", "
    sQuery = sQuery & StringDB(Function2Field(istrTrabajadorElegible))

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    StartCreation = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsScript::StartCreation"
    AbortTransaction
    Resume ResumePoint

End Function

Public Function Load(istrCodigo As String) As Boolean
Dim rs As Recordset, isOk As Boolean

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomScripts WHERE Codigo = " & StringDB(istrCodigo), dbOpenForwardOnly)
    If rs.EOF Then
        isOk = False
    Else
        isOk = True
        LoadInstance rs
    End If
    Set rs = Nothing

ResumePoint:
    Load = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsScript::Load"
    Resume ResumePoint

End Function

Public Function ExisteCodigo(istrCodigo As String) As Boolean
Dim rs As Recordset, nResult As Long

    Set rs = dbHandle.OpenRecordset("SELECT Count(Codigo) AS qItems FROM nomScripts WHERE Codigo = " & StringDB(istrCodigo), dbOpenForwardOnly)
    If rs.EOF Then
        nResult = 0
    Else
        nResult = GetNumeroFromVariant(rs.Fields("qItems"))
    End If
    Set rs = Nothing
    
    ExisteCodigo = (nResult > 0)

End Function

Public Function Validar(istrCodigo As String) As Boolean
Dim fScript As frmScripts

    If ExisteCodigo(istrCodigo) Then
        Validar = True
        Exit Function
    End If

    If Not EstaAutorizado(UsuarioActivo.Codigo, DEF_SCRIPTS) Then
        Validar = False
        Exit Function
    End If

    Set fScript = New frmScripts
    fScript.txCodigo.Text = istrCodigo
    fScript.SetContexto 3
    While fScript.Visible: DoEvents: Wend
    Unload fScript
    Set fScript = Nothing

    Validar = ExisteCodigo(istrCodigo)

End Function

Public Sub CommitUpdate()

    CommitTransaction

End Sub

Private Function AddItem(strTableName As String, istrCodigo As String) As Boolean
Dim sQuery As String, isOk As Boolean

    On Error GoTo ErrHandler
    
    isOk = True
    
    sQuery = "INSERT INTO " & strTableName & " VALUES (" & StringDB(Me.Codigo) & ", " & StringDB(istrCodigo) & ")"
    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:
    AddItem = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsScript::AddItem(" & strTableName & ", " & istrCodigo & ")"
    Resume ResumePoint

End Function

Public Function AddAsigDed(istrCodigo As String) As Boolean

Dim sQuery As String, isOk As Boolean

    On Error GoTo ErrHandler
    
    isOk = True
    
    sQuery = "INSERT INTO nomAsigDedScript (CodigoScript, CodigoAsigDed, Orden) VALUES (" & StringDB(Me.Codigo) & ", " & StringDB(istrCodigo) & ", " & NumeroDB(nNextAsigDed) & ")"
    dbHandle.Execute sQuery, dbFailOnError
    nNextAsigDed = nNextAsigDed + 1

ResumePoint:
    AddAsigDed = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsScript::AddSigDed"
    Resume ResumePoint

End Function

Public Function AddFiltro(istrCodigo As String) As Boolean

    AddFiltro = AddItem("nomFiltrosScript", istrCodigo)

End Function

Public Function AddRecibo(istrNombre As String, istrPrinter As String) As Boolean
Dim sQuery As String, isOk As Boolean

    On Error GoTo ErrHandler
    
    isOk = True
    
    sQuery = "INSERT INTO nomRecibosScript (CodigoScript, FileName, PrinterName) SELECT " & StringDB(Me.Codigo) & ", " & StringDB(istrNombre) & ", " & StringDB(istrPrinter)
    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:
    AddRecibo = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsScript::AddRecibo"
    Resume ResumePoint

End Function

Public Function StartIteradorTrabajadores() As Boolean
Dim bResult As Boolean

    On Error GoTo ErrHandler
    bResult = True
    Set rsIterador = dbHandle.OpenRecordset(SQLFromCriterios(Me.Filtros), dbOpenForwardOnly)

ResumePoint:
    StartIteradorTrabajadores = bResult
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsScript::StartIteradorTrabajadores"
    Set rsIterador = Nothing
    bResult = False
    Resume ResumePoint

End Function

Public Function NextTrabajador() As clsTrabajador
Dim pTrabajador As New clsTrabajador

    On Error GoTo ErrHandler
    
    If rsIterador.EOF Then
        Set rsIterador = Nothing
        Set NextTrabajador = Nothing
        Exit Function
    Else
        Set pTrabajador = New clsTrabajador
        pTrabajador.LoadInstance rsIterador
        rsIterador.MoveNext
    End If

ResumePoint:
    Set NextTrabajador = pTrabajador
    Exit Function

ErrHandler:
    If rsIterador Is Nothing Then
        Set NextTrabajador = Nothing
        Err.Clear
        Exit Function
    End If
    
    On Error GoTo 0
    Resume

End Function

Public Function UltimaEjecucion() As clsProcesoNomina
Dim sQuery As String, rs As Recordset, pProceso As clsProcesoNomina

    sQuery = "SELECT TOP 1 * FROM nomProcesos WHERE CodigoScript = " & StringDB(Me.Codigo) & " ORDER BY FechaCierre DESC"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        Set pProceso = Nothing
    Else
        Set pProceso = New clsProcesoNomina
        pProceso.LoadInstance rs
    End If
    Set rs = Nothing
    
    Set UltimaEjecucion = pProceso

End Function
